/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.general.Loose;
import csk.taprats.general.Sort;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Polygon;
import csk.taprats.geometry.Transform;
import csk.taprats.geometry.event_info;
import csk.taprats.geometry.seg;
import csk.taprats.toolkit.GeoGraphics;
import csk.taprats.toolkit.GeoView;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;

public class Truncate
extends GeoView {
    private Polygon pgon = null;
    private Polygon pgon_temp = null;
    private Point p1 = null;
    private Point p2 = null;
    private boolean set_p1 = true;

    public static final Vector truncateSegment(Point point, Point point2, Polygon polygon) {
        Object object;
        double d;
        Vector<seg> vector = new Vector<seg>();
        int n = polygon.numVertices();
        Vector vector2 = new Vector();
        Transform transform = Transform.matchLineSegment(point, point2);
        transform.invertD();
        Point point3 = null;
        Point point4 = transform.apply(polygon.getVertex(n - 1));
        int n2 = 0;
        while (n2 < n) {
            point3 = point4;
            point4 = transform.apply(polygon.getVertex(n2));
            if (Loose.zero(point3.getY()) && Loose.zero(point4.getY())) {
                double d2;
                d = point3.getX();
                if (d > (d2 = point4.getX())) {
                    double d3 = d;
                    d = d2;
                    d2 = d3;
                }
                if (d < 0.9999999 && d2 > 1.0E-7) {
                    vector.addElement(new seg(Math.max(d, 0.0), Math.min(d2, 1.0)));
                }
            }
            ++n2;
        }
        Sort.quickSort(vector, 0, vector.size() - 1, seg.getComparator());
        d = 0.0;
        int n3 = 0;
        while (n3 < vector.size()) {
            object = (seg)vector.elementAt(n3);
            if (Loose.equals(d, ((seg)object).start)) {
                d = ((seg)object).end;
            } else {
                Vector vector3 = Truncate.truncateBase(point.convexSum(point2, d), point.convexSum(point2, ((seg)object).start), polygon);
                int n4 = 0;
                while (n4 < vector3.size()) {
                    vector2.addElement(vector3.elementAt(n4));
                    ++n4;
                }
                d = ((seg)object).end;
            }
            ++n3;
        }
        if (Loose.lessThan(d, 1.0)) {
            object = Truncate.truncateBase(point.convexSum(point2, d), point2, polygon);
            int n5 = 0;
            while (n5 < ((Vector)object).size()) {
                vector2.addElement(((Vector)object).elementAt(n5));
                ++n5;
            }
        }
        return vector2;
    }

    private static final boolean doesSegmentStartIn(Point point, Point point2, Polygon polygon) {
        int n = polygon.numVertices();
        Point point3 = null;
        Point point4 = polygon.getVertex(n - 1);
        int n2 = 0;
        while (n2 < n) {
            Cloneable cloneable;
            Cloneable cloneable2;
            point3 = point4;
            point4 = polygon.getVertex(n2);
            if (Loose.equals(point3, point)) {
                cloneable2 = polygon.getVertex((n2 + n - 1) % n);
                cloneable = Transform.basisChange(point3, (Point)cloneable2, point4);
                Point point5 = ((Transform)cloneable).apply(point2);
                return point5.getX() > 1.0E-7 && point5.getY() > 1.0E-7;
            }
            cloneable2 = Transform.matchLineSegment(point3, point4);
            ((Transform)cloneable2).invertD();
            cloneable = ((Transform)cloneable2).apply(point);
            if (Loose.zero(((Point)cloneable).getY()) && Loose.greaterThan(((Point)cloneable).getX(), 0.0) && Loose.lessThan(((Point)cloneable).getX(), 1.0)) {
                Point point6 = ((Transform)cloneable2).apply(point2);
                return point6.getY() > 0.0;
            }
            ++n2;
        }
        return polygon.containsPoint(point);
    }

    private static final Vector truncateBase(Point point, Point point2, Polygon polygon) {
        int n = polygon.numVertices();
        Vector<Point> vector = new Vector<Point>();
        Vector<event_info> vector2 = new Vector<event_info>();
        Transform transform = Transform.matchLineSegment(point, point2);
        transform.invertD();
        Point point3 = null;
        Point point4 = transform.apply(polygon.getVertex(n - 1));
        int n2 = 0;
        while (n2 < n) {
            double d;
            point3 = point4;
            point4 = transform.apply(polygon.getVertex(n2));
            if (point3.getY() < -1.0E-7 && point4.getY() > 1.0E-7 || point3.getY() > 1.0E-7 && point4.getY() < -1.0E-7) {
                d = point3.getY() / (point3.getY() - point4.getY());
                double d2 = point3.getX() + d * (point4.getX() - point3.getX());
                if (!(d2 < 1.0E-7) && !(d2 > 0.9999999)) {
                    vector2.addElement(new event_info(d2, true));
                }
            } else if (Loose.zero(point3.getY()) && !((d = point3.getX()) < 1.0E-7) && !(d > 0.9999999)) {
                Point point5 = transform.apply(polygon.getVertex((n2 + n - 1) % n));
                if (point5.getY() < 0.0 && point4.getY() > 0.0 || point5.getY() > 0.0 && point4.getY() < 0.0) {
                    vector2.addElement(new event_info(d, true));
                } else {
                    vector2.addElement(new event_info(d, false));
                }
            }
            ++n2;
        }
        Sort.quickSort(vector2, 0, vector2.size() - 1, event_info.getComparator());
        boolean bl = Truncate.doesSegmentStartIn(point, point2, polygon);
        Point point6 = point;
        int n3 = 0;
        while (n3 < vector2.size()) {
            event_info event_info2 = (event_info)vector2.elementAt(n3);
            double d = event_info2.where;
            Point point7 = point.convexSum(point2, d);
            if (bl) {
                vector.add(point6);
                vector.add(point7);
            }
            point6 = point7;
            if (event_info2.reverses) {
                bl = !bl;
            }
            ++n3;
        }
        if (bl) {
            vector.add(point6);
            vector.add(point2);
        }
        return vector;
    }

    private static final Vector getPolygonKeepers(Vector vector, Polygon polygon) {
        int n = polygon.numVertices();
        boolean bl = false;
        Point point = null;
        Point point2 = polygon.getVertex(n - 1);
        Vector<Point> vector2 = new Vector<Point>();
        int n2 = 0;
        while (n2 < n) {
            double d;
            Vector<event_info> vector3 = new Vector<event_info>();
            point = point2;
            point2 = polygon.getVertex(n2);
            Transform transform = Transform.matchLineSegment(point, point2);
            transform.invertD();
            int n3 = 0;
            while (n3 < vector.size()) {
                Point point3 = transform.apply((Point)vector.elementAt(n3));
                if (Loose.zero(point3.getY())) {
                    double d2 = point3.getX();
                    if (d2 > -1.0E-7 && d2 < 0.9999999) {
                        vector3.addElement(new event_info(d2, true));
                    }
                } else {
                    Point point4 = transform.apply((Point)vector.elementAt(n3 + 1));
                    if (Loose.zero(point4.getY()) && (d = point4.getX()) > -1.0E-7 && d < 0.9999999) {
                        vector3.addElement(new event_info(d, false));
                    }
                }
                n3 += 2;
            }
            vector3.addElement(new event_info(0.0, false));
            vector3.addElement(new event_info(1.0, false));
            Sort.quickSort(vector3, 0, vector3.size() - 1, event_info.getComparator());
            if (n2 == 0) {
                int n4 = 1;
                while (n4 < vector3.size() - 1) {
                    event_info event_info2 = (event_info)vector3.elementAt(n4);
                    d = event_info2.where;
                    if (d > 1.0E-7 && d < 0.9999999) {
                        double d3 = ((event_info)vector3.elementAt((int)(n4 - 1))).where;
                        double d4 = ((event_info)vector3.elementAt((int)(n4 + 1))).where;
                        if (d > d3 + 1.0E-7 && d < d4 - 1.0E-7) {
                            bl = event_info2.reverses != (n4 % 2 == 0);
                            break;
                        }
                    }
                    ++n4;
                }
            }
            double d5 = 0.0;
            int n5 = 0;
            while (n5 < vector3.size()) {
                event_info event_info3 = (event_info)vector3.elementAt(n5);
                if (Loose.equals(event_info3.where, d5)) {
                    d5 = event_info3.where;
                    bl = !bl;
                } else {
                    if (bl) {
                        vector2.addElement(point.convexSum(point2, event_info3.where));
                        vector2.addElement(point.convexSum(point2, d5));
                    }
                    d5 = event_info3.where;
                    bl = !bl;
                }
                ++n5;
            }
            ++n2;
        }
        return vector2;
    }

    public static final Vector truncate(Vector vector, Polygon polygon) {
        Cloneable cloneable;
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            cloneable = (Point)vector.elementAt(n);
            Point point = (Point)vector.elementAt(n + 1);
            Vector vector3 = Truncate.truncateSegment((Point)cloneable, point, polygon);
            int n2 = 0;
            while (n2 < vector3.size()) {
                vector2.addElement(vector3.elementAt(n2));
                ++n2;
            }
            n += 2;
        }
        cloneable = Truncate.getPolygonKeepers(vector2, polygon);
        int n3 = 0;
        while (n3 < ((Vector)cloneable).size()) {
            vector2.addElement(((Vector)cloneable).elementAt(n3));
            ++n3;
        }
        return vector2;
    }

    public void redraw(GeoGraphics geoGraphics) {
        if (this.pgon != null) {
            geoGraphics.setColor(Color.red);
            geoGraphics.drawPolygon(this.pgon, false);
            geoGraphics.setColor(Color.black);
            if (this.p1 != null && this.p2 != null) {
                Vector vector = new Vector(2);
                vector.addElement(this.p1);
                vector.addElement(this.p2);
                vector = Truncate.truncate(vector, this.pgon);
                int n = 0;
                while (n < vector.size()) {
                    geoGraphics.drawLine((Point)vector.elementAt(n), (Point)vector.elementAt(n + 1));
                    n += 2;
                }
            }
        }
    }

    Truncate() {
        super(0.0, 1.0, 1.0);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (GeoView.isShift(mouseEvent)) {
                    return;
                }
                Point point = Truncate.this.screenToWorld(mouseEvent.getX(), mouseEvent.getY());
                if (GeoView.isButton(mouseEvent, 1)) {
                    Truncate.this.pgon_temp = new Polygon();
                    Truncate.this.pgon_temp.addVertex(point);
                } else if (GeoView.isButton(mouseEvent, 2)) {
                    if (Truncate.this.set_p1) {
                        Truncate.this.p1 = point;
                    } else {
                        Truncate.this.p2 = point;
                    }
                    Truncate.this.set_p1 = !Truncate.this.set_p1;
                    Truncate.this.forceRedraw();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (Truncate.this.pgon_temp != null) {
                    Truncate.this.pgon_temp.addVertex(Truncate.this.screenToWorld(mouseEvent.getX(), mouseEvent.getY()));
                    Truncate.this.pgon = Truncate.this.pgon_temp;
                    Truncate.this.pgon_temp = null;
                    Truncate.this.forceRedraw();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (Truncate.this.pgon_temp != null) {
                    Point point = Truncate.this.screenToWorld(mouseEvent.getX(), mouseEvent.getY());
                    Truncate.this.pgon_temp.addVertex(point);
                }
            }
        });
    }

    public static final void main(String[] stringArray) {
        Truncate truncate = new Truncate();
        truncate.setSize(400, 400);
        Frame frame = new Frame();
        frame.add("Center", truncate);
        frame.pack();
        frame.show();
    }
}

