/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.geometry.Edge;
import csk.taprats.geometry.Map;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Transform;
import csk.taprats.geometry.neighbour;
import java.util.Enumeration;

public class Vertex {
    Map map;
    Point pos;
    Object data;
    neighbour edges;
    int num_edges;
    Vertex copy;

    Vertex(Map map, Point point) {
        this.map = map;
        this.pos = point;
        this.num_edges = 0;
        this.data = null;
        this.edges = null;
        this.copy = null;
    }

    public final Point getPosition() {
        return this.pos;
    }

    public final Object getData() {
        return this.data;
    }

    public final void setData(Object object) {
        this.data = object;
    }

    public final Map getMap() {
        return this.map;
    }

    public final int numNeighbours() {
        return this.num_edges;
    }

    final Enumeration internalNeighbours() {
        return new NeighbourEnum(this.edges);
    }

    public final Enumeration neighbours() {
        return new EdgeEnum(this.edges);
    }

    public final Edge[] getBeforeAndAfter(Edge edge) {
        neighbour neighbour2 = this.edges;
        neighbour neighbour3 = neighbour2.next;
        neighbour neighbour4 = neighbour3.next;
        do {
            if (neighbour3.edge.equals(edge)) {
                Edge[] edgeArray = new Edge[]{neighbour2.edge, neighbour4.edge};
                return edgeArray;
            }
            neighbour2 = neighbour3;
            neighbour3 = neighbour4;
            neighbour4 = neighbour4.next;
        } while (neighbour2 != this.edges);
        return null;
    }

    final neighbour findNeighbour(Vertex vertex) {
        if (this.edges == null) {
            return null;
        }
        neighbour neighbour2 = this.edges;
        do {
            if (!neighbour2.edge.getOther(this).equals(vertex)) continue;
            return neighbour2;
        } while ((neighbour2 = neighbour2.next) != this.edges);
        return null;
    }

    public final Edge getNeighbour(Vertex vertex) {
        neighbour neighbour2 = this.findNeighbour(vertex);
        if (neighbour2 != null) {
            return neighbour2.edge;
        }
        return null;
    }

    public final boolean connectsTo(Vertex vertex) {
        return this.findNeighbour(vertex) != null;
    }

    final void insertEdge(Edge edge) {
        neighbour neighbour2 = new neighbour(this, edge);
        if (this.edges != null) {
            double d;
            neighbour neighbour3;
            double d2 = neighbour2.angle;
            neighbour neighbour4 = this.edges;
            double d3 = neighbour4.angle;
            do {
                neighbour3 = neighbour4.next;
                d = neighbour3.angle;
                boolean bl = false;
                if (d > d3) {
                    bl = d3 <= d2 && d2 <= d;
                } else {
                    boolean bl2 = bl = d3 <= d2 || d2 <= d;
                }
                if (bl) {
                    neighbour2.next = neighbour3;
                    neighbour4.next = neighbour2;
                    ++this.num_edges;
                    return;
                }
                d3 = d;
            } while ((neighbour4 = neighbour3) != this.edges);
            System.err.println("=== Illegal vertex insertion");
            System.err.println("from " + edge.getV1().getPosition() + " to " + edge.getV2().getPosition());
            neighbour4 = this.edges;
            d3 = neighbour4.angle;
            System.err.println("Angle: " + d2);
            do {
                neighbour3 = neighbour4.next;
                d = neighbour3.angle;
                System.err.println("   " + d3 + " -> " + d);
                d3 = d;
            } while ((neighbour4 = neighbour3) != this.edges);
            throw new InternalError("Unable to insert Edge in geometry.Vertex");
        }
        neighbour2.next = neighbour2;
        this.edges = neighbour2;
        this.num_edges = 1;
    }

    final void removeEdge(Edge edge) {
        neighbour neighbour2;
        if (this.edges == null) {
            return;
        }
        neighbour neighbour3 = this.edges;
        do {
            neighbour2 = neighbour3.next;
            if (!neighbour2.edge.equals(edge)) continue;
            if (this.num_edges == 1) {
                this.edges = null;
                this.num_edges = 0;
                return;
            }
            neighbour3.next = neighbour2.next;
            this.edges = neighbour3;
            --this.num_edges;
            return;
        } while ((neighbour3 = neighbour2) != this.edges);
    }

    final void applyRigidMotion(Transform transform) {
        this.pos = transform.apply(this.pos);
        if (this.edges == null) {
            return;
        }
        neighbour neighbour2 = this.edges;
        do {
            neighbour2.recalcAngle(this);
        } while ((neighbour2 = neighbour2.next) != this.edges);
    }

    void swapEdge(Vertex vertex, Edge edge) {
        neighbour neighbour2 = this.findNeighbour(vertex);
        neighbour2.edge = edge;
    }

    public static final void main(String[] stringArray) {
        int n = 0;
        while (n < 100) {
            double d = (double)n / 100.0 * 2.0 * Math.PI;
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = neighbour.pseudoAtan2(d2, d3);
            System.out.println(d4);
            ++n;
        }
    }

    class EdgeEnum
    extends NeighbourEnum {
        EdgeEnum(neighbour neighbour2) {
            super(neighbour2);
        }

        public Object nextElement() {
            neighbour neighbour2 = (neighbour)super.nextElement();
            return neighbour2.edge;
        }
    }

    class NeighbourEnum
    implements Enumeration {
        private neighbour start;
        private neighbour cur;

        NeighbourEnum(neighbour neighbour2) {
            this.start = neighbour2;
            this.cur = neighbour2;
        }

        public boolean hasMoreElements() {
            return this.cur != null;
        }

        public Object nextElement() {
            neighbour neighbour2 = this.cur;
            this.cur = this.cur.next;
            if (this.cur.equals(this.start)) {
                this.cur = null;
            }
            return neighbour2;
        }
    }
}

