/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.geometry.Edge;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Vertex;

class neighbour {
    Edge edge;
    double angle;
    neighbour next;

    neighbour(Vertex vertex, Edge edge) {
        this.edge = edge;
        this.recalcAngle(vertex);
        this.next = null;
    }

    void recalcAngle(Vertex vertex) {
        Vertex vertex2 = this.edge.getOther(vertex);
        Point point = vertex2.getPosition().subtract(vertex.getPosition());
        point.normalizeD();
        this.angle = neighbour.pseudoAtan2(point.getX(), point.getY());
    }

    static double pseudoAtan2(double d, double d2) {
        if (d > 0.0) {
            if (d2 >= 0.0) {
                return d2 * 0.25;
            }
            return 1.0 + d2 * 0.25;
        }
        if (d2 > 0.0) {
            return 0.25 * (2.0 - d2);
        }
        return 0.5 - d2 * 0.25;
    }
}

