/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.toolkit;

import csk.taprats.Taprats;
import csk.taprats.general.Comparison;
import csk.taprats.general.Sort;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Polygon;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;

public class DXF {
    private Writer wr;
    private PrintWriter pw;

    public DXF(Writer writer) {
        this.pw = new PrintWriter(writer);
        this.pw.print("0\nSECTION\n2\nHEADER\n0\nENDSEC\n");
        this.pw.print("999\nGenerated automatically by Taprats version " + Taprats.getVersionString() + "\n");
        this.pw.print("0\nSECTION\n2\nENTITIES\n");
    }

    public void drawLine(Point point, Point point2) {
        this.pw.print("0\nLINE\n8\nC2\n");
        this.pw.print("10\n");
        this.pw.println(point.getX());
        this.pw.print("20\n");
        this.pw.println(point.getY());
        this.pw.print("11\n");
        this.pw.println(point2.getX());
        this.pw.print("21\n");
        this.pw.println(point2.getY());
    }

    public void drawLines(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Point point = (Point)vector.elementAt(n);
            Point point2 = (Point)vector.elementAt(n + 1);
            this.drawLine(point, point2);
            n += 2;
        }
    }

    public void drawCollectedLines(Vector vector) {
        System.err.println("Collecting lines....");
        Vector vector2 = DXF.linesToPolygons(vector);
        System.err.println("Finished collecting.");
        int n = 0;
        while (n < vector2.size()) {
            Polygon polygon = (Polygon)vector2.elementAt(n);
            Point point = polygon.getVertex(polygon.numVertices() - 1);
            int n2 = 0;
            while (n2 < polygon.numVertices()) {
                Point point2 = point;
                point = polygon.getVertex(n2);
                this.drawLine(point2, point);
                ++n2;
            }
            ++n;
        }
    }

    public void close() {
        this.pw.print("0\nENDSEC\n0\nEOF\n");
        this.pw.flush();
    }

    public static int[] getBuddies(Vector vector) {
        int[] nArray = new int[vector.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            if (nArray[n2] < 0) {
                Point point = (Point)vector.elementAt(n2);
                int n3 = n2 + 1;
                while (n3 < vector.size()) {
                    if (nArray[n3] == -1) break;
                    ++n3;
                }
                if (n3 == vector.size()) {
                    System.err.println("hmmmm....");
                } else {
                    int n4 = n3;
                    double d = point.dist((Point)vector.elementAt(n3));
                    ++n3;
                    while (n3 < vector.size()) {
                        double d2;
                        if (nArray[n3] < 0 && (d2 = point.dist((Point)vector.elementAt(n3))) < d) {
                            d = d2;
                            n4 = n3;
                        }
                        ++n3;
                    }
                    nArray[n2] = n4;
                    nArray[n4] = n2;
                }
            }
            ++n2;
        }
        return nArray;
    }

    public static void report(Vector vector) {
        int[] nArray = DXF.getBuddies(vector);
        Vector<Double> vector2 = new Vector<Double>();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] == -1) {
                System.err.println("huh??");
            } else if (nArray[n] >= n) {
                Point point = (Point)vector.elementAt(n);
                Point point2 = (Point)vector.elementAt(nArray[n]);
                vector2.addElement(new Double(point.dist(point2)));
            }
            ++n;
        }
        Sort.quickSort(vector2, 0, vector2.size() - 1, new Comparison(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = (Double)object;
                if (d2 < (d = ((Double)object2).doubleValue())) {
                    return -1;
                }
                if (d2 == d) {
                    return 0;
                }
                return 1;
            }
        });
        int n2 = 0;
        while (n2 < vector2.size()) {
            System.out.println(vector2.elementAt(n2));
            ++n2;
        }
    }

    public static Vector linesToPolygons(Vector vector) {
        Vector<Polygon> vector2 = new Vector<Polygon>();
        int[] nArray = DXF.getBuddies(vector);
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != -1) {
                Polygon polygon = new Polygon();
                polygon.addVertex((Point)vector.elementAt(n + 1));
                int n2 = nArray[n + 1];
                nArray[n] = -1;
                while (n2 != n) {
                    if (n2 == -1) {
                        polygon = null;
                        break;
                    }
                    int n3 = -1;
                    if (n2 % 2 == 0) {
                        polygon.addVertex((Point)vector.elementAt(n2 + 1));
                        n3 = nArray[n2 + 1];
                        nArray[n2] = -1;
                        nArray[n2 + 1] = -1;
                    } else {
                        polygon.addVertex((Point)vector.elementAt(n2 - 1));
                        n3 = nArray[n2 - 1];
                        nArray[n2] = -1;
                        nArray[n2 - 1] = -1;
                    }
                    n2 = n3;
                }
                if (polygon != null) {
                    vector2.addElement(polygon);
                }
            }
            n += 2;
        }
        return vector2;
    }
}

