/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.toolkit;

import csk.taprats.geometry.Point;
import csk.taprats.geometry.Polygon;
import csk.taprats.geometry.Transform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Stack;

public class GeoGraphics {
    private Graphics graphics;
    private Transform transform;
    private Stack pushed;
    private Component component;

    public GeoGraphics(Graphics graphics, Transform transform, Component component) {
        this.graphics = graphics;
        this.transform = transform;
        this.pushed = null;
        this.component = component;
    }

    public GeoGraphics(Graphics graphics, Transform transform) {
        this(graphics, transform, null);
    }

    void dispose() {
        this.graphics.dispose();
    }

    public final Graphics getDirectGraphics() {
        return this.graphics;
    }

    public final Transform getTransform() {
        return this.transform;
    }

    public final void drawLine(double d, double d2, double d3, double d4) {
        double d5 = this.transform.applyX(d, d2);
        double d6 = this.transform.applyY(d, d2);
        double d7 = this.transform.applyX(d3, d4);
        double d8 = this.transform.applyY(d3, d4);
        this.graphics.drawLine((int)d5, (int)d6, (int)d7, (int)d8);
    }

    public final void drawLine(Point point, Point point2) {
        this.drawLine(point.getX(), point.getY(), point2.getX(), point2.getY());
    }

    public final void drawThickLine(double d, double d2, double d3, double d4, double d5) {
        this.drawThickLine(new Point(d, d2), new Point(d3, d4), d5);
    }

    public final void drawThickLine(Point point, Point point2, double d) {
        Point point3 = point2.subtract(point).perp();
        Point[] pointArray = new Point[]{point.add(point3.scale(d)), point.subtract(point3.scale(d)), point2.subtract(point3.scale(d)), point2.add(point3.scale(d))};
        this.drawPolygon(pointArray, true);
        this.drawCircle(point, d / 2.0, true);
        this.drawCircle(point2, d / 2.0, true);
    }

    public final void drawRect(Point point, double d, double d2, boolean bl) {
        double d3 = point.getX();
        double d4 = point.getY();
        Point[] pointArray = new Point[]{point, new Point(d3 + d, d4), new Point(d3 + d, d4 + d2), new Point(d3, d4 + d2)};
        this.drawPolygon(pointArray, bl);
    }

    public final void drawPolygon(Point[] pointArray, boolean bl) {
        this.drawPolygon(pointArray, 0, pointArray.length, bl);
    }

    public final void drawPolygon(Point[] pointArray, int n, int n2, boolean bl) {
        int n3 = n2 - n;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            double d = pointArray[n5].getX();
            double d2 = pointArray[n5].getY();
            nArray[n4] = (int)this.transform.applyX(d, d2);
            nArray2[n4] = (int)this.transform.applyY(d, d2);
            ++n4;
            ++n5;
        }
        if (bl) {
            this.graphics.fillPolygon(nArray, nArray2, n3);
        } else {
            this.graphics.drawPolygon(nArray, nArray2, n3);
        }
    }

    public final void drawPolygon(Polygon polygon, boolean bl) {
        int n = polygon.numVertices();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Point point = polygon.getVertex(n2);
            double d = point.getX();
            double d2 = point.getY();
            nArray[n2] = (int)this.transform.applyX(d, d2);
            nArray2[n2] = (int)this.transform.applyY(d, d2);
            ++n2;
        }
        if (bl) {
            this.graphics.fillPolygon(nArray, nArray2, n);
        } else {
            this.graphics.drawPolygon(nArray, nArray2, n);
        }
    }

    public final void drawCircle(Point point, double d, boolean bl) {
        Point point2 = this.transform.apply(new Point(d, 0.0));
        Point point3 = this.transform.apply(new Point(0.0, 0.0));
        double d2 = point2.dist(point3);
        Point point4 = this.transform.apply(point);
        Point point5 = point4.subtract(new Point(d2, d2));
        int n = (int)(d2 * 2.0);
        if (bl) {
            this.graphics.fillOval((int)point5.getX(), (int)point5.getY(), n, n);
        } else {
            this.graphics.drawOval((int)point5.getX(), (int)point5.getY(), n, n);
        }
    }

    public final void drawScreenCircle(Point point, double d, boolean bl) {
        Point point2 = this.transform.apply(point);
        if (bl) {
            this.graphics.fillOval((int)(point2.getX() - d), (int)(point2.getY() - d), (int)(2.0 * d), (int)(2.0 * d));
        } else {
            this.graphics.drawOval((int)(point2.getX() - d), (int)(point2.getY() - d), (int)(2.0 * d), (int)(2.0 * d));
        }
    }

    public final void drawCircle(Point point, double d) {
        this.drawCircle(point, d, false);
    }

    public final void drawImage(Image image, Point point) {
        if (this.component != null) {
            Point point2 = this.transform.apply(point);
            this.graphics.drawImage(image, (int)point2.getX(), (int)point2.getY(), this.component);
        }
    }

    public final void drawImage(Image image) {
        if (this.component != null) {
            this.graphics.drawImage(image, 0, 0, this.component);
        }
    }

    public final Color getColor() {
        return this.graphics.getColor();
    }

    public final void setColor(Color color) {
        this.graphics.setColor(color);
    }

    public final void pushAndCompose(Transform transform) {
        if (this.pushed == null) {
            this.pushed = new Stack();
        }
        this.pushed.push(this.transform);
        this.transform = this.transform.compose(transform);
    }

    public final Transform pop() {
        Transform transform = this.transform;
        this.transform = (Transform)this.pushed.pop();
        return transform;
    }
}

