/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.toolkit;

import csk.taprats.geometry.Point;
import csk.taprats.geometry.Polygon;
import csk.taprats.geometry.Rect;
import csk.taprats.geometry.Transform;
import csk.taprats.toolkit.GeoGraphics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class GeoView
extends Canvas {
    private double left;
    private double top;
    private double width;
    private double theta;
    private Transform transform;
    private Transform inverse;
    private Image backing_store;
    private boolean sink;
    protected int last_x;
    protected int last_y;
    private boolean do_tracking;
    protected int track_x;
    protected int track_y;
    private Dimension last_size;
    private boolean j2d;
    private boolean j2d_possible;
    private static Color[] bevel_h_0 = new Color[]{new Color(1, 1, 1), new Color(1, 1, 1), new Color(1, 1, 1), new Color(76, 76, 76), new Color(103, 103, 103)};
    private static Color[] bevel_h_1 = new Color[]{new Color(27, 27, 27), new Color(53, 53, 53), new Color(78, 78, 78), new Color(153, 153, 153), new Color(180, 180, 180)};
    private static Color[] bevel_h_2 = new Color[]{new Color(127, 127, 127), new Color(178, 178, 178), new Color(228, 228, 228), new Color(255, 255, 255), new Color(255, 255, 255)};
    private static Color[] bevel_h_3 = new Color[]{new Color(154, 154, 154), new Color(205, 205, 205), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255)};
    private static Color[] bevel_v = new Color[]{new Color(52, 52, 52), new Color(103, 103, 103), new Color(228, 228, 228), new Color(255, 255, 255)};

    public GeoView(double d, double d2, double d3) {
        this.left = d;
        this.top = d2;
        this.width = d3;
        this.transform = null;
        this.backing_store = null;
        this.sink = false;
        this.last_size = new Dimension(200, 200);
        this.do_tracking = false;
        this.setBackground(Color.white);
        MouseENator mouseENator = new MouseENator();
        this.addMouseListener(mouseENator);
        this.addMouseMotionListener(mouseENator);
        this.j2d = false;
        this.j2d_possible = false;
        try {
            Class<?> clazz = Class.forName("java.awt.Graphics2D");
            this.j2d_possible = true;
            this.j2d = true;
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 113) {
                        GeoView.this.j2d = !GeoView.this.j2d;
                        GeoView.this.forceRedraw();
                    } else if (keyEvent.getKeyCode() == 66) {
                        System.err.println("" + GeoView.this.left + " " + GeoView.this.top + " " + GeoView.this.width);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.forceRedraw();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setSink(boolean bl) {
        this.sink = bl;
    }

    public void setTrack(boolean bl) {
        this.do_tracking = bl;
    }

    public void paint(Graphics graphics) {
        this.buildBackingStore();
        graphics.drawImage(this.backing_store, 0, 0, this);
    }

    private final void buildBackingStore() {
        if (this.backing_store == null) {
            Dimension dimension = this.getSize();
            this.backing_store = this.createImage(dimension.width, dimension.height);
            this.redraw();
        }
    }

    public void forceRedraw() {
        this.redraw();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.drawImage(this.backing_store, 0, 0, this);
        }
        this.repaint();
    }

    protected Graphics getBackGraphics() {
        return this.backing_store.getGraphics();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.last_size = new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.last_size;
    }

    public Dimension getMinimumSize() {
        return this.last_size;
    }

    public void setBounds(double d, double d2, double d3) {
        this.left = d;
        this.top = d2;
        this.width = d3;
        this.transform = null;
        this.forceRedraw();
    }

    public void setTheta(double d) {
        this.theta = d;
        this.transform = null;
        this.forceRedraw();
    }

    public boolean redraw() {
        Object object;
        if (this.backing_store == null) {
            return false;
        }
        this.computeTransform();
        Graphics graphics = this.getBackGraphics();
        if (this.j2d) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        object = this.getSize();
        graphics.clearRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        GeoGraphics geoGraphics = new GeoGraphics(graphics, this.transform, this);
        this.redraw(geoGraphics);
        if (this.sink) {
            int n = ((Dimension)object).width;
            int n2 = ((Dimension)object).height;
            GeoView.drawH(n, 0, bevel_h_0, graphics);
            GeoView.drawH(n, 1, bevel_h_1, graphics);
            GeoView.drawH(n, n2 - 2, bevel_h_2, graphics);
            GeoView.drawH(n, n2 - 1, bevel_h_3, graphics);
            GeoView.drawV(n2, 0, bevel_v[0], graphics);
            GeoView.drawV(n2, 1, bevel_v[1], graphics);
            GeoView.drawV(n2, n - 2, bevel_v[1], graphics);
            GeoView.drawV(n2, n - 1, bevel_v[2], graphics);
        }
        return true;
    }

    protected void redraw(GeoGraphics geoGraphics) {
    }

    protected final void computeTransform() {
        if (this.transform == null) {
            Dimension dimension = this.getSize();
            double d = dimension.width;
            double d2 = dimension.height;
            double d3 = d / d2;
            double d4 = this.width / d3;
            Point point = new Point(d / 2.0, d2 / 2.0);
            Transform transform = Transform.translate(-this.left, -(this.top - d4));
            Transform transform2 = Transform.scale(d / this.width, -(d2 / d4));
            Transform transform3 = Transform.translate(0.0, d2);
            Transform transform4 = Transform.rotateAroundPoint(point, this.theta);
            this.transform = transform4.compose(transform3.compose(transform2.compose(transform)));
            this.inverse = this.transform.invert();
        }
    }

    public void invalidate() {
        super.invalidate();
        this.backing_store = null;
        this.transform = null;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getViewWidth() {
        return this.width;
    }

    public final double getTheta() {
        return this.theta;
    }

    public final Polygon getBoundary() {
        Dimension dimension = this.getSize();
        double d = dimension.width;
        double d2 = dimension.height;
        Polygon polygon = new Polygon(4);
        polygon.addVertex(this.inverse.apply(0.0, 0.0));
        polygon.addVertex(this.inverse.apply(d, 0.0));
        polygon.addVertex(this.inverse.apply(d, d2));
        polygon.addVertex(this.inverse.apply(0.0, d2));
        return polygon;
    }

    public final Rect getBoundingBox() {
        return this.getBoundary().getBoundingBox();
    }

    public void lookAt(Rect rect) {
        rect = rect.centralScale(1.25);
        Dimension dimension = this.getSize();
        Transform transform = rect.centerInside(new Rect(0.0, 0.0, dimension.width, dimension.height));
        Transform transform2 = transform.invert();
        Point point = transform2.apply(new Point(0.0, 0.0));
        Point point2 = transform2.apply(new Point(dimension.width, 0.0));
        this.left = point.getX();
        this.top = point.getY();
        this.width = point2.getX() - point.getX();
        this.theta = 0.0;
        this.transform = null;
        this.forceRedraw();
    }

    public final Point worldToScreen(Point point) {
        if (this.transform == null) {
            this.computeTransform();
        }
        return this.transform.apply(point);
    }

    public final Point screenToWorld(Point point) {
        if (this.transform == null) {
            this.computeTransform();
        }
        return this.inverse.apply(point);
    }

    public final Point screenToWorld(int n, int n2) {
        double d = n;
        double d2 = n2;
        return this.inverse.apply(new Point(d, d2));
    }

    public final Transform getTransform() {
        this.computeTransform();
        return this.transform;
    }

    public final Transform getInverseTransform() {
        this.computeTransform();
        return this.inverse;
    }

    private final void startMove(MouseEvent mouseEvent) {
        this.last_x = mouseEvent.getX();
        this.last_y = mouseEvent.getY();
    }

    private final void startRotate(MouseEvent mouseEvent) {
        this.last_x = mouseEvent.getX();
        this.last_y = mouseEvent.getY();
    }

    private final void startScale(MouseEvent mouseEvent) {
        this.last_x = mouseEvent.getX();
        this.last_y = mouseEvent.getY();
    }

    private final void dragMove(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = this.screenToWorld(this.last_x, this.last_y);
        Point point2 = this.screenToWorld(n, n2);
        this.left -= point2.getX() - point.getX();
        this.top -= point2.getY() - point.getY();
        this.transform = null;
        this.forceRedraw();
        this.last_x = n;
        this.last_y = n2;
    }

    protected void dragRotate(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = this.screenToWorld(this.last_x, this.last_y);
        Point point2 = this.screenToWorld(n, n2);
        Dimension dimension = this.getSize();
        Point point3 = this.screenToWorld(dimension.width / 2, dimension.height / 2);
        double d = point3.sweep(point2, point);
        this.theta += d;
        this.transform = null;
        this.forceRedraw();
        this.last_x = n;
        this.last_y = n2;
    }

    private final void dragScale(MouseEvent mouseEvent) {
        double d;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = this.screenToWorld(this.last_x, this.last_y);
        Point point2 = this.screenToWorld(n, n2);
        Dimension dimension = this.getSize();
        double d2 = dimension.width;
        double d3 = dimension.height;
        double d4 = d2 / d3;
        double d5 = this.width / d4;
        Point point3 = new Point(this.left + this.width * 0.5, this.top - d5 * 0.5);
        double d6 = point3.dist(point);
        if (this.width * d6 < 10000.0 * (d = point3.dist(point2))) {
            double d7 = d6 / d;
            double d8 = this.width * d7;
            this.left -= (d8 - this.width) * 0.5;
            this.top += (d5 * d7 - d5) * 0.5;
            this.width *= d7;
            this.transform = null;
            this.forceRedraw();
        }
        this.last_x = n;
        this.last_y = n2;
    }

    private final void commitMove(MouseEvent mouseEvent) {
    }

    private final void commitRotate(MouseEvent mouseEvent) {
    }

    private final void commitScale(MouseEvent mouseEvent) {
    }

    public static boolean isShift(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown();
    }

    public static boolean isControl(MouseEvent mouseEvent) {
        return mouseEvent.isControlDown();
    }

    public static boolean isAlt(MouseEvent mouseEvent) {
        return mouseEvent.isAltDown();
    }

    public static boolean isButton(MouseEvent mouseEvent, int n) {
        switch (n) {
            case 2: {
                return (mouseEvent.getModifiers() & 8) != 0;
            }
            case 3: {
                return (mouseEvent.getModifiers() & 4) != 0;
            }
        }
        return (mouseEvent.getModifiers() & (8 | 4)) == 0;
    }

    private static final void drawH(int n, int n2, Color[] colorArray, Graphics graphics) {
        graphics.setColor(colorArray[0]);
        graphics.drawLine(0, n2, 0, n2);
        graphics.setColor(colorArray[1]);
        graphics.drawLine(1, n2, 1, n2);
        graphics.setColor(colorArray[2]);
        graphics.drawLine(2, n2, n - 2, n2);
        graphics.setColor(colorArray[3]);
        graphics.drawLine(n - 2, n2, n - 2, n2);
        graphics.setColor(colorArray[4]);
        graphics.drawLine(n - 1, n2, n - 1, n2);
    }

    private static final void drawV(int n, int n2, Color color, Graphics graphics) {
        graphics.setColor(color);
        graphics.drawLine(n2, 2, n2, n - 2);
    }

    protected final boolean haveJava2D() {
        return this.j2d;
    }

    public final void setJava2D(boolean bl) {
        if (this.j2d_possible && this.j2d != bl) {
            this.j2d = bl;
            this.forceRedraw();
        }
    }

    class MouseENator
    implements MouseListener,
    MouseMotionListener {
        MouseENator() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            GeoView.this.track_x = mouseEvent.getX();
            GeoView.this.track_y = mouseEvent.getY();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            GeoView.this.track_x = mouseEvent.getX();
            GeoView.this.track_y = mouseEvent.getY();
            if (GeoView.this.do_tracking) {
                GeoView.this.requestFocus();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            GeoView.this.track_x = mouseEvent.getX();
            GeoView.this.track_y = mouseEvent.getY();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GeoView.this.track_x = mouseEvent.getX();
            GeoView.this.track_y = mouseEvent.getY();
            if (GeoView.isShift(mouseEvent)) {
                if (GeoView.isButton(mouseEvent, 1)) {
                    GeoView.this.startMove(mouseEvent);
                } else if (GeoView.isButton(mouseEvent, 2)) {
                    GeoView.this.startRotate(mouseEvent);
                } else if (GeoView.isButton(mouseEvent, 3)) {
                    GeoView.this.startScale(mouseEvent);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            GeoView.this.track_x = mouseEvent.getX();
            GeoView.this.track_y = mouseEvent.getY();
            if (GeoView.isShift(mouseEvent)) {
                if (GeoView.isButton(mouseEvent, 1)) {
                    GeoView.this.commitMove(mouseEvent);
                } else if (GeoView.isButton(mouseEvent, 2)) {
                    GeoView.this.commitRotate(mouseEvent);
                } else if (GeoView.isButton(mouseEvent, 3)) {
                    GeoView.this.commitScale(mouseEvent);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            GeoView.this.track_x = mouseEvent.getX();
            GeoView.this.track_y = mouseEvent.getY();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            GeoView.this.track_x = mouseEvent.getX();
            GeoView.this.track_y = mouseEvent.getY();
            if (GeoView.isShift(mouseEvent)) {
                if (GeoView.isButton(mouseEvent, 1)) {
                    GeoView.this.dragMove(mouseEvent);
                } else if (GeoView.isButton(mouseEvent, 2)) {
                    GeoView.this.dragRotate(mouseEvent);
                } else if (GeoView.isButton(mouseEvent, 3)) {
                    GeoView.this.dragScale(mouseEvent);
                }
            }
        }
    }
}

