/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.toolkit;

import csk.taprats.geometry.Point;
import csk.taprats.geometry.Polygon;
import csk.taprats.geometry.Rect;
import csk.taprats.geometry.Transform;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.Writer;

public class PS {
    PrintWriter pw;
    Transform T;

    public PS(Writer writer, Rect rect) {
        this.pw = new PrintWriter(writer);
        this.pw.println("%!PS-Adobe-3.0 EPSF-3.0");
        Rect rect2 = new Rect(72.0, 720.0, 468.0, 648.0);
        this.T = rect.centerInside(rect2);
        Point point = this.T.apply(new Point(rect.getLeft(), rect.getBottom()));
        Point point2 = this.T.apply(new Point(rect.getRight(), rect.getTop()));
        int n = (int)point.getX();
        int n2 = (int)point.getY();
        int n3 = (int)point2.getX();
        int n4 = (int)point2.getY();
        this.pw.println("%%BoundingBox: " + n + " " + n2 + " " + n3 + " " + n4);
        this.pw.println();
        this.pw.println("1 setlinecap 1 setlinejoin");
        this.pw.println("/m { moveto } bind def");
        this.pw.println("/l { lineto } bind def");
        this.pw.println("/lc { lineto closepath } bind def");
        this.pw.println();
    }

    public Transform getTransform() {
        return this.T;
    }

    public Point apply(Point point) {
        return this.T.apply(point);
    }

    public void print(String string) {
        this.pw.print(string);
    }

    public void println(String string) {
        this.pw.println(string);
    }

    public void printPolygon(Polygon polygon) {
        Point point = this.T.apply(polygon.getVertex(0));
        this.println("" + point.getX() + " " + point.getY() + " m");
        int n = 1;
        while (n < polygon.numVertices() - 1) {
            point = this.T.apply(polygon.getVertex(n));
            this.println("" + point.getX() + " " + point.getY() + " l");
            ++n;
        }
        point = this.T.apply(polygon.getVertex(polygon.numVertices() - 1));
        this.println("" + point.getX() + " " + point.getY() + " lc");
    }

    public void printPolygon(Point[] pointArray, int n, int n2) {
        Point point = this.T.apply(pointArray[n]);
        this.println("" + point.getX() + " " + point.getY() + " m");
        int n3 = n + 1;
        while (n3 < n2 - 1) {
            point = this.T.apply(pointArray[n3]);
            this.println("" + point.getX() + " " + point.getY() + " l");
            ++n3;
        }
        point = this.T.apply(pointArray[n2 - 1]);
        this.println("" + point.getX() + " " + point.getY() + " lc");
    }

    public void printLine(Point point, Point point2) {
        point = this.T.apply(point);
        point2 = this.T.apply(point2);
        this.println("" + point.getX() + " " + point.getY() + " m");
        this.println("" + point2.getX() + " " + point2.getY() + " l");
    }

    public void printColor(Color color) {
        this.print("" + (double)color.getRed() / 255.0 + " " + (double)color.getGreen() / 255.0 + " " + (double)color.getBlue() / 255.0 + " setrgbcolor");
    }
}

