/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.toolkit;

import csk.taprats.general.Signal;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class Slider {
    private Label name;
    private Scrollbar scroll;
    private TextField field;
    private double min;
    private double max;
    private double val;
    private boolean integral;
    public Signal value_changed;

    public Slider(String string, double d, double d2, double d3) {
        this.val = d;
        this.min = d2;
        this.max = d3;
        this.integral = false;
        this.name = new Label(string);
        this.field = new TextField(this.ftoa(d), 9);
        this.scroll = new Scrollbar(0, this.getSlideLoc(d), 1, 0, 257);
        this.value_changed = new Signal();
        this.scroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Slider.this.updateFromSlider();
            }
        });
        this.field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Slider.this.updateFromField();
            }
        });
    }

    private void updateFromSlider() {
        double d = this.getValue(this.scroll.getValue());
        if (d != this.val) {
            this.field.setText(this.ftoa(d));
            this.val = d;
            this.value_changed.signotify(new Double(this.val));
        }
    }

    private void updateFromField() {
        try {
            double d = 0.0;
            d = this.integral ? (double)Integer.parseInt(this.field.getText()) : new Double(this.field.getText());
            if (d < this.min) {
                d = this.min;
            } else if (d > this.max) {
                d = this.max;
            }
            if (d != this.val) {
                this.field.setText(this.ftoa(d));
                this.scroll.setValue(this.getSlideLoc(d));
                this.val = d;
                this.value_changed.signotify(new Double(d));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.field.setText(this.ftoa(this.val));
        }
    }

    private String ftoa(double d) {
        int n;
        if (this.integral) {
            return String.valueOf((int)d);
        }
        String string = String.valueOf(d);
        int n2 = string.lastIndexOf(46);
        if (n2 != -1 && (n = string.length() - (n2 + 1)) > 5) {
            string = string.substring(0, n2 + 6);
        }
        return string;
    }

    private int getSlideLoc(double d) {
        return (int)(256.0 * (d - this.min) / (this.max - this.min));
    }

    private double getValue(int n) {
        return this.min + (double)n / 256.0 * (this.max - this.min);
    }

    public double getValue() {
        return this.val;
    }

    public void setValue(double d, boolean bl) {
        if (d < this.min) {
            d = this.min;
        } else if (d > this.max) {
            d = this.max;
        }
        this.scroll.setValue(this.getSlideLoc(d));
        this.field.setText(this.ftoa(d));
        this.val = d;
        if (bl) {
            this.value_changed.signotify(new Double(d));
        }
    }

    public void setValue(double d) {
        this.setValue(d, true);
    }

    public void setValues(double d, double d2, double d3, boolean bl) {
        this.min = d2;
        this.max = d3;
        this.setValue(d, bl);
    }

    public void setValues(double d, double d2, double d3) {
        this.setValues(d, d2, d3, true);
    }

    public void setIntegral(boolean bl) {
        this.integral = bl;
    }

    public Panel getAsPanel() {
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        this.insert(panel, gridBagLayout, 0, 0);
        return panel;
    }

    public void insert(Container container, GridBagLayout gridBagLayout, int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.name, gridBagConstraints);
        container.add(this.name);
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.scroll, gridBagConstraints);
        container.add(this.scroll);
        gridBagConstraints.gridx = n + 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.field, gridBagConstraints);
        container.add(this.field);
    }
}

