const Cc = Components.classes, Ci = Components.interfaces, Cu = Components.utils;
const os = Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService);
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

function RsolutionSingleton () {
	this.wrappedJSObject = this;
}

RsolutionSingleton.prototype = {
  classDescription:  "Rsolution.be singleton implementation",
  //classID:         Components.ID("{2e8da670-222e-11e0-ac64-0800200c9a66}"),
  classID:           Components.ID("{a587d8e0-8d5e-17e0-ac1b-acabadaba111}"),
  contractID:        "@rtube.rsolution.be/rsolutionsingleton;1",
  _xpcom_categories: [{ category: "app-startup", service: true }],  /* for toolkit before 2.0 (Fx 4.0), if you need to initialize */
  QueryInterface:    XPCOMUtils.generateQI([Ci.nsIObserver  /*if initialization needed , Ci.nsIRsolutionSingleton*/]),
  
  /* if initialization needed */
  observe: function (aSubject, aTopic, aData) {
	switch (aTopic) {
	case "app-startup":  /* for toolkit before 2.0 (Fx 4.0) */
	  os.addObserver(this, "profile-after-change", false);
	  break;

	case "profile-after-change":
	  /* Do initialization here */
		
	  break;
	}
  }
  ,hello:function()
  {
	return "ie de manne";
  }
  /* the rest of your component's code */
};

if (XPCOMUtils.generateNSGetFactory)
  var NSGetFactory = XPCOMUtils.generateNSGetFactory([RsolutionSingleton]);  /* for toolkit 2.0 (Fx 4.0) */
else
  var NSGetModule = XPCOMUtils.generateNSGetModule([RsolutionSingleton]);  /* for toolkit before 2.0 (Fx 4.0) */  