/*
 * Decompiled with CFR 0.152.
 */
package com.maximchuk.ptc.handle;

import com.maximchuk.ptc.entity.FileEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ThemeJarBuilder {
    private static final String TEMP_DIR = "temp";
    private FileEntity css;
    private List<FileEntity> images;

    public ThemeJarBuilder(FileEntity cssData, List<FileEntity> imagesData) {
        this.css = cssData;
        this.images = imagesData;
    }

    public void build(String outputDirName, String themeName) throws IOException {
        if (new File(TEMP_DIR).exists() && !this.cleaningTemp()) {
            return;
        }
        StringBuilder fileStructureNameBuilder = new StringBuilder(TEMP_DIR);
        this.mkdir(fileStructureNameBuilder.toString());
        fileStructureNameBuilder.append("/META-INF/");
        this.mkdir(fileStructureNameBuilder.toString());
        fileStructureNameBuilder.append("resources/");
        this.mkdir(fileStructureNameBuilder.toString());
        fileStructureNameBuilder.append("primefaces-").append(themeName).append("/");
        this.mkdir(fileStructureNameBuilder.toString());
        String cssDirName = fileStructureNameBuilder.toString();
        fileStructureNameBuilder.append("images/");
        this.mkdir(fileStructureNameBuilder.toString());
        String imagesDirName = fileStructureNameBuilder.toString();
        FileOutputStream os = new FileOutputStream(cssDirName + this.css.getFilename());
        ((OutputStream)os).write(this.css.getData());
        ((OutputStream)os).close();
        for (FileEntity image : this.images) {
            os = new FileOutputStream(imagesDirName + image.getFilename());
            ((OutputStream)os).write(image.getData());
            ((OutputStream)os).close();
        }
        StringBuilder jarNameBuilder = new StringBuilder(outputDirName);
        this.mkdir(jarNameBuilder.toString());
        jarNameBuilder.append("/").append(themeName).append(".jar");
        if (new File(jarNameBuilder.toString()).exists()) {
            this.delete(new File(jarNameBuilder.toString()));
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(jarNameBuilder.toString()));
        System.out.println("Creating theme jar...");
        this.compressTheme(TEMP_DIR, null, out);
        out.close();
        if (!this.cleaningTemp()) {
            return;
        }
        System.out.println("Complete! Check '" + new File(outputDirName).getAbsolutePath() + "' folder");
    }

    private void compressTheme(String directory, String entryName, ZipOutputStream out) throws IOException {
        String[] contents;
        File files = new File(directory);
        for (String content : contents = files.list()) {
            int len;
            File f = new File(directory, content);
            String name = entryName == null ? f.getName() : entryName + "/" + f.getName();
            System.out.println("processing entry: " + name);
            if (f.isDirectory()) {
                out.putNextEntry(new ZipEntry(name + "/"));
                this.compressTheme(f.getPath(), name, out);
                continue;
            }
            FileInputStream in = new FileInputStream(f);
            out.putNextEntry(new ZipEntry(name));
            byte[] data = new byte[in.available()];
            while ((len = in.read(data)) > 0) {
                out.write(data, 0, len);
            }
            out.flush();
            out.closeEntry();
            in.close();
        }
    }

    private boolean cleaningTemp() {
        boolean isOk;
        System.out.print("Cleaning temporary data... ");
        if (this.delete(new File(TEMP_DIR))) {
            System.out.println("ok");
            isOk = true;
        } else {
            System.out.println("error");
            isOk = false;
        }
        return isOk;
    }

    private void mkdir(String dirName) {
        File f = new File(dirName);
        f.mkdir();
    }

    private boolean delete(File toDelete) {
        boolean isDeleted = true;
        if (toDelete.isDirectory()) {
            File f;
            File[] arr$ = toDelete.listFiles();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (isDeleted = this.delete(f = arr$[i$])); ++i$) {
            }
            if (isDeleted) {
                isDeleted = toDelete.delete();
            }
        } else {
            isDeleted = toDelete.delete();
        }
        return isDeleted;
    }
}

