/*
 * Decompiled with CFR 0.152.
 */
package com.maximchuk.ptc.parser;

import com.maximchuk.ptc.entity.FileEntity;
import com.maximchuk.ptc.parser.ThemerollerZipParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class AbstractThemerollerZipParser
implements ThemerollerZipParser {
    protected ZipFile zipFile;
    protected ZipEntry cssEntry = null;
    protected List<ZipEntry> imagesEntryList = new ArrayList<ZipEntry>();

    public AbstractThemerollerZipParser(File file) throws IOException {
        this.zipFile = new ZipFile(file);
    }

    @Override
    public boolean validate() {
        return this.zipFile.entries().nextElement().getName().contains(this.getVersion());
    }

    @Override
    public FileEntity getCss() throws IOException {
        this.checkCssEntry();
        InputStream is = this.zipFile.getInputStream(this.cssEntry);
        byte[] data = new byte[is.available()];
        is.read(data);
        return new FileEntity("theme.css", data);
    }

    @Override
    public List<FileEntity> getImages() throws IOException {
        ArrayList<FileEntity> images = new ArrayList<FileEntity>();
        for (ZipEntry imageEntry : this.imagesEntryList) {
            InputStream is = this.zipFile.getInputStream(imageEntry);
            byte[] data = new byte[is.available()];
            is.read(data);
            String[] filenameParts = imageEntry.getName().split("/");
            images.add(new FileEntity(filenameParts[filenameParts.length - 1], data));
            is.close();
        }
        return images;
    }

    protected abstract String getVersion();

    protected void checkCssEntry() {
        if (this.cssEntry == null) {
            throw new IllegalStateException("Execute parse first!");
        }
    }
}

