/*
 * Decompiled with CFR 0.152.
 */
package com.maximchuk.ptc.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.maximchuk.ptc.ConverterHandler;
import com.maximchuk.ptc.entity.CssPropertyEntity;
import com.maximchuk.ptc.entity.CssPropertyEnum;
import com.maximchuk.ptc.helper.UIHelper;
import com.maximchuk.ptc.parser.impl.ThemerollerZipParser192;
import com.maximchuk.ptc.ui.AddCssPropertyDialog;
import com.maximchuk.ptc.ui.ConsoleOutput;
import com.maximchuk.ptc.ui.filesystem.BrowseDialog;
import com.maximchuk.ptc.ui.filesystem.FileTypeEnum;
import com.maximchuk.ptc.ui.table.CssPropertyTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConverterForm {
    private static JFrame frame;
    private static ConsoleOutput consoleOutput;
    private CssPropertyTableModel tableModel;
    private String profileFileName;
    private JPanel mainPanel;
    private JTextField srcInput;
    private JButton browseButton;
    private JTextField themenameInput;
    private JLabel srcLabel;
    private JLabel themenameLabel;
    private JTable cssPropertyTable;
    private JButton createButton;
    private JButton addCssPropButton;
    private JScrollPane scrollPane;
    private JButton removeCssPropButton;
    private ActionListener srcThemeFileChoosedListener;
    private ActionListener profileFileChoosedListener;
    private static WindowListener windowListener;

    public ConverterForm() {
        this.$$$setupUI$$$();
        this.srcThemeFileChoosedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File selectedFile = ((JFileChooser)e.getSource()).getSelectedFile();
                try {
                    ThemerollerZipParser192 parser = new ThemerollerZipParser192(selectedFile);
                    if (parser.parse()) {
                        ConverterForm.this.themenameInput.setText(parser.getThemeName());
                    }
                }
                catch (IOException ex) {
                    System.err.print(ex.getStackTrace());
                }
                ConverterForm.this.srcInput.setText(selectedFile.getPath());
            }
        };
        this.profileFileChoosedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File selectedFile = ((JFileChooser)e.getSource()).getSelectedFile();
                ConverterForm.this.profileFileName = selectedFile.getPath();
            }
        };
        this.tableModel = new CssPropertyTableModel();
        this.cssPropertyTable.setModel(this.tableModel);
        consoleOutput = new ConsoleOutput();
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowseDialog browseDialog = new BrowseDialog(FileTypeEnum.THEME_SRC, ConverterForm.this.srcThemeFileChoosedListener);
                browseDialog.showOpenDialog(ConverterForm.this.mainPanel);
            }
        });
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                consoleOutput.clear();
                UIHelper.centerWindow(consoleOutput);
                consoleOutput.setVisible(true);
                ConverterHandler.process(ConverterForm.this.bindProfile());
            }
        });
        this.addCssPropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddCssPropertyDialog addCssPropertyDialog = new AddCssPropertyDialog(ConverterForm.this.tableModel);
                UIHelper.centerWindow(addCssPropertyDialog);
                addCssPropertyDialog.setVisible(true);
                ConverterForm.this.cssPropertyTable.revalidate();
                ConverterForm.this.checkAddButton();
            }
        });
        this.removeCssPropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selInd = ConverterForm.this.cssPropertyTable.getSelectedRow();
                ConverterForm.this.tableModel.removeRowByInd(selInd);
                ConverterForm.this.cssPropertyTable.revalidate();
                ConverterForm.this.checkAddButton();
                ConverterForm.this.checkRemoveButton();
            }
        });
        this.cssPropertyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ConverterForm.this.checkRemoveButton();
            }
        });
    }

    public static void show() throws Exception {
        UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        ConverterForm converterForm = new ConverterForm();
        frame = new JFrame(UIHelper.getAppTitle());
        frame.setJMenuBar(ConverterForm.initMenu(converterForm));
        frame.setContentPane(converterForm.mainPanel);
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 300);
        frame.addWindowListener(windowListener);
        UIHelper.setIcon(frame);
        frame.setVisible(true);
    }

    public static boolean isFrameVisible() {
        return frame.isVisible();
    }

    public static void writeConsoleLine(String line) {
        consoleOutput.writeLine(line);
    }

    private static JMenuBar initMenu(final ConverterForm creator) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem newProfMenuItem = new JMenuItem();
        JMenuItem openProfMenuItem = new JMenuItem();
        JMenuItem saveMenuItem = new JMenuItem();
        JMenuItem saveAsMenuItem = new JMenuItem();
        fileMenu.add(newProfMenuItem);
        fileMenu.add(openProfMenuItem);
        fileMenu.add(saveMenuItem);
        fileMenu.add(saveAsMenuItem);
        menuBar.add(fileMenu);
        newProfMenuItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                creator.acceptProfile(new Properties());
                creator.profileFileName = null;
                creator.refreshTitle();
            }
        });
        newProfMenuItem.setText("New");
        openProfMenuItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowseDialog browseDialog = new BrowseDialog(FileTypeEnum.PROFILE, creator.profileFileChoosedListener);
                if (browseDialog.showOpenDialog(creator.mainPanel) == 0) {
                    try {
                        creator.loadProfile();
                        creator.refreshTitle();
                    }
                    catch (IOException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
        });
        openProfMenuItem.setText("Open");
        saveMenuItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int browseDialogRes = 0;
                if (creator.profileFileName == null) {
                    BrowseDialog browseDialog = new BrowseDialog(FileTypeEnum.PROFILE, creator.profileFileChoosedListener);
                    browseDialogRes = browseDialog.showSaveDialog(creator.mainPanel);
                }
                if (browseDialogRes == 0) {
                    try {
                        creator.saveProfile();
                        creator.refreshTitle();
                    }
                    catch (IOException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
        });
        saveMenuItem.setText("Save");
        saveAsMenuItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowseDialog browseDialog = new BrowseDialog(FileTypeEnum.PROFILE, creator.profileFileChoosedListener);
                if (browseDialog.showSaveDialog(creator.mainPanel) == 0) {
                    try {
                        creator.saveProfile();
                        creator.refreshTitle();
                    }
                    catch (IOException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
        });
        saveAsMenuItem.setText("Save as");
        return menuBar;
    }

    private void checkAddButton() {
        this.addCssPropButton.setEnabled(this.tableModel.canAddedNewCssProperty());
    }

    private void checkRemoveButton() {
        this.removeCssPropButton.setEnabled(this.cssPropertyTable.getSelectedRow() > -1 && this.tableModel.getRowCount() > 0);
    }

    private void loadProfile() throws IOException {
        if (this.profileFileName != null) {
            Properties profile = new Properties();
            profile.load(new FileInputStream(this.profileFileName));
            this.acceptProfile(profile);
        }
    }

    private void saveProfile() throws IOException {
        Properties profile = this.bindProfile();
        profile.store(new FileOutputStream(this.profileFileName), "Created from Primefaces theme converter");
    }

    private void acceptProfile(Properties profile) {
        this.srcInput.setText((String)profile.get("source.filename"));
        this.themenameInput.setText((String)profile.get("theme.name"));
        this.tableModel.clear();
        for (CssPropertyEnum cssPropertyType : CssPropertyEnum.values()) {
            String cssPropertyValue = (String)profile.get(cssPropertyType.getPropertyKey());
            if (cssPropertyValue == null) continue;
            this.tableModel.addRow(new CssPropertyEntity(cssPropertyType, cssPropertyValue));
        }
        this.checkAddButton();
        this.checkRemoveButton();
        this.cssPropertyTable.revalidate();
    }

    private Properties bindProfile() {
        Properties profile = new Properties();
        if (!this.srcInput.getText().isEmpty()) {
            profile.setProperty("source.filename", this.srcInput.getText());
        }
        if (!this.themenameInput.getText().isEmpty()) {
            profile.setProperty("theme.name", this.themenameInput.getText());
        }
        for (CssPropertyEntity cssProperty : this.tableModel.getDataList()) {
            profile.setProperty(cssProperty.getType().getPropertyKey(), cssProperty.getValue());
        }
        return profile;
    }

    private void refreshTitle() {
        StringBuilder titleBuilder = new StringBuilder(UIHelper.getAppTitle());
        if (this.profileFileName != null) {
            titleBuilder.append(" - ").append(this.getProfilename());
        }
        frame.setTitle(titleBuilder.toString());
    }

    private String getProfilename() {
        return new File(this.profileFileName).getName().replace(".prof", "");
    }

    static {
        windowListener = new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                UIHelper.centerWindow(e.getWindow());
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JTable jTable;
        JScrollPane jScrollPane;
        JTextField jTextField;
        JButton jButton3;
        JLabel jLabel;
        JLabel jLabel2;
        JButton jButton4;
        JTextField jTextField2;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(6, 3, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.srcInput = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.browseButton = jButton4 = new JButton();
        jButton4.setText("Browse");
        jPanel.add((Component)jButton4, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.srcLabel = jLabel2 = new JLabel();
        jLabel2.setText("Source zip:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(79, 16), null));
        this.themenameLabel = jLabel = new JLabel();
        jLabel.setText("Theme name:");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(79, 16), null));
        this.createButton = jButton3 = new JButton();
        jButton3.setText("Create theme");
        jPanel.add((Component)jButton3, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.themenameInput = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.scrollPane = jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(2, 0, 3, 2, 0, 3, 7, 7, null, null, null));
        this.cssPropertyTable = jTable = new JTable();
        jScrollPane.setViewportView(jTable);
        this.addCssPropButton = jButton2 = new JButton();
        jButton2.setText("Add");
        jPanel.add((Component)jButton2, new GridConstraints(2, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.removeCssPropButton = jButton = new JButton();
        jButton.setText("Remove");
        ((Component)jButton).setEnabled(false);
        jPanel.add((Component)jButton, new GridConstraints(3, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

