/*
 * Decompiled with CFR 0.152.
 */
package com.maximchuk.ptc.ui.table;

import com.maximchuk.ptc.entity.CssPropertyEntity;
import com.maximchuk.ptc.entity.CssPropertyEnum;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class CssPropertyTableModel
implements TableModel {
    private String[] columnNames = new String[]{"Component name", "Css class value"};
    private List<CssPropertyEntity> dataList = new ArrayList<CssPropertyEntity>();
    private Set<CssPropertyEnum> existsCssPropTypeSet = new HashSet<CssPropertyEnum>();

    @Override
    public int getRowCount() {
        return this.dataList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = null;
        switch (columnIndex) {
            case 0: {
                value = this.dataList.get(rowIndex).getType().name();
                break;
            }
            case 1: {
                value = this.dataList.get(rowIndex).getValue();
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            this.dataList.get(rowIndex).setValue((String)aValue);
        }
    }

    public void addRow(CssPropertyEntity cssProperty) {
        if (!this.isExistCssProperty(cssProperty.getType())) {
            this.existsCssPropTypeSet.add(cssProperty.getType());
            this.dataList.add(cssProperty);
        }
    }

    public void removeRowByInd(int ind) {
        CssPropertyEntity data = this.dataList.get(ind);
        this.existsCssPropTypeSet.remove((Object)data.getType());
        this.dataList.remove(data);
    }

    public void clear() {
        this.dataList = new ArrayList<CssPropertyEntity>();
        this.existsCssPropTypeSet = new HashSet<CssPropertyEnum>();
    }

    public List<CssPropertyEntity> getDataList() {
        return this.dataList;
    }

    public boolean isExistCssProperty(CssPropertyEnum cssPropertyType) {
        return this.existsCssPropTypeSet.contains((Object)cssPropertyType);
    }

    public boolean canAddedNewCssProperty() {
        return CssPropertyEnum.values().length != this.dataList.size();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

