/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Stamps {
    private static final Logger LOG = Logger.getLogger(Stamps.class.getName());
    private static AtomicLong moduleJARs;
    private Worker worker = new Worker();
    private static final Stamps MODULES_JARS;

    private Stamps() {
    }

    static void main(String ... stringArray) {
        if (stringArray.length == 1 && "reset".equals(stringArray[0])) {
            moduleJARs = null;
            Stamps.stamp(false);
            return;
        }
        if (stringArray.length == 1 && "init".equals(stringArray[0])) {
            moduleJARs = null;
            Stamps.stamp(true);
            return;
        }
        if (stringArray.length == 1 && "clear".equals(stringArray[0])) {
            moduleJARs = null;
            return;
        }
    }

    public static Stamps getModulesJARs() {
        return MODULES_JARS;
    }

    public long lastModified() {
        return Stamps.moduleJARs();
    }

    public boolean exists(String string) {
        return this.file(string, null) != null;
    }

    public InputStream asStream(String string) {
        ByteBuffer byteBuffer = this.asByteBuffer(string, false, false);
        if (byteBuffer == null) {
            return null;
        }
        return new ByteArrayInputStream(byteBuffer.array());
    }

    public MappedByteBuffer asMappedByteBuffer(String string) {
        return (MappedByteBuffer)this.asByteBuffer(string, true, true);
    }

    public ByteBuffer asByteBuffer(String string) {
        return this.asByteBuffer(string, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final File file(String string, int[] nArray) {
        String string2 = Stamps.getUserDir();
        if (string2 == null) {
            return null;
        }
        Object object = this;
        synchronized (object) {
            if (this.worker.isProcessing(string)) {
                return null;
            }
        }
        object = new File(new File(new File(string2, "var"), "cache"), string.replace('/', File.separatorChar));
        long l = ((File)object).lastModified();
        if (l <= 0L) {
            return null;
        }
        if (Stamps.moduleJARs() > l) {
            return null;
        }
        long l2 = ((File)object).length();
        if (l2 > Integer.MAX_VALUE) {
            LOG.warning("Cache file is too big: " + l2 + " bytes for " + object);
            return null;
        }
        if (nArray != null) {
            nArray[0] = (int)l2;
        }
        return object;
    }

    private ByteBuffer asByteBuffer(String string, boolean bl, boolean bl2) {
        int[] nArray = new int[1];
        File file = this.file(string, nArray);
        if (file == null) {
            return null;
        }
        try {
            ByteBuffer byteBuffer;
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            if (bl2) {
                byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, nArray[0]);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                byteBuffer = bl ? ByteBuffer.allocateDirect(nArray[0]) : ByteBuffer.allocate(nArray[0]);
                int n = fileChannel.read(byteBuffer);
                if (n != nArray[0]) {
                    LOG.warning("Read less than expected: " + n + " expected: " + nArray + " for " + file);
                    return null;
                }
                byteBuffer.flip();
            }
            fileChannel.close();
            return byteBuffer;
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Cannot read cache " + file, iOException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSave(Updater updater, String string, boolean bl) {
        LOG.log(Level.FINE, "Scheduling save for {0} cache", string);
        Worker worker = this.worker;
        synchronized (worker) {
            this.worker.addStorage(new Store(updater, string, bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(int n) {
        Worker worker = this.worker;
        synchronized (worker) {
            this.worker.start(n);
        }
    }

    public void shutdown() {
        this.waitFor(true);
    }

    public void discardCaches() {
        Stamps.discardCachesImpl(moduleJARs);
    }

    private static void discardCachesImpl(AtomicLong atomicLong) {
        String string = Stamps.getUserDir();
        long l = System.currentTimeMillis();
        if (string != null) {
            File file = new File(string, ".lastModified");
            if (file.exists()) {
                file.setLastModified(l);
            } else {
                file.getParentFile().mkdirs();
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Cannot create " + file, iOException);
                }
            }
        }
        if (atomicLong != null) {
            atomicLong.set(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void waitFor(boolean bl) {
        Worker worker;
        Worker worker2 = this.worker;
        synchronized (worker2) {
            this.flush(0);
            worker = this.worker;
        }
        worker.waitFor(bl);
    }

    static long moduleJARs() {
        AtomicLong atomicLong = moduleJARs;
        if (atomicLong == null) {
            atomicLong = moduleJARs = Stamps.stamp(true);
        }
        return atomicLong.longValue();
    }

    private static String getUserDir() {
        String string = System.getProperty("netbeans.user");
        return "memory".equals(string) ? null : string;
    }

    private static AtomicLong stamp(boolean bl) {
        Object object;
        Object object2;
        String string;
        AtomicLong atomicLong = new AtomicLong();
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<File> hashSet = new HashSet<File>();
        String string2 = System.getProperty("netbeans.home");
        if (string2 != null) {
            long l = Stamps.stampForCluster(new File(string2), atomicLong, hashSet, bl, true);
            stringBuilder.append(string2).append('=').append(l).append('\n');
        }
        if ((string = System.getProperty("netbeans.dirs")) != null) {
            object2 = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                long l = Stamps.stampForCluster(new File((String)object), atomicLong, hashSet, bl, true);
                if (l == -1L) continue;
                stringBuilder.append((String)object).append('=').append(l).append('\n');
            }
        }
        if ((object2 = Stamps.getUserDir()) != null) {
            Stamps.stampForCluster(new File((String)object2), atomicLong, new HashSet<File>(), false, false);
            stringBuilder.append((String)object2).append('=').append(atomicLong.longValue()).append('\n');
            object = new File((String)object2);
            File file = new File(new File(new File(new File((File)object, "var"), "cache"), "lastModified"), "all-checksum.txt");
            if (!Stamps.compareAndUpdateFile(file, stringBuilder.toString(), atomicLong)) {
                Stamps.discardCachesImpl(atomicLong);
            }
        }
        return atomicLong;
    }

    private static long stampForCluster(File file, AtomicLong atomicLong, Set<File> set, boolean bl, boolean bl2) {
        File file2;
        long l;
        File file3 = new File(file, ".lastModified");
        if (bl && (l = file3.lastModified()) > 0L) {
            if (l > atomicLong.longValue()) {
                atomicLong.set(l);
            }
            return l;
        }
        String string = Stamps.getUserDir();
        if (string != null) {
            file2 = new File(string);
            file3 = new File(new File(new File(new File(file2, "var"), "cache"), "lastModified"), file.getName());
            if (bl && (l = file3.lastModified()) > 0L) {
                if (l > atomicLong.longValue()) {
                    atomicLong.set(l);
                }
                return l;
            }
        } else {
            bl2 = false;
        }
        file2 = new File(new File(file, "config"), "Modules");
        File file4 = new File(file, "modules");
        AtomicLong atomicLong2 = new AtomicLong();
        if (!(Stamps.highestStampForDir(file2, atomicLong2) && Stamps.highestStampForDir(file4, atomicLong2) || file.isDirectory())) {
            return -1L;
        }
        if (atomicLong2.longValue() > atomicLong.longValue()) {
            atomicLong.set(atomicLong2.longValue());
        }
        if (bl2) {
            try {
                file3.getParentFile().mkdirs();
                file3.createNewFile();
                file3.setLastModified(atomicLong2.longValue());
            }
            catch (IOException iOException) {
                System.err.println("Cannot write timestamp to " + file3);
            }
        }
        return atomicLong2.longValue();
    }

    private static boolean highestStampForDir(File file, AtomicLong atomicLong) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            long l = file.lastModified();
            if (l > atomicLong.longValue()) {
                atomicLong.set(l);
            }
            return false;
        }
        for (File file2 : fileArray) {
            Stamps.highestStampForDir(file2, atomicLong);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compareAndUpdateFile(File file, String string, AtomicLong atomicLong) {
        try {
            long l;
            boolean bl;
            boolean bl2;
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = new byte[byArray.length];
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                int n = fileInputStream.read(byArray2);
                bl2 = n == byArray2.length && fileInputStream.available() == 0 && Arrays.equals(byArray, byArray2);
                bl = !bl2;
                l = file.lastModified();
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl2 = true;
                bl = true;
                l = atomicLong.get();
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            if (bl) {
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                if (bl2) {
                    file.setLastModified(l);
                }
            } else if (l > atomicLong.get()) {
                atomicLong.set(l);
            }
            return bl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static void deleteCache(File file) throws IOException {
        int n = 0;
        if (file.exists()) {
            File file2 = new File(file.getParentFile(), file.getName() + "." + n++);
            file2.delete();
            boolean bl = false;
            for (int i = 0; i < 5 && !(bl = file.renameTo(file2)); ++i) {
                LOG.fine("cannot rename (#" + i + "): " + file);
                System.gc();
                System.runFinalization();
                LOG.fine("after GC");
            }
            if (!bl) {
                file.deleteOnExit();
                throw new IOException("Could not delete: " + file);
            }
            if (!file2.delete()) {
                file2.deleteOnExit();
            }
        }
    }

    static {
        MODULES_JARS = new Stamps();
    }

    private static final class Store
    extends OutputStream {
        final Updater updater;
        final String cache;
        final boolean append;
        OutputStream os;
        AtomicInteger delay;
        int count;

        public Store(Updater updater, String string, boolean bl) {
            this.updater = updater;
            this.cache = string;
            this.append = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean store(AtomicInteger atomicInteger) {
            assert (this.os == null);
            String string = Stamps.getUserDir();
            if (string == null) {
                LOG.warning("No 'netbeans.user' property to store: " + this.cache);
                return false;
            }
            File file = new File(new File(new File(string, "var"), "cache"), this.cache);
            boolean bl = false;
            try {
                LOG.log(Level.FINE, "Cleaning cache {0}", file);
                if (!this.append) {
                    Stamps.deleteCache(file);
                }
                file.getParentFile().mkdirs();
                LOG.log(Level.FINE, "Storing cache {0}", file);
                this.os = new FileOutputStream(file, this.append);
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this, 0x100000));
                this.delay = atomicInteger;
                this.updater.flushCaches(dataOutputStream);
                dataOutputStream.close();
                LOG.log(Level.FINE, "Done Storing cache {0}", file);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Error saving cache " + file, iOException);
                bl = true;
            }
            finally {
                if (this.os != null) {
                    try {
                        this.os.close();
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.WARNING, "Error closing stream for " + file, iOException);
                    }
                    this.os = null;
                }
                if (bl) {
                    file.delete();
                    file.deleteOnExit();
                } else {
                    file.setLastModified(Stamps.moduleJARs());
                }
            }
            return !bl;
        }

        public void close() throws IOException {
            this.os.close();
        }

        public void flush() throws IOException {
            this.os.flush();
        }

        public void write(int n) throws IOException {
            this.os.write(n);
            this.count(1);
        }

        public void write(byte[] byArray) throws IOException {
            this.os.write(byArray);
            this.count(byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.os.write(byArray, n, n2);
            this.count(n2);
        }

        private void count(int n) {
            this.count += n;
            if (this.count > 65536) {
                int n2 = this.delay.get();
                if (n2 > 0) {
                    try {
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                }
                this.count = 0;
            }
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Store store = (Store)object;
            if (!this.updater.equals(store.updater)) {
                return false;
            }
            return this.cache.equals(store.cache);
        }

        public int hashCode() {
            int n = 7;
            n = 19 * n + (this.updater != null ? this.updater.hashCode() : 0);
            n = 19 * n + (this.cache != null ? this.cache.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.cache;
        }
    }

    public static interface Updater {
        public void flushCaches(DataOutputStream var1) throws IOException;

        public void cacheReady();
    }

    private final class Worker
    extends Thread {
        private final LinkedList<Store> storages;
        private final HashSet<String> processing;
        private AtomicInteger delay;
        private boolean noNotify;

        public Worker() {
            super("Flushing caches");
            this.storages = new LinkedList();
            this.processing = new HashSet();
            this.setPriority(1);
        }

        public synchronized void start(int n) {
            if (this.delay == null) {
                this.delay = new AtomicInteger(n);
                super.start();
            }
        }

        public synchronized void addStorage(Store store) {
            this.processing.add(store.cache);
            Iterator iterator = this.storages.iterator();
            while (iterator.hasNext()) {
                Store store2 = (Store)iterator.next();
                if (!store2.equals(store)) continue;
                iterator.remove();
            }
            this.storages.add(store);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n;
            for (int i = n = this.delay.get(); i >= 0; i -= 500) {
                try {
                    Worker worker = this;
                    synchronized (worker) {
                        this.wait(500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.INFO, null, interruptedException);
                }
                if (n != this.delay.get()) break;
            }
            if (n > 512) {
                this.delay.compareAndSet(n, 512);
            }
            long l = System.currentTimeMillis();
            LOG.log(Level.FINE, "Storing caches {0}", this.storages);
            HashSet<Store> hashSet = new HashSet<Store>();
            while (true) {
                Store store;
                Worker worker = this;
                synchronized (worker) {
                    store = this.storages.poll();
                    if (store == null) {
                        Stamps.this.worker = new Worker();
                        break;
                    }
                }
                if (!store.store(this.delay)) continue;
                hashSet.add(store);
            }
            long l2 = System.currentTimeMillis() - l;
            LOG.log(Level.FINE, "Done storing caches {0}", hashSet);
            LOG.log(Level.FINE, "Took {0} ms", l2);
            this.processing.clear();
            for (Store store : hashSet) {
                if (this.noNotify) continue;
                store.updater.cacheReady();
            }
            LOG.log(Level.FINE, "Notified ready {0}", hashSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitFor(boolean bl) {
            try {
                this.noNotify = bl;
                this.delay.set(0);
                Worker worker = this;
                synchronized (worker) {
                    this.notifyAll();
                }
                this.join();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }

        private boolean isProcessing(String string) {
            return this.processing.contains(string);
        }
    }
}

