/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.io;

import com.wowza.io.IIORequest;
import com.wowza.util.NoMBean;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.ThreadPool;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class IOScheduler {
    public static final int DEFAULT_POOLSIZE = 20;
    private ThreadPoolExecutor threadPool = null;
    private LinkedBlockingQueue queue = null;
    private int threadIndex = 0;

    @NoMBean
    public void init(int n) {
        class SimpleThreadFactory
        implements ThreadFactory {
            SimpleThreadFactory() {
            }

            public Thread newThread(Runnable runnable) {
                Thread thread = null;
                try {
                    thread = new Thread(runnable);
                    thread.setPriority(5);
                    thread.setName("IOScheduler." + ++IOScheduler.this.threadIndex);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ThreadPool.class).error("IOScheduler: newThread: " + exception.toString());
                }
                if (thread == null) {
                    WMSLoggerFactory.getLogger(ThreadPool.class).error("IOScheduler: newThread: null thread");
                }
                return thread;
            }
        }
        SimpleThreadFactory simpleThreadFactory = new SimpleThreadFactory();
        this.queue = new LinkedBlockingQueue();
        this.threadPool = new ThreadPoolExecutor(n, n, 5000L, TimeUnit.MILLISECONDS, this.queue);
        this.threadPool.setThreadFactory(simpleThreadFactory);
    }

    @NoMBean
    public void terminate() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        this.threadPool = null;
    }

    @NoMBean
    public void execute(IIORequest iIORequest) {
        if (this.threadPool != null) {
            iIORequest.setState(1);
            this.threadPool.execute((Runnable)((Object)iIORequest));
        }
    }

    @NoMBean
    public void executeRaw(Runnable runnable) {
        this.threadPool.execute(runnable);
    }

    @NoMBean
    public Executor getExecutor() {
        return this.threadPool;
    }

    public int getActiveCount() {
        if (this.threadPool != null) {
            return this.threadPool.getActiveCount();
        }
        return 0;
    }

    public int getPoolSize() {
        if (this.threadPool != null) {
            return this.threadPool.getMaximumPoolSize();
        }
        return 0;
    }

    public int getQueueSize() {
        if (this.queue != null) {
            return this.queue.size();
        }
        return 0;
    }
}

