/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

public class BitReader {
    private byte[] bytes = null;
    private int len = 0;
    private int currByte = 0;
    private int currIndex = -1;
    private int currBit = 8;
    private int count = 0;

    public BitReader(byte[] byArray) {
        this.bytes = byArray;
        this.len = this.bytes.length;
    }

    public BitReader(byte[] byArray, int n) {
        this.bytes = byArray;
        this.len = n;
    }

    public int remaining() {
        if (this.currIndex == -1) {
            return this.len * 8;
        }
        return 8 - this.currBit + (this.len - this.currIndex - 1) * 8;
    }

    public int count() {
        return this.count;
    }

    public int getBit() {
        int n = 0;
        if (this.currBit >= 8) {
            ++this.currIndex;
            this.currByte = this.bytes[this.currIndex];
            this.currBit = 0;
        }
        n = (this.currByte & 0x80) == 128 ? 1 : 0;
        ++this.count;
        ++this.currBit;
        this.currByte <<= 1;
        return n;
    }

    public void skip() {
        this.getBit();
    }

    public void skip(int n) {
        for (int i = 0; i < n; ++i) {
            this.getBit();
        }
    }

    public int getInt(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 1;
            n2 += this.getBit();
        }
        return n2;
    }

    public int getIntSigned(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 1;
            if (i != 0 || (n2 += this.getBit()) != 1) continue;
            n2 = -1;
        }
        return n2;
    }

    public int readExpGolombSigned() {
        int n = this.readExpGolomb();
        return (n & 1) == 1 ? (n + 1) / 2 : -(n / 2);
    }

    public int readExpGolomb() {
        int n;
        for (n = 0; this.getBit() == 0 && n < 32; ++n) {
        }
        return (1 << n) - 1 + this.getInt(n);
    }
}

