/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import java.nio.ByteBuffer;

public class BufferUtils {
    private static final String[] hexadecimal = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String encodeHexString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xF;
            int n2 = (byArray[i] & 0xF0) >> 4;
            string = string + hexadecimal[n2];
            string = string + hexadecimal[n];
        }
        return string;
    }

    public static byte[] decodeHexString(String string) {
        byte[] byArray = null;
        try {
            if (string.length() % 2 == 1) {
                string = "0" + string;
            }
            byArray = new byte[string.length() / 2];
            int n = 0;
            int n2 = string.length();
            do {
                String string2 = string.substring(n, n + 2);
                byArray[n / 2] = (byte)(Integer.parseInt(string2, 16) & 0xFF);
            } while ((n += 2) < n2);
        }
        catch (Exception exception) {
            System.out.println("BufferUtils.decodeHexString: " + exception.toString());
        }
        return byArray;
    }

    public static String byteArrayToString(byte[] byArray) {
        return BufferUtils.byteArrayToString(byArray, 0, byArray.length);
    }

    public static String byteArrayToString(byte[] byArray, int n, int n2) {
        String string = null;
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            string = new String(byArray2, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static long byteArrayToLong(byte[] byArray) {
        long l = 0L;
        l |= (long)(byArray[0] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[1] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[2] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[3] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[4] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[5] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[6] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[7] & 0xFF);
    }

    public static long byteArrayToLong(byte[] byArray, int n) {
        long l = 0L;
        l |= (long)(byArray[n + 0] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 1] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 2] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 3] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 4] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 5] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 6] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[n + 7] & 0xFF);
    }

    public static long byteArrayToLong(byte[] byArray, int n, int n2) {
        return BufferUtils.byteArrayToLong(byArray, n, n2, false);
    }

    public static long byteArrayToLong(byte[] byArray, int n, int n2, boolean bl) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                l <<= 8;
            }
            if (bl) {
                l |= (long)(byArray[n + (n2 - (i + 1))] & 0xFF);
                continue;
            }
            l |= (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    public static int byteArrayToInt(byte[] byArray) {
        return byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static int byteArrayToInt(byte[] byArray, int n) {
        return byArray[n + 0] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static int byteArrayToInt(byte[] byArray, int n, int n2) {
        return BufferUtils.byteArrayToInt(byArray, n, n2, false);
    }

    public static int byteArrayToInt(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n3 <<= 8;
            }
            if (bl) {
                n3 |= byArray[n + (n2 - (i + 1))] & 0xFF;
                continue;
            }
            n3 |= byArray[n + i] & 0xFF;
        }
        return n3;
    }

    public static int byteArrayToShort(byte[] byArray) {
        return BufferUtils.byteArrayToShort(byArray, 0, 2, false);
    }

    public static int byteArrayToShort(byte[] byArray, int n) {
        return BufferUtils.byteArrayToShort(byArray, n, 2, false);
    }

    public static int byteArrayToShort(byte[] byArray, int n, int n2) {
        return BufferUtils.byteArrayToShort(byArray, n, n2, false);
    }

    public static int byteArrayToShort(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n3 = (short)(n3 << 8);
            }
            n3 = bl ? (int)((short)(n3 | byArray[n + (n2 - (i + 1))] & 0xFF)) : (int)((short)(n3 | byArray[n + i] & 0xFF));
        }
        return n3;
    }

    public static byte[] intToByteArray(int n) {
        return BufferUtils.intToByteArray(n, 4);
    }

    public static byte[] intToByteArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < Math.min(n2, 4); ++i) {
            int n3 = n2 - i - 1;
            byArray[n3] = (byte)(n & 0xFF);
            if ((n >>= 8) == 0) break;
        }
        return byArray;
    }

    public static void intToByteArray(int n, byte[] byArray, int n2, int n3) {
        BufferUtils.intToByteArray(n, byArray, n2, n3, false);
    }

    public static void intToByteArray(int n, byte[] byArray, int n2, int n3, boolean bl) {
        for (int i = 0; i < Math.min(n3, 4); ++i) {
            int n4 = bl ? i : n3 - (i + 1);
            byArray[n2 + n4] = (byte)(n & 0xFF);
            n >>= 8;
        }
    }

    public static byte[] longToByteArray(long l) {
        return BufferUtils.longToByteArray(l, 8);
    }

    public static byte[] longToByteArray(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < Math.min(n, 8); ++i) {
            int n2 = n - i - 1;
            byArray[n2] = (byte)(l & 0xFFL);
            if ((l >>= 8) == 0L) break;
        }
        return byArray;
    }

    public static void longToByteArray(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < Math.min(n2, 8); ++i) {
            int n3 = n2 - i - 1;
            byArray[n + n3] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static void longToByteArray(long l, byte[] byArray, int n, int n2, boolean bl) {
        for (int i = 0; i < Math.min(n2, 8); ++i) {
            int n3 = bl ? i : n2 - (i + 1);
            byArray[n + n3] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static int getUnsignedShort(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[2];
        byteBuffer.get(byArray);
        return BufferUtils.byteArrayToInt(byArray, 0, 2);
    }
}

