/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.io.WowzaRandomAccessFile;
import com.wowza.util.AMFUtils;
import com.wowza.util.BufferUtils;
import com.wowza.util.IFLVWriterAdjustTimecode;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FLVUtils {
    public static final int FLV_CHUNKHEADER_ITYPE = 0;
    public static final int FLV_CHUNKHEADER_ISIZE = 1;
    public static final int FLV_CHUNKHEADER_ITIMECODE = 2;
    public static final int FLV_CHUNKHEADER_FIRSTBYTE = 3;
    public static final int FLV_CHUNKHEADER_SECONDBYTE = 4;
    public static final int FLV_CHUNKHEADER_HEADERSIZE = 11;
    public static final int FLV_CHUNKHEADER_BUFFERSIZE = 13;
    public static final int FLV_CHUNKHEADER_VALUESIZE = 5;
    public static final int FLV_UFRAME = 0;
    public static final int FLV_KFRAME = 1;
    public static final int FLV_DFRAME = 3;
    public static final int FLV_PFRAME = 2;
    public static final int FLV_TCINDEXAUDIO = 0;
    public static final int FLV_TCINDEXVIDEO = 1;
    public static final int FLV_TCINDEXDATA = 2;

    public static int getFrameType(int[] nArray) {
        return nArray[3] >> 4 & 3;
    }

    public static int getFrameType(int n) {
        return n >> 4 & 3;
    }

    public static int getAudioCodec(int n) {
        return n >> 4 & 0xF;
    }

    public static int getVideoCodec(int n) {
        return n & 0xF;
    }

    public static int getFrameType(byte by) {
        return by >> 4 & 3;
    }

    public static AMFPacket readChunk(InputStream inputStream) {
        byte[] byArray = new byte[4];
        if (inputStream == null) {
            return null;
        }
        AMFPacket aMFPacket = null;
        try {
            int n = 0;
            n = inputStream.read(byArray, 0, 1);
            if (n != -1) {
                int n2 = 0xFF & byArray[0];
                n = inputStream.read(byArray, 0, 3);
                if (n != -1) {
                    int n3 = BufferUtils.byteArrayToInt(byArray, 0, 3, false);
                    n = inputStream.read(byArray, 0, 3);
                    if (n != -1) {
                        long l = BufferUtils.byteArrayToInt(byArray, 0, 3, false);
                        n = inputStream.read(byArray, 0, 4);
                        if (n != -1) {
                            aMFPacket = new AMFPacket(n2, 0, n3);
                            aMFPacket.setTimecode(l);
                            byte[] byArray2 = new byte[n3];
                            n = inputStream.read(byArray2);
                            if (n != -1) {
                                aMFPacket.addData(byArray2, 0, n3);
                                n = inputStream.read(byArray, 0, 4);
                                if (n == -1) {
                                    // empty if block
                                }
                            }
                        }
                    }
                }
            }
            if (n == -1) {
                aMFPacket = null;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("readChunk: " + exception.toString());
        }
        return aMFPacket;
    }

    public static AMFPacket readChunk(DataInput dataInput) {
        byte[] byArray = new byte[4];
        if (dataInput == null) {
            return null;
        }
        AMFPacket aMFPacket = null;
        try {
            dataInput.readFully(byArray, 0, 1);
            int n = 0xFF & byArray[0];
            dataInput.readFully(byArray, 0, 3);
            int n2 = BufferUtils.byteArrayToInt(byArray, 0, 3, false);
            dataInput.readFully(byArray, 0, 3);
            long l = BufferUtils.byteArrayToInt(byArray, 0, 3, false);
            dataInput.readFully(byArray, 0, 4);
            aMFPacket = new AMFPacket(n, 0, n2);
            aMFPacket.setTimecode(l);
            byte[] byArray2 = new byte[n2];
            dataInput.readFully(byArray2);
            aMFPacket.addData(byArray2, 0, n2);
            dataInput.readFully(byArray, 0, 4);
        }
        catch (Exception exception) {
            aMFPacket = null;
        }
        return aMFPacket;
    }

    public static void readPrevChunkHeader(RandomAccessFile randomAccessFile, byte[] byArray, int[] nArray) {
        nArray[0] = 127;
        if (randomAccessFile == null) {
            return;
        }
        try {
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 4L);
            randomAccessFile.readFully(byArray, 0, 4);
            int n = BufferUtils.byteArrayToInt(byArray, 0, 4, false);
            if (n > 0) {
                randomAccessFile.seek(randomAccessFile.getFilePointer() - (long)(n + 4));
                randomAccessFile.readFully(byArray, 0, 13);
                nArray[0] = byArray[0] & 0xFF;
                nArray[1] = byArray[1] & 0xFF;
                nArray[1] = nArray[1] << 8;
                nArray[1] = nArray[1] | byArray[2] & 0xFF;
                nArray[1] = nArray[1] << 8;
                nArray[1] = nArray[1] | byArray[3] & 0xFF;
                nArray[2] = byArray[7] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[4] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[5] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[6] & 0xFF;
                nArray[3] = byArray[11] & 0xFF;
                nArray[4] = byArray[12] & 0xFF;
                randomAccessFile.seek(randomAccessFile.getFilePointer() - 2L);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("readPrevChunkHeader: " + exception.toString());
        }
    }

    public static void readChunkHeader(RandomAccessFile randomAccessFile, byte[] byArray, int[] nArray) {
        nArray[0] = 127;
        if (randomAccessFile == null) {
            return;
        }
        long l = 0L;
        try {
            l = randomAccessFile.getFilePointer();
            randomAccessFile.readFully(byArray, 0, 13);
            nArray[0] = byArray[0] & 0xFF;
            nArray[1] = byArray[1] & 0xFF;
            nArray[1] = nArray[1] << 8;
            nArray[1] = nArray[1] | byArray[2] & 0xFF;
            nArray[1] = nArray[1] << 8;
            nArray[1] = nArray[1] | byArray[3] & 0xFF;
            nArray[2] = byArray[7] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[4] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[5] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[6] & 0xFF;
            nArray[3] = byArray[11];
            nArray[4] = byArray[12];
            randomAccessFile.seek(l + 11L);
        }
        catch (Exception exception) {
            nArray[0] = 127;
        }
    }

    public static boolean readHeader(InputStream inputStream) {
        byte[] byArray = new byte[4];
        boolean bl = true;
        if (inputStream == null) {
            return false;
        }
        try {
            int n = 0;
            n = inputStream.read(byArray, 0, 4);
            if (n == -1 || (n = inputStream.read(byArray, 0, 1)) == -1 || (n = inputStream.read(byArray, 0, 4)) == -1 || (n = inputStream.read(byArray, 0, 4)) == -1) {
                // empty if block
            }
            if (n == -1) {
                bl = false;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("readHeader: " + exception.toString());
        }
        return bl;
    }

    public static boolean readHeader(DataInput dataInput) {
        byte[] byArray = new byte[4];
        boolean bl = true;
        if (dataInput == null) {
            return false;
        }
        try {
            dataInput.readFully(byArray, 0, 4);
            dataInput.readFully(byArray, 0, 1);
            dataInput.readFully(byArray, 0, 4);
            dataInput.readFully(byArray, 0, 4);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("readHeader: " + exception.toString());
            bl = false;
        }
        return bl;
    }

    public static void writeShortHeader(OutputStream outputStream) {
        byte[] byArray = new byte[4];
        if (outputStream == null) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("writeHeader: this.ds=null");
            return;
        }
        try {
            byArray[0] = 70;
            byArray[1] = 76;
            byArray[2] = 86;
            byArray[3] = 1;
            outputStream.write(byArray);
            byArray[0] = 5;
            outputStream.write(byArray, 0, 1);
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 9;
            outputStream.write(byArray);
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 0;
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("writeHeader: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void writeHeader(OutputStream outputStream, double d, Map map) {
        byte[] byArray = new byte[4];
        if (outputStream == null) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("writeHeader: this.ds=null");
            return;
        }
        try {
            Object[] objectArray;
            byArray[0] = 70;
            byArray[1] = 76;
            byArray[2] = 86;
            byArray[3] = 1;
            outputStream.write(byArray);
            byArray[0] = 5;
            outputStream.write(byArray, 0, 1);
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 9;
            outputStream.write(byArray);
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 0;
            outputStream.write(byArray);
            byte by = 18;
            Date date = new Date();
            String string = "EEE MMM d HH:mm:ss";
            FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)string);
            String string2 = fastDateFormat.format(date);
            AMFDataList aMFDataList = new AMFDataList();
            AMFDataMixedArray aMFDataMixedArray = new AMFDataMixedArray();
            aMFDataMixedArray.put("duration", new AMFDataItem(d));
            aMFDataMixedArray.put("creationdate", new AMFDataItem(string2));
            if (map != null) {
                objectArray = new Object[1];
                for (String string3 : map.keySet()) {
                    objectArray[0] = map.get(string3);
                    AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
                    if (aMFDataArray == null) continue;
                    aMFDataMixedArray.put(string3, aMFDataArray[0]);
                }
            }
            aMFDataList.add(new AMFDataItem("onMetaData"));
            aMFDataList.add(aMFDataMixedArray);
            objectArray = aMFDataList.serialize();
            int n = objectArray.length;
            long l = 0L;
            FLVUtils.writeChunk(outputStream, ByteBuffer.wrap((byte[])objectArray), n, l, by);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("writeHeader: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void writeChunk(OutputStream outputStream, ByteBuffer byteBuffer, int n, long l, byte by) {
        byte[] byArray = new byte[4];
        if (outputStream == null) {
            return;
        }
        try {
            byArray[0] = by;
            outputStream.write(byArray, 0, 1);
            byArray[0] = (byte)(0xFF & n >> 16);
            byArray[1] = (byte)(0xFF & n >> 8);
            byArray[2] = (byte)(0xFF & n);
            outputStream.write(byArray, 0, 3);
            byArray[0] = (byte)(0xFFL & l >> 16);
            byArray[1] = (byte)(0xFFL & l >> 8);
            byArray[2] = (byte)(0xFFL & l);
            byArray[3] = (byte)(0xFFL & l >> 24);
            outputStream.write(byArray, 0, 4);
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            outputStream.write(byArray, 0, 3);
            if (byteBuffer != null) {
                byte[] byArray2 = byteBuffer.array();
                if (byArray2 != null) {
                    outputStream.write(byArray2, 0, n);
                } else {
                    WMSLoggerFactory.getLogger(FLVUtils.class).error("writeChunk: dataArr=null: size: " + n);
                }
            }
            int n2 = n + 11;
            byArray[0] = (byte)(0xFF & n2 >> 24);
            byArray[1] = (byte)(0xFF & n2 >> 16);
            byArray[2] = (byte)(0xFF & n2 >> 8);
            byArray[3] = (byte)(0xFF & n2);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("writeChunk: " + exception.toString());
            WMSLoggerFactory.getLogger(FLVUtils.class).error("   type: " + by);
            WMSLoggerFactory.getLogger(FLVUtils.class).error("   data: " + byteBuffer);
            WMSLoggerFactory.getLogger(FLVUtils.class).error("   timecode: " + l);
            WMSLoggerFactory.getLogger(FLVUtils.class).error("   size: " + n);
            WMSLoggerFactory.getLogger(FLVUtils.class).error("   buffer: " + byArray);
            WMSLoggerFactory.getLogger(FLVUtils.class).error("   ds: " + outputStream);
            WMSLoggerFactory.getLogger(FLVUtils.class).error("writeChunk: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static List interleavePackets(List list, List list2, List list3, List list4, List list5, List list6, long[] lArray) {
        return FLVUtils.interleavePackets(list, list2, list3, list4, list5, list6, null, lArray);
    }

    public static List<AMFPacket> interleavePackets(List list, List list2, List list3, List list4, List list5, List list6, List list7, long[] lArray) {
        ArrayList<AMFPacket> arrayList = new ArrayList<AMFPacket>();
        try {
            long l = lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (list4.size() != n || list5.size() != n2 || list6.size() != n3) {
                ByteBuffer byteBuffer;
                long l4 = Long.MAX_VALUE;
                long l5 = Long.MAX_VALUE;
                long l6 = Long.MAX_VALUE;
                long l7 = 0L;
                long l8 = 0L;
                long l9 = 0L;
                if (list4.size() > n) {
                    l4 = l7 = ((Long)list4.get(n)).longValue();
                    l4 += l;
                }
                if (list5.size() > n2) {
                    l5 = l8 = ((Long)list5.get(n2)).longValue();
                    l5 += l2;
                }
                if (list6.size() > n3) {
                    l6 = l9 = ((Long)list6.get(n3)).longValue();
                    l6 += l3;
                }
                AMFPacket aMFPacket = null;
                if (l6 <= l5 && l6 <= l4) {
                    byteBuffer = (ByteBuffer)list3.get(n3);
                    int n4 = list7 == null ? 18 : (int)((Integer)list7.get(n3)).byteValue();
                    aMFPacket = new AMFPacket();
                    aMFPacket.setType(n4);
                    aMFPacket.setTimecode(l9);
                    aMFPacket.setAbsTimecode(l6);
                    aMFPacket.setDataBuffer(byteBuffer);
                    l3 = l6;
                    ++n3;
                } else if (l5 <= l4 && l5 <= l6) {
                    byteBuffer = (ByteBuffer)list2.get(n2);
                    aMFPacket = new AMFPacket();
                    aMFPacket.setType(9);
                    aMFPacket.setTimecode(l8);
                    aMFPacket.setAbsTimecode(l5);
                    aMFPacket.setDataBuffer(byteBuffer);
                    l2 = l5;
                    ++n2;
                } else {
                    byteBuffer = (ByteBuffer)list.get(n);
                    aMFPacket = new AMFPacket();
                    aMFPacket.setType(8);
                    aMFPacket.setTimecode(l7);
                    aMFPacket.setAbsTimecode(l4);
                    aMFPacket.setDataBuffer(byteBuffer);
                    l = l4;
                    ++n;
                }
                if (aMFPacket == null) continue;
                arrayList.add(aMFPacket);
            }
            lArray[0] = l;
            lArray[1] = l2;
            lArray[2] = l3;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("interleavePackets: audio:" + list4.size() + " video:" + list5.size() + " data:" + list6.size() + " error:" + exception.toString());
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static void writePackets(OutputStream outputStream, List list, long l) {
        try {
            for (AMFPacket aMFPacket : list) {
                ByteBuffer byteBuffer = aMFPacket.getDataBuffer();
                long l2 = aMFPacket.getAbsTimecode() - l;
                if (l2 < 0L) {
                    WMSLoggerFactory.getLogger(FLVUtils.class).warn("writePackets: timecode less than zero: " + aMFPacket.getAbsTimecode() + ":" + l);
                    l2 = 0L;
                }
                FLVUtils.writeChunk(outputStream, byteBuffer, byteBuffer.limit(), l2, (byte)aMFPacket.getType());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("writePackets: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void writePackets(OutputStream outputStream, List list, List list2, List list3, List list4, List list5, List list6, long[] lArray) {
        FLVUtils.writePackets(outputStream, list, list2, list3, list4, list5, list6, null, lArray);
    }

    public static void writePackets(OutputStream outputStream, List list, List list2, List list3, List list4, List list5, List list6, List list7, long[] lArray) {
        FLVUtils.writePackets(outputStream, list, list2, list3, list4, list5, list6, list7, lArray, null);
    }

    public static void writePackets(OutputStream outputStream, List list, List list2, List list3, List list4, List list5, List list6, List list7, long[] lArray, IFLVWriterAdjustTimecode iFLVWriterAdjustTimecode) {
        try {
            long l = lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            while (list4.size() != 0 || list5.size() != 0 || list6.size() != 0) {
                ByteBuffer byteBuffer;
                long l4 = Long.MAX_VALUE;
                long l5 = Long.MAX_VALUE;
                long l6 = Long.MAX_VALUE;
                if (list4.size() > 0) {
                    l4 = (Long)list4.get(0);
                    l4 += l;
                }
                if (list5.size() > 0) {
                    l5 = (Long)list5.get(0);
                    l5 += l2;
                }
                if (list6.size() > 0) {
                    l6 = (Long)list6.get(0);
                    l6 += l3;
                }
                if (l6 <= l5 && l6 <= l4) {
                    ByteBuffer byteBuffer2;
                    byte by;
                    byteBuffer = (ByteBuffer)list3.get(0);
                    byte by2 = by = list7 == null ? (byte)18 : (byte)((Integer)list7.get(0)).byteValue();
                    if (iFLVWriterAdjustTimecode != null && (byteBuffer2 = iFLVWriterAdjustTimecode.adjustDataTimecode(byteBuffer, by, l6)) != null) {
                        byteBuffer = byteBuffer2;
                    }
                    FLVUtils.writeChunk(outputStream, byteBuffer, byteBuffer.limit(), l6, by);
                    l3 = l6;
                    if (list7 != null) {
                        list7.remove(0);
                    }
                    list3.remove(0);
                    list6.remove(0);
                    continue;
                }
                if (l5 <= l4 && l5 <= l6) {
                    byteBuffer = (ByteBuffer)list2.get(0);
                    FLVUtils.writeChunk(outputStream, byteBuffer, byteBuffer.limit(), l5, (byte)9);
                    l2 = l5;
                    list2.remove(0);
                    list5.remove(0);
                    continue;
                }
                byteBuffer = (ByteBuffer)list.get(0);
                FLVUtils.writeChunk(outputStream, byteBuffer, byteBuffer.limit(), l4, (byte)8);
                l = l4;
                list.remove(0);
                list4.remove(0);
            }
            lArray[0] = l;
            lArray[1] = l2;
            lArray[2] = l3;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("writePackets: audio:" + list4.size() + " video:" + list5.size() + " data:" + list6.size() + " error:" + exception.toString());
            exception.printStackTrace();
        }
    }

    public static long adjustFirstPacketTCs(List list, List list2, List list3) {
        long l;
        long l2 = 0L;
        long l3 = list.size() > 0 ? (Long)list.get(0) : Long.MAX_VALUE;
        long l4 = list2.size() > 0 ? (Long)list2.get(0) : Long.MAX_VALUE;
        long l5 = list3.size() > 0 ? (Long)list3.get(0) : Long.MAX_VALUE;
        l2 = Math.min(l3, Math.min(l4, l5));
        if (list.size() > 0) {
            l = (Long)list.get(0);
            list.set(0, new Long(l - l2));
        }
        if (list2.size() > 0) {
            l = (Long)list2.get(0);
            list2.set(0, new Long(l - l2));
        }
        if (list3.size() > 0) {
            l = (Long)list3.get(0);
            list3.set(0, new Long(l - l2));
        }
        return l2;
    }

    public static void writeDuration(File file, double d) {
        WowzaRandomAccessFile wowzaRandomAccessFile;
        block9: {
            wowzaRandomAccessFile = null;
            try {
                wowzaRandomAccessFile = new WowzaRandomAccessFile(file.toString(), "rw");
                wowzaRandomAccessFile.seek(44L);
                byte[] byArray = new byte[8];
                wowzaRandomAccessFile.read(byArray);
                String string = "";
                try {
                    string = new String(byArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = false;
                if (!bl && string != null && string.equals("duration")) {
                    wowzaRandomAccessFile.seek(53L);
                    wowzaRandomAccessFile.writeDouble(d);
                    bl = true;
                }
                if (bl) break block9;
                wowzaRandomAccessFile.seek(13L);
                int[] nArray = new int[5];
                byte[] byArray2 = new byte[13];
                FLVUtils.readChunkHeader(wowzaRandomAccessFile, byArray2, nArray);
                if (nArray[0] != 18 && nArray[0] != 15) break block9;
                byte[] byArray3 = new byte[nArray[1]];
                wowzaRandomAccessFile.read(byArray3, 0, byArray3.length);
                for (int i = 0; i < byArray3.length - 10; ++i) {
                    if (byArray3[i + 0] != 8 || byArray3[i + 1] != 100 || byArray3[i + 2] != 117 || byArray3[i + 3] != 114 || byArray3[i + 4] != 97 || byArray3[i + 5] != 116 || byArray3[i + 6] != 105 || byArray3[i + 7] != 111 || byArray3[i + 8] != 110 || byArray3[i + 9] != 0) continue;
                    wowzaRandomAccessFile.seek(wowzaRandomAccessFile.getFilePointer() - (long)nArray[1] + (long)i + 10L);
                    wowzaRandomAccessFile.writeDouble(d);
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(FLVUtils.class).error("writeDuration[1]: " + exception.toString());
                exception.printStackTrace();
            }
        }
        try {
            if (wowzaRandomAccessFile != null) {
                ((RandomAccessFile)wowzaRandomAccessFile).close();
            }
            wowzaRandomAccessFile = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("writeDuration[2]: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static long getLastTC(File file) {
        Closeable closeable;
        long l = 0L;
        boolean bl = false;
        if (!bl) {
            closeable = null;
            try {
                AMFDataMixedArray aMFDataMixedArray;
                AMFDataList aMFDataList;
                closeable = new BufferedInputStream(new FileInputStream(file));
                FLVUtils.readHeader((InputStream)closeable);
                AMFPacket aMFPacket = FLVUtils.readChunk((InputStream)closeable);
                if (aMFPacket.getType() == 18 && (aMFDataList = new AMFDataList(aMFPacket.getData())).size() > 1 && aMFDataList.get(1).getType() == 8 && (aMFDataMixedArray = (AMFDataMixedArray)aMFDataList.get(1)).containsKey("duration")) {
                    double d = aMFDataMixedArray.getDouble("duration");
                    l = Math.round(d * 1000.0);
                    bl = true;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(FLVUtils.class).error("getLastTC[1]: " + exception.toString());
            }
            try {
                if (closeable != null) {
                    ((BufferedInputStream)closeable).close();
                }
                closeable = null;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(FLVUtils.class).error("getLastTC[2]: " + exception.toString());
            }
        }
        if (!bl) {
            closeable = null;
            try {
                closeable = new WowzaRandomAccessFile(file.toString(), "r");
                long l2 = ((RandomAccessFile)closeable).length();
                if (l2 > 17L) {
                    ((RandomAccessFile)closeable).seek(l2 - 4L);
                    int n = ((RandomAccessFile)closeable).readInt();
                    if (n > 0) {
                        ((RandomAccessFile)closeable).seek(l2 - (long)(n + 4));
                        int[] nArray = new int[5];
                        byte[] byArray = new byte[13];
                        FLVUtils.readChunkHeader((RandomAccessFile)closeable, byArray, nArray);
                        l = (long)nArray[2] & 0xFFFFFFFFL;
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(FLVUtils.class).error("getLastTC[1]: " + exception.toString());
            }
            try {
                if (closeable != null) {
                    ((RandomAccessFile)closeable).close();
                }
                closeable = null;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(FLVUtils.class).error("getLastTC[2]: " + exception.toString());
            }
        }
        return l;
    }

    public static boolean isVideoKeyFrame(AMFPacket aMFPacket) {
        boolean bl;
        block2: {
            bl = false;
            if (aMFPacket.getType() != 9 || aMFPacket.getSize() < 2) break block2;
            int n = aMFPacket.getFirstByte();
            boolean bl2 = bl = FLVUtils.getFrameType(n) == 1;
            if (bl) {
                int n2 = aMFPacket.getSecondByte();
                int n3 = FLVUtils.getVideoCodec(n);
                if (n3 == 7 && n2 != 1) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static boolean isVideoKeyFrame(ByteBuffer byteBuffer) {
        boolean bl;
        block2: {
            bl = false;
            if (byteBuffer.limit() < 2) break block2;
            int n = byteBuffer.get(0) & 0xFF;
            boolean bl2 = bl = FLVUtils.getFrameType(n) == 1;
            if (bl) {
                int n2 = byteBuffer.get(1) & 0xFF;
                int n3 = FLVUtils.getVideoCodec(n);
                if (n3 == 7 && n2 != 1) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static boolean isVideoKeyFrame(byte[] byArray) {
        boolean bl;
        block2: {
            bl = false;
            if (byArray.length < 2) break block2;
            int n = byArray[0] & 0xFF;
            boolean bl2 = bl = FLVUtils.getFrameType(n) == 1;
            if (bl) {
                int n2 = byArray[1] & 0xFF;
                int n3 = FLVUtils.getVideoCodec(n);
                if (n3 == 7 && n2 != 1) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static boolean isVideoKeyFrame(int[] nArray) {
        boolean bl;
        block2: {
            bl = false;
            if (nArray[0] != 9) break block2;
            boolean bl2 = bl = FLVUtils.getFrameType(nArray[3]) == 1;
            if (bl) {
                int n = nArray[4] & 0xFF;
                int n2 = FLVUtils.getVideoCodec(nArray[3]);
                if (n2 == 7 && n != 1) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static AMFPacket updateOnCuePointTimecode(AMFPacket aMFPacket, long l) {
        AMFPacket aMFPacket2 = null;
        try {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2;
            if (aMFPacket.getSize() > 0 && (byteBuffer2 = aMFPacket.getDataBuffer()) != null && (byteBuffer = FLVUtils.updateOnCuePointTimecode(byteBuffer2, aMFPacket.getType(), l)) != null) {
                byte[] byArray = new byte[byteBuffer.limit()];
                int n = byteBuffer.position();
                byteBuffer.get(byArray);
                byteBuffer.position(n);
                aMFPacket2 = new AMFPacket(aMFPacket.getType(), aMFPacket.getSrc(), byArray.length);
                aMFPacket2.setTimecode(aMFPacket.getTimecode());
                aMFPacket2.setAbsTimecode(aMFPacket.getAbsTimecode());
                aMFPacket2.addData(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("FLVUtils.updateOnCuePointTimecode: " + exception.toString());
        }
        return aMFPacket2;
    }

    public static ByteBuffer updateOnCuePointTimecode(ByteBuffer byteBuffer, int n, long l) {
        ByteBuffer byteBuffer2 = null;
        try {
            int n2;
            String string;
            AMFDataList aMFDataList;
            if (byteBuffer != null && byteBuffer.limit() > 0 && (aMFDataList = new AMFDataList(byteBuffer)) != null && aMFDataList.size() >= 2 && aMFDataList.get(0).getType() == 2 && (string = aMFDataList.getString(0)).equalsIgnoreCase("oncuepoint") && ((n2 = aMFDataList.get(1).getType()) == 3 || n2 == 8)) {
                Object object;
                boolean bl = false;
                switch (n2) {
                    case 3: {
                        object = (AMFDataObj)aMFDataList.get(1);
                        if (!((AMFDataObj)object).containsKey("time")) break;
                        ((AMFDataObj)object).put("time", new AMFDataItem((double)l / 1000.0));
                        bl = true;
                        break;
                    }
                    case 8: {
                        AMFDataMixedArray aMFDataMixedArray = (AMFDataMixedArray)aMFDataList.get(1);
                        if (!aMFDataMixedArray.containsKey("time")) break;
                        aMFDataMixedArray.put("time", new AMFDataItem((double)l / 1000.0));
                        bl = true;
                    }
                }
                if (bl && (object = (Object)aMFDataList.serialize(n == 15 ? 3 : 0)) != null) {
                    byteBuffer2 = ByteBuffer.wrap((byte[])object);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FLVUtils.class).error("FLVUtils.updateOnCuePointTimecode: " + exception.toString());
        }
        return byteBuffer2;
    }
}

