/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.util.NoMBean;

public class IOPerformanceCounter {
    private static final int INCOUNT = 0;
    private static final int OUTCOUNT = 1;
    private static final int LOSSCOUNT = 2;
    private static final int INBYTES = 3;
    private static final int OUTBYTES = 4;
    private static final int LOSSBYTES = 5;
    private static final int INFILEBYTES = 6;
    private static final int OUTFILEBYTES = 7;
    private static final int RATECOUNT = 8;
    private long messagesInCount = 0L;
    private long messagesOutCount = 0L;
    private long messagesLossCount = 0L;
    private long messagesInBytes = 0L;
    private long fileInBytes = 0L;
    private long messagesOutBytes = 0L;
    private long fileOutBytes = 0L;
    private long messagesLossBytes = 0L;
    private Object messagesInLock = new Object();
    private Object messagesOutLock = new Object();
    private Object messagesLossLock = new Object();
    private long rateWindow = 2000L;
    private long[] lastRateValue = new long[8];
    private long[] lastRateValue2 = new long[8];
    private long[] lastRateTime = new long[8];
    private long[] lastRateTime2 = new long[8];

    public IOPerformanceCounter() {
        long l = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            this.lastRateValue[i] = 0L;
            this.lastRateValue2[i] = 0L;
            this.lastRateTime[i] = l;
            this.lastRateTime2[i] = -1L;
        }
    }

    private void cloneRate(int n, IOPerformanceCounter iOPerformanceCounter) {
        iOPerformanceCounter.lastRateValue[n] = this.lastRateValue[n];
        iOPerformanceCounter.lastRateValue2[n] = this.lastRateValue2[n];
        iOPerformanceCounter.lastRateTime[n] = this.lastRateTime[n];
        iOPerformanceCounter.lastRateTime2[n] = this.lastRateTime2[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public IOPerformanceCounter clone() {
        IOPerformanceCounter iOPerformanceCounter = new IOPerformanceCounter();
        Object object = this.messagesInLock;
        synchronized (object) {
            iOPerformanceCounter.messagesInCount = this.messagesInCount;
            iOPerformanceCounter.messagesInBytes = this.messagesInBytes;
            iOPerformanceCounter.fileInBytes = this.fileInBytes;
            this.cloneRate(0, iOPerformanceCounter);
            this.cloneRate(3, iOPerformanceCounter);
        }
        object = this.messagesOutLock;
        synchronized (object) {
            iOPerformanceCounter.messagesOutCount = this.messagesOutCount;
            iOPerformanceCounter.messagesOutBytes = this.messagesOutBytes;
            iOPerformanceCounter.fileOutBytes = this.fileOutBytes;
            this.cloneRate(1, iOPerformanceCounter);
            this.cloneRate(4, iOPerformanceCounter);
        }
        object = this.messagesLossLock;
        synchronized (object) {
            iOPerformanceCounter.messagesLossCount = this.messagesLossCount;
            iOPerformanceCounter.messagesLossBytes = this.messagesLossBytes;
            this.cloneRate(2, iOPerformanceCounter);
            this.cloneRate(5, iOPerformanceCounter);
        }
        return iOPerformanceCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addDifference(IOPerformanceCounter iOPerformanceCounter, IOPerformanceCounter iOPerformanceCounter2) {
        Object object = this.messagesInLock;
        synchronized (object) {
            this.messagesInCount += iOPerformanceCounter.messagesInCount - (iOPerformanceCounter2 == null ? 0L : iOPerformanceCounter2.messagesInCount);
            this.messagesInBytes += iOPerformanceCounter.messagesInBytes - (iOPerformanceCounter2 == null ? 0L : iOPerformanceCounter2.messagesInBytes);
            this.fileInBytes += iOPerformanceCounter.fileInBytes - (iOPerformanceCounter2 == null ? 0L : iOPerformanceCounter2.fileInBytes);
        }
        object = this.messagesOutLock;
        synchronized (object) {
            this.messagesOutCount += iOPerformanceCounter.messagesOutCount - (iOPerformanceCounter2 == null ? 0L : iOPerformanceCounter2.messagesOutCount);
            this.messagesOutBytes += iOPerformanceCounter.messagesOutBytes - (iOPerformanceCounter2 == null ? 0L : iOPerformanceCounter2.messagesOutBytes);
            this.fileOutBytes += iOPerformanceCounter.fileOutBytes - (iOPerformanceCounter2 == null ? 0L : iOPerformanceCounter2.fileOutBytes);
        }
        object = this.messagesLossLock;
        synchronized (object) {
            this.messagesLossCount += iOPerformanceCounter.messagesLossCount - (iOPerformanceCounter2 == null ? 0L : iOPerformanceCounter2.messagesLossCount);
            this.messagesLossBytes += iOPerformanceCounter.messagesLossBytes - (iOPerformanceCounter2 == null ? 0L : iOPerformanceCounter2.messagesLossBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void clear() {
        Object object = this.messagesInLock;
        synchronized (object) {
            this.messagesInCount = 0L;
            this.messagesInBytes = 0L;
            this.fileInBytes = 0L;
        }
        object = this.messagesOutLock;
        synchronized (object) {
            this.messagesOutCount = 0L;
            this.messagesOutBytes = 0L;
            this.fileOutBytes = 0L;
        }
        object = this.messagesLossLock;
        synchronized (object) {
            this.messagesLossCount = 0L;
            this.messagesLossBytes = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void add(IOPerformanceCounter iOPerformanceCounter) {
        Object object = this.messagesInLock;
        synchronized (object) {
            this.messagesInCount += iOPerformanceCounter.getMessagesInCount();
            this.messagesInBytes += iOPerformanceCounter.getMessagesInBytes();
            this.fileInBytes += iOPerformanceCounter.getFileInBytes();
        }
        object = this.messagesOutLock;
        synchronized (object) {
            this.messagesOutCount += iOPerformanceCounter.getMessagesOutCount();
            this.messagesOutBytes += iOPerformanceCounter.getMessagesOutBytes();
            this.fileOutBytes += iOPerformanceCounter.getFileOutBytes();
        }
        object = this.messagesLossLock;
        synchronized (object) {
            this.messagesLossCount += iOPerformanceCounter.getMessagesLossCount();
            this.messagesLossBytes += iOPerformanceCounter.getMessagesLossBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void doSet(IOPerformanceCounter iOPerformanceCounter) {
        Object object = this.messagesInLock;
        synchronized (object) {
            this.messagesInCount = iOPerformanceCounter.getMessagesInCount();
            this.messagesInBytes = iOPerformanceCounter.getMessagesInBytes();
            this.fileInBytes = iOPerformanceCounter.getFileInBytes();
        }
        object = this.messagesOutLock;
        synchronized (object) {
            this.messagesOutCount = iOPerformanceCounter.getMessagesOutCount();
            this.messagesOutBytes = iOPerformanceCounter.getMessagesOutBytes();
            this.fileOutBytes = iOPerformanceCounter.getFileOutBytes();
        }
        object = this.messagesLossLock;
        synchronized (object) {
            this.messagesLossCount = iOPerformanceCounter.getMessagesLossCount();
            this.messagesLossBytes = iOPerformanceCounter.getMessagesLossBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementMessagesIn(long l) {
        Object object = this.messagesInLock;
        synchronized (object) {
            ++this.messagesInCount;
            this.messagesInBytes += l;
            return this.messagesInBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementFileIn(long l) {
        Object object = this.messagesInLock;
        synchronized (object) {
            this.fileInBytes += l;
            return this.fileInBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementMessagesIn(long l, long l2) {
        Object object = this.messagesInLock;
        synchronized (object) {
            this.messagesInCount += l2;
            this.messagesInBytes += l;
            return this.messagesInBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementBytesIn(long l) {
        Object object = this.messagesInLock;
        synchronized (object) {
            this.messagesInBytes += l;
            return this.messagesInBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementMessagesIn() {
        Object object = this.messagesInLock;
        synchronized (object) {
            ++this.messagesInCount;
            return this.messagesInCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementMessagesOut(long l) {
        Object object = this.messagesOutLock;
        synchronized (object) {
            ++this.messagesOutCount;
            this.messagesOutBytes += l;
            return this.messagesOutBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementFileOut(long l) {
        Object object = this.messagesOutLock;
        synchronized (object) {
            this.fileOutBytes += l;
            return this.fileOutBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementMessagesLoss(long l) {
        Object object = this.messagesLossLock;
        synchronized (object) {
            ++this.messagesLossCount;
            this.messagesLossBytes += l;
            return this.messagesLossBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementMessagesOut(long l, long l2) {
        Object object = this.messagesOutLock;
        synchronized (object) {
            this.messagesOutCount += l2;
            this.messagesOutBytes += l;
            return this.messagesOutBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementMessagesLoss(long l, long l2) {
        Object object = this.messagesLossLock;
        synchronized (object) {
            this.messagesLossCount += l2;
            this.messagesLossBytes += l;
            return this.messagesLossBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementBytesOut(long l) {
        Object object = this.messagesOutLock;
        synchronized (object) {
            this.messagesOutBytes += l;
            return this.messagesOutBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementBytesLoss(long l) {
        Object object = this.messagesLossLock;
        synchronized (object) {
            this.messagesLossBytes += l;
            return this.messagesLossBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementMessagesOut() {
        Object object = this.messagesOutLock;
        synchronized (object) {
            ++this.messagesOutCount;
            return this.messagesOutCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long incrementMessagesLoss() {
        Object object = this.messagesLossLock;
        synchronized (object) {
            ++this.messagesLossCount;
            return this.messagesLossCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesInCount() {
        Object object = this.messagesInLock;
        synchronized (object) {
            return this.messagesInCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesOutCount() {
        Object object = this.messagesOutLock;
        synchronized (object) {
            return this.messagesOutCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesLossCount() {
        Object object = this.messagesLossLock;
        synchronized (object) {
            return this.messagesLossCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesInBytes() {
        Object object = this.messagesInLock;
        synchronized (object) {
            return this.messagesInBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileInBytes() {
        Object object = this.messagesInLock;
        synchronized (object) {
            return this.fileInBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesOutBytes() {
        Object object = this.messagesOutLock;
        synchronized (object) {
            return this.messagesOutBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long getFileOutBytes() {
        Object object = this.messagesOutLock;
        synchronized (object) {
            return this.fileOutBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesLossBytes() {
        Object object = this.messagesLossLock;
        synchronized (object) {
            return this.messagesLossBytes;
        }
    }

    private long computeRate(int n, long l) {
        long l2 = 0L;
        long l3 = System.currentTimeMillis();
        if (this.lastRateTime[n] == -1L) {
            this.lastRateTime[n] = l3;
            this.lastRateValue[n] = l;
        } else {
            long l4 = l3 - this.lastRateTime[n];
            if (l4 > 0L) {
                l2 = Math.round((double)(l - this.lastRateValue[n]) * 1000.0 / (double)l4);
            }
            if (this.lastRateTime2[n] == -1L) {
                if (l3 - this.lastRateTime[n] > this.rateWindow) {
                    this.lastRateTime2[n] = l3;
                    this.lastRateValue2[n] = l;
                }
            } else if (l3 - this.lastRateTime2[n] > this.rateWindow) {
                this.lastRateTime[n] = this.lastRateTime2[n];
                this.lastRateValue[n] = this.lastRateValue2[n];
                this.lastRateTime2[n] = -1L;
                this.lastRateValue2[n] = 0L;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesInCountRate() {
        long l = 0L;
        Object object = this.messagesInLock;
        synchronized (object) {
            l = this.computeRate(0, this.messagesInCount);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesOutCountRate() {
        long l = 0L;
        Object object = this.messagesOutLock;
        synchronized (object) {
            l = this.computeRate(1, this.messagesOutCount);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesLossCountRate() {
        long l = 0L;
        Object object = this.messagesLossLock;
        synchronized (object) {
            l = this.computeRate(2, this.messagesLossCount);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMessagesInBytesRate() {
        double d = 0.0;
        Object object = this.messagesInLock;
        synchronized (object) {
            d = this.computeRate(3, this.messagesInBytes);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFileInBytesRate() {
        double d = 0.0;
        Object object = this.messagesInLock;
        synchronized (object) {
            d = this.computeRate(6, this.fileInBytes);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMessagesOutBytesRate() {
        double d = 0.0;
        Object object = this.messagesOutLock;
        synchronized (object) {
            d = this.computeRate(4, this.messagesOutBytes);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public double getFileOutBytesRate() {
        double d = 0.0;
        Object object = this.messagesOutLock;
        synchronized (object) {
            d = this.computeRate(7, this.fileOutBytes);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMessagesLossBytesRate() {
        double d = 0.0;
        Object object = this.messagesLossLock;
        synchronized (object) {
            d = this.computeRate(5, this.messagesLossBytes);
        }
        return d;
    }

    public void dummy() {
    }
}

