/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.wms.admin.AdminServerNotifier;
import com.wowza.wms.admin.AdminVHostItemListener;
import com.wowza.wms.admin.AdminVHostListener;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.JMXRemoteConfig;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHostItemNotify;
import com.wowza.wms.vhost.IVHostNotify;
import com.wowza.wms.vhost.VHostList;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.commons.modeler.Registry;

public class AdminAgent {
    public static final String AGENT_DOMAINNAME = "WowzaMediaServerPro";
    private JMXRemoteConfig jmxRemoteConfig = null;
    private IServer server = null;
    private VHostList vhostList = null;
    private JMXConnectorServer jmxServer = null;
    private java.rmi.registry.Registry jmxRegistry = null;

    private String getObjectName() {
        return "WowzaMediaServerPro:";
    }

    public AdminAgent() {
        this.init();
    }

    public AdminAgent(IServer iServer) {
        this.server = iServer;
        this.init();
    }

    public AdminAgent(IServer iServer, VHostList vHostList) {
        this.server = iServer;
        this.vhostList = vHostList;
        this.init();
    }

    public static MBeanServer getMBeanServer() {
        return Registry.getRegistry(null, null).getMBeanServer();
    }

    public static Object getMBeanValue(String string, String string2) {
        Object object = null;
        try {
            ObjectName objectName = new ObjectName(string);
            MBeanServer mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            object = mBeanServer.getAttribute(objectName, string2);
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }

    public static String getMBeanValueStr(String string, String string2, String string3) {
        String string4 = string3;
        try {
            ObjectName objectName = new ObjectName(string);
            MBeanServer mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            string4 = (String)mBeanServer.getAttribute(objectName, string2);
        }
        catch (Exception exception) {
            string4 = string3;
        }
        return string4;
    }

    public static boolean isMBeanServerRunning() {
        try {
            return Registry.getRegistry(null, null).getMBeanServer() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long getMBeanValueLong(String string, String string2, long l) {
        long l2 = l;
        try {
            ObjectName objectName = new ObjectName(string);
            MBeanServer mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            l2 = (Long)mBeanServer.getAttribute(objectName, string2);
        }
        catch (Exception exception) {
            l2 = l;
        }
        return l2;
    }

    public static int getMBeanValueInteger(String string, String string2, int n) {
        int n2 = n;
        try {
            ObjectName objectName = new ObjectName(string);
            MBeanServer mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            n2 = (Integer)mBeanServer.getAttribute(objectName, string2);
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    public static double getMBeanValueDouble(String string, String string2, double d) {
        double d2 = d;
        try {
            ObjectName objectName = new ObjectName(string);
            MBeanServer mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            d2 = (Double)mBeanServer.getAttribute(objectName, string2);
        }
        catch (Exception exception) {
            d2 = d;
        }
        return d2;
    }

    public static float getMBeanValueFloat(String string, String string2, float f) {
        float f2 = f;
        try {
            ObjectName objectName = new ObjectName(string);
            MBeanServer mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            f2 = ((Float)mBeanServer.getAttribute(objectName, string2)).floatValue();
        }
        catch (Exception exception) {
            f2 = f;
        }
        return f2;
    }

    private void init() {
        Object object;
        Object object2;
        try {
            if (this.server != null) {
                object2 = this.getObjectName();
                Registry.getRegistry(null, null).registerComponent((Object)this.server, (String)object2 + "name=Server", this.server.getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.server.getIoPerformanceCounter(), (String)object2 + "name=IOPerformance", this.server.getIoPerformanceCounter().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.server.getConnectionCounter(), (String)object2 + "name=Connections", this.server.getConnectionCounter().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.server.getHandlerThreadPool(), (String)object2 + "name=HandlerThreadPool", this.server.getHandlerThreadPool().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.server.getTransportThreadPool(), (String)object2 + "name=TransportThreadPool", this.server.getTransportThreadPool().getClass().getName());
                object = Registry.getRegistry(null, null).getMBeanServer();
                object.registerMBean(AdminServerNotifier.getInstance(), new ObjectName(this.getObjectName() + "name=ServerNotifications"));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminAgent.class).error("AdminAgent: " + exception.toString());
        }
        object2 = new AdminVHostListener(this);
        VHostSingleton.addVHostListener((IVHostNotify)object2);
        if (this.vhostList != null) {
            object = new AdminVHostItemListener(this);
            this.vhostList.addVHostItemListener((IVHostItemNotify)object);
        }
    }

    public void start(JMXRemoteConfig jMXRemoteConfig) {
        this.jmxRemoteConfig = jMXRemoteConfig;
        if (jMXRemoteConfig != null) {
            this.createRemoteConnection(jMXRemoteConfig);
        }
    }

    private void createRemoteConnection(JMXRemoteConfig jMXRemoteConfig) {
        boolean bl = jMXRemoteConfig.isEnabled();
        int n = jMXRemoteConfig.getRmiConnectionPort();
        int n2 = jMXRemoteConfig.getRmiRegistryPort();
        String string = jMXRemoteConfig.getIpAddress();
        String string2 = jMXRemoteConfig.getRmiServerHostName();
        String string3 = jMXRemoteConfig.getPasswordFile();
        String string4 = jMXRemoteConfig.getAccessFile();
        boolean bl2 = jMXRemoteConfig.isSSL();
        boolean bl3 = jMXRemoteConfig.isAuthenticate();
        if (!bl) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string5 = string;
        System.setProperty("java.rmi.server.randomIDs", "true");
        hashMap.put("java.rmi.server.randomIDs", "true");
        System.setProperty("com.sun.management.jmxremote", "true");
        hashMap.put("com.sun.management.jmxremote", "true");
        if (string2 != null && string2.length() > 0) {
            System.setProperty("java.rmi.server.hostname", string2);
            hashMap.put("java.rmi.server.hostname", string2);
            string5 = string2;
            WMSLoggerFactory.getLogger(AdminAgent.class).info("JMX java.rmi.server.hostname: " + string2);
        }
        String string6 = "service:jmx:rmi://" + string + ":" + n + "/jndi/rmi://" + string + ":" + n2 + "/jmxrmi";
        String string7 = "service:jmx:rmi://" + string5 + ":" + n + "/jndi/rmi://" + string5 + ":" + n2 + "/jmxrmi";
        WMSLoggerFactory.getLogger(AdminAgent.class).info("JMX bind attempt " + string7);
        try {
            this.jmxRegistry = LocateRegistry.createRegistry(n2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminAgent.class).error("JMXConfig: createRegistry: error: " + exception.toString());
        }
        try {
            Object object;
            Object object2;
            if (bl2) {
                WMSLoggerFactory.getLogger(AdminAgent.class).info("JMX using SSL");
                object2 = new SslRMIClientSocketFactory();
                object = new SslRMIServerSocketFactory();
                hashMap.put("jmx.remote.rmi.client.socket.factory", object2);
                hashMap.put("jmx.remote.rmi.server.socket.factory", object);
            }
            if (bl3) {
                try {
                    object2 = new File(string3);
                    if (!((File)object2).exists()) {
                        WMSLoggerFactory.getLogger(AdminAgent.class).warn("JMXConfig: authenticate: password file missing: " + string3);
                    } else {
                        WMSLoggerFactory.getLogger(AdminAgent.class).info("JMX password file: " + string3.replace("\\", "/"));
                        hashMap.put("jmx.remote.x.password.file", string3);
                    }
                    if (string4.length() > 0) {
                        object2 = new File(string4);
                        if (!((File)object2).exists()) {
                            WMSLoggerFactory.getLogger(AdminAgent.class).warn("JMXConfig: authenticate: access file missing: " + string4);
                        } else {
                            WMSLoggerFactory.getLogger(AdminAgent.class).info("JMX access file: " + string4.replace("\\", "/"));
                            hashMap.put("jmx.remote.x.access.file", string4);
                        }
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(AdminAgent.class).error("JMXConfig: error: " + exception.toString());
                }
            }
            object2 = Registry.getRegistry(null, null).getMBeanServer();
            object = new JMXServiceURL(string6);
            this.jmxServer = JMXConnectorServerFactory.newJMXConnectorServer((JMXServiceURL)object, hashMap, (MBeanServer)object2);
            if (this.jmxServer != null) {
                this.jmxServer.start();
            }
            WMSLoggerFactory.getLogger(AdminAgent.class).info("JMX bind successful");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminAgent.class).error("JMXConfig: error: " + exception.toString());
        }
    }

    private void shutdownRemoteConnection() {
        if (this.jmxServer != null) {
            WMSLoggerFactory.getLogger(Server.class).debug("Shutdown JMX");
            try {
                this.jmxServer.stop();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(AdminAgent.class).error("JMXConfig: error: " + exception.toString());
            }
            this.jmxServer = null;
        }
        if (this.jmxRegistry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.jmxRegistry, true);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(AdminAgent.class).error("JMXConfig: error: " + exception.toString());
            }
            this.jmxRegistry = null;
        }
    }

    public void shutdown() {
        try {
            if (this.server != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName() + "name=Server");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName() + "name=IOPerformance");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName() + "name=Connections");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName() + "name=HandlerThreadPool");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName() + "name=TransportThreadPool");
                MBeanServer mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
                mBeanServer.unregisterMBean(new ObjectName(this.getObjectName() + "name=ServerNotifications"));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminAgent.class).error("AdminAgent.shutdown: " + exception.toString());
        }
        try {
            this.shutdownRemoteConnection();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminAgent.class).error("AdminAgent.shutdown: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

