/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.admin.AdminApplicationInstanceListener;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationNotify;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.modeler.Registry;

public class AdminApplicationListener
implements IApplicationNotify {
    public static final String APPLICATION_OBJECTNAME = "applications=Applications,applicationName=";
    public static final String APPLICATION_FILTERNAME = "Application";
    private AdminAgent adminAgent = null;
    private IVHost vhost = null;
    private Map applicationInstanceListeners = new HashMap();
    private boolean isActive = true;

    public AdminApplicationListener(AdminAgent adminAgent, IVHost iVHost) {
        this.adminAgent = adminAgent;
        this.vhost = iVHost;
        this.isActive = Server.getInstance().getAdminInterfaceObjectList().contains(APPLICATION_FILTERNAME.toLowerCase());
    }

    private String getObjectName(IApplication iApplication) {
        return "WowzaMediaServerPro:vHosts=VHosts,vHostName=" + this.vhost.getName() + "," + APPLICATION_OBJECTNAME + iApplication.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationCreate(IApplication iApplication) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).registerComponent((Object)iApplication, this.getObjectName(iApplication) + ",name=Application", iApplication.getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplication.getProperties(), this.getObjectName(iApplication) + ",name=Properties", iApplication.getProperties().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplication.getConnectionCounter(), this.getObjectName(iApplication) + ",name=Connections", iApplication.getConnectionCounter().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iApplication.getIoPerformanceCounter(), this.getObjectName(iApplication) + ",name=IOPerformance", iApplication.getIoPerformanceCounter().getClass().getName());
            }
            AdminApplicationListener adminApplicationListener = this;
            synchronized (adminApplicationListener) {
                AdminApplicationInstanceListener adminApplicationInstanceListener = new AdminApplicationInstanceListener(this.adminAgent, this.vhost, iApplication);
                this.applicationInstanceListeners.put(iApplication, adminApplicationInstanceListener);
                iApplication.addApplicationInstanceListener(adminApplicationInstanceListener);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminApplicationListener.class).error("onApplicationCreate: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationDestroy(IApplication iApplication) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplication) + ",name=Application");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplication) + ",name=Properties");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplication) + ",name=Connections");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iApplication) + ",name=IOPerformance");
            }
            AdminApplicationInstanceListener adminApplicationInstanceListener = null;
            AdminApplicationListener adminApplicationListener = this;
            synchronized (adminApplicationListener) {
                adminApplicationInstanceListener = (AdminApplicationInstanceListener)this.applicationInstanceListeners.remove(iApplication);
            }
            if (adminApplicationInstanceListener != null) {
                iApplication.removeApplicationInstanceListener(adminApplicationInstanceListener);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminApplicationListener.class).error("onApplicationDestroy: " + exception.toString());
        }
    }
}

