/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.wms.logging.WMSLoggerFactory;
import java.nio.ByteBuffer;

public class AMFPacket {
    private int size = 0;
    private int type = 20;
    private int src = 0;
    private long timecode = 0L;
    private long absTimecode = 0L;
    private long seq;
    private byte[] dataA = null;
    private ByteBuffer dataB = null;
    private int dataLoc = 0;

    public AMFPacket() {
    }

    public AMFPacket(int n, int n2, int n3) {
        this.type = n;
        this.src = n2;
        this.size = n3;
        this.dataA = new byte[n3];
        this.dataLoc = 0;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getMissing() {
        if (this.dataA != null || this.dataB != null) {
            return this.size - this.dataLoc;
        }
        return this.size;
    }

    public void setDataBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            this.size = byteBuffer.limit();
        }
        this.dataB = byteBuffer;
    }

    public int addData(byte[] byArray, int n, int n2) {
        if (this.dataA != null) {
            int n3 = this.dataLoc;
            try {
                if (n2 > 0) {
                    System.arraycopy(byArray, n, this.dataA, this.dataLoc, n2);
                }
                this.dataLoc += n2;
            }
            catch (Exception exception) {
                String string = "";
                string = string + "this.size:" + this.size + " ";
                string = string + "this.dataA.length:" + this.dataA.length + " ";
                string = string + "this.startDataLoc:" + n3 + " ";
                string = string + "this.dataLoc:" + this.dataLoc + " ";
                string = string + "data.length:" + byArray.length + " ";
                string = string + "offset:" + n + " ";
                string = string + "size:" + n2 + " ";
                string = string + "missing:" + (this.size - this.dataLoc) + " ";
                WMSLoggerFactory.getLogger(AMFPacket.class).error("addDataA[" + string + "]: " + exception.toString());
                exception.printStackTrace();
            }
            return this.size - this.dataLoc;
        }
        if (this.dataB != null) {
            try {
                this.dataB.put(byArray, n, n2);
                this.dataLoc += n2;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(AMFPacket.class).error("addDataB: " + exception.toString());
                exception.printStackTrace();
            }
            return this.size - this.dataLoc;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getSrc() {
        return this.src;
    }

    public void setSrc(int n) {
        this.src = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{AMFPacket:");
        stringBuffer.append(" size: " + this.size + ", ");
        stringBuffer.append(" type: " + this.type + ", ");
        stringBuffer.append(" src: " + this.src + ", ");
        stringBuffer.append(" seq: " + this.seq + ", ");
        stringBuffer.append(" absTimecode: " + this.absTimecode + ", ");
        stringBuffer.append(" timecode: " + this.timecode + "}");
        return stringBuffer.toString();
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecodes(long l, long l2) {
        this.timecode = l;
        this.absTimecode = l2;
    }

    public void setTimecode(long l) {
        this.timecode = l;
    }

    public long getAbsTimecode() {
        return this.absTimecode;
    }

    public void setAbsTimecode(long l) {
        this.absTimecode = l;
    }

    public long getSeq() {
        return this.seq;
    }

    public void setSeq(long l) {
        this.seq = l;
    }

    public boolean isAudio() {
        return this.type == 8;
    }

    public boolean isVideo() {
        return this.type == 9;
    }

    public ByteBuffer getDataBuffer() {
        if (this.dataA != null) {
            return ByteBuffer.wrap(this.dataA);
        }
        if (this.dataB != null) {
            return this.dataB;
        }
        return null;
    }

    public byte[] getData() {
        if (this.dataA != null) {
            return this.dataA;
        }
        if (this.dataB != null) {
            byte[] byArray = null;
            try {
                byArray = this.dataB.array();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (byArray == null) {
                byArray = new byte[this.dataB.limit()];
                int n = this.dataB.position();
                this.dataB.position(0);
                this.dataB.get(byArray);
                this.dataB.position(n);
            }
            return byArray;
        }
        return null;
    }

    public int getFirstByte() {
        int n = 0;
        if (this.size > 0) {
            if (this.dataA != null) {
                return 0xFF & this.dataA[0];
            }
            if (this.dataB != null) {
                return 0xFF & this.dataB.get(0);
            }
        }
        return n;
    }

    public int getSecondByte() {
        int n = 0;
        if (this.size > 1) {
            if (this.dataA != null) {
                return 0xFF & this.dataA[1];
            }
            if (this.dataB != null) {
                return 0xFF & this.dataB.get(1);
            }
        }
        return n;
    }

    public static int calcTotalPacketSize(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n2 + (n4 > 255 ? 2 : (n4 >= 64 ? 1 : 0)) + (bl ? 4 : 0);
        int n6 = 1 + (n4 > 255 ? 2 : (n4 >= 64 ? 1 : 0)) + (bl ? 4 : 0);
        int n7 = n / n3 + (n % n3 > 0 ? 1 : 0) - 1;
        return n5 + n6 * n7 + n;
    }
}

