/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.application;

import com.wowza.util.AMFUtils;
import com.wowza.util.ElapsedTimer;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.SystemUtils;
import com.wowza.util.URLUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.application.Application;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.client.IClient;
import com.wowza.wms.client.IClientNotify;
import com.wowza.wms.client.IConnectionValidator;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterNotify;
import com.wowza.wms.mediacaster.IMediaCasterNotify2;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.module.IModuleNotify;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.module.ModuleItem;
import com.wowza.wms.module.ModuleList;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.sharedobject.ISharedObjectNotify;
import com.wowza.wms.sharedobject.ISharedObjects;
import com.wowza.wms.sharedobject.SharedObjects;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamFileMapper;
import com.wowza.wms.stream.IMediaStreamNotify;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamFileMapperBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostWatchdog;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationInstance
implements IApplicationInstance {
    public static final String DEFAULT_APPINSTANCE_NAME = "_definst_";
    private String name = "";
    private MediaStreamMap streams = null;
    private IApplication application = null;
    private String streamType = "default";
    protected WMSProperties properties = new WMSProperties();
    protected WMSProperties streamProperties = new WMSProperties();
    protected WMSProperties mediaCasterProperties = new WMSProperties();
    protected WMSProperties mediaReaderProperties = new WMSProperties();
    protected WMSProperties rtpProperties = new WMSProperties();
    private boolean acceptConnection = true;
    private String streamStorageDir = "";
    private String rsoStorageDir = "";
    private List clients = new ArrayList();
    private int clientsTotal = 0;
    private WMSReadWriteLock clientsLock = new WMSReentrantReadWriteLock();
    private ISharedObjects sharedObjects = new SharedObjects(false);
    private ISharedObjects sharedObjectsPersist = new SharedObjects(true);
    private List clientListeners = new ArrayList();
    private List moduleListeners = new ArrayList();
    private IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    private IOPerformanceCounter ioPerformanceCounterLast = null;
    private ConnectionCounter connectionCounter = new ConnectionCounter();
    private ConnectionValidator connectionValidator = new ConnectionValidator(this);
    private ElapsedTimer elapsedTime = new ElapsedTimer();
    private long clientRemoveTime = 0L;
    private Map playNameToStream = new HashMap();
    private Map streamToPlayName = new HashMap();
    private MediaCasterStreamMap mediaCasterStreams = null;
    private List mediaCasterListeners = new ArrayList();
    private ModuleFunctions modFunctions = new ModuleFunctions();
    private ModuleList moduleList = new ModuleList();
    private int applicationTimeout = 6000;
    private int pingTimeout = 12000;
    private int validationFrequency = 8000;
    private int maximumPendingWriteBytes = 0;
    private int maximumSetBufferTime = 0;
    private String repeaterOriginUrl = null;
    private String repeaterQueryString = null;
    private String[] allowDomains = null;
    private int clientIdleFrequency = -1;
    private String streamVideoSampleAccess = "";
    private String streamAudioSampleAccess = "";
    private String streamReadAccess = "*";
    private String streamWriteAccess = "*";
    private String sharedObjectReadAccess = "*";
    private String sharedObjectWriteAccess = "*";
    private String rtpAuthenticationMethod = "digest";
    private int rtpAVSyncMethod = 1;
    private int rtpMaxRTCPWaitTime = 10000;
    private Set<RTPSession> rtpSessions = new HashSet<RTPSession>();
    private int maxStorageDirDepth = 25;
    private IMediaStreamFileMapper streamFileMapper = new MediaStreamFileMapperBase();

    ApplicationInstance(String string, IApplication iApplication) {
        this.name = ApplicationInstance.fixName(string);
        this.application = iApplication;
        this.streams = new MediaStreamMap(this);
        this.mediaCasterStreams = new MediaCasterStreamMap(this);
        IVHost iVHost = iApplication.getVHost();
        if (iVHost != null) {
            this.applicationTimeout = iVHost.getApplicationTimeout();
            this.pingTimeout = iVHost.getPingTimeout();
            this.validationFrequency = iVHost.getValidationFrequency();
            this.maximumPendingWriteBytes = iVHost.getMaximumPendingWriteBytes();
            this.maximumSetBufferTime = iVHost.getMaximumSetBufferTime();
        }
        this.loadConfig();
        this.connectionCounter.setConnectionValidator(this.connectionValidator);
    }

    public void init() {
        this.sharedObjectsPersist.setStorageDir(this.getRsoStoragePath());
        this.sharedObjectsPersist.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initClient(IClient iClient) {
        iClient.setStreamType(this.streamType);
        iClient.setAcceptConnection(this.acceptConnection);
        iClient.setStreamVideoSampleAccess(this.streamVideoSampleAccess);
        iClient.setStreamAudioSampleAccess(this.streamAudioSampleAccess);
        iClient.setStreamReadAccess(this.streamReadAccess);
        iClient.setStreamWriteAccess(this.streamWriteAccess);
        iClient.setSharedObjectReadAccess(this.sharedObjectReadAccess);
        iClient.setSharedObjectWriteAccess(this.sharedObjectWriteAccess);
        if (this.getClientIdleFrequency() > 0) {
            iClient.setIdleFrequency(this.getClientIdleFrequency());
        }
        this.clientsLock.writeLock().lock();
        try {
            this.clients.add(iClient);
            ++this.clientsTotal;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.initClient: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
        this.notifyClientConnect(iClient);
    }

    private static void checkLicense(byte[] byArray) {
        byte[] byArray2 = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray3 = bigInteger.toByteArray();
        byte[] byArray4 = bigInteger2.toByteArray();
        for (int i = 0; i < ModuleConnect.lc.length; ++i) {
            int n = i;
            byArray2[n] = (byte)(byArray2[n] ^ byArray3[(i + 11) % byArray3.length]);
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray4[(i + 8) % byArray4.length]);
            if (byArray[i] == byArray2[i]) continue;
            WMSLoggerFactory.getLogger(null).error("bail1:" + byArray[i] + ":" + byArray2[i]);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownClient(IClient iClient) {
        ModuleFunctions moduleFunctions = this.getModFunctions();
        moduleFunctions.onDisconnect(iClient);
        this.notifyClientDisconnect(iClient);
        this.sharedObjects.removeClient(iClient);
        this.sharedObjectsPersist.removeClient(iClient);
        this.clientsLock.writeLock().lock();
        try {
            this.clients.remove(iClient);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.shutdownClient: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
        ((Client)iClient).addIOPerformance(this.ioPerformanceCounter);
        byte[] byArray = null;
        byArray = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 11) % byArray2.length]);
        }
        this.connectionCounter.disconnect(((Client)iClient).getConnectionHolder(), byArray);
        ApplicationInstance.checkLicense(byArray);
        this.clientRemoveTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectAllClients() {
        IVHost iVHost = this.application.getVHost();
        WMSReadWriteLock wMSReadWriteLock = iVHost.getApplicationLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            ArrayList arrayList = new ArrayList();
            this.clientsLock.readLock().lock();
            try {
                arrayList.addAll(this.clients);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.disconnectAllClients: " + exception.toString());
            }
            finally {
                this.clientsLock.readLock().unlock();
            }
            for (IClient iClient : arrayList) {
                if (iClient == null) continue;
                try {
                    int n = iClient.getClientId();
                    iVHost.killClient(n);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.disconnectAllClients[" + iClient.getClientId() + "]: " + exception.toString());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.disconnectAllClients: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void shutdown(boolean bl, boolean bl2) {
        this.mediaCasterStreams.shutdown(true);
        ModuleFunctions moduleFunctions = this.getModFunctions();
        moduleFunctions.onAppStop(this);
        this.notifyModuleUnloadAll();
    }

    public static String fixName(String string) {
        if (string.length() == 0) {
            return DEFAULT_APPINSTANCE_NAME;
        }
        return string;
    }

    private void loadConfig() {
        String string = this.application.getConfigPath();
        if (new File(string).exists()) {
            ApplicationUtils.loadConfigFile(this, URLUtils.pathToFileURL(string));
        } else if (Bootstrap.getConfigURL() != null) {
            ApplicationUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(Bootstrap.getConfigURL(), "context=vhost&vhostName=" + URLUtils.encodeValue(this.getVHost().getName()) + "&filename=" + URLUtils.encodeValue("conf/Application.xml") + "&applicationName=" + this.getApplication().getName()));
        } else {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("loadConfig: Application.xml file missing: " + string);
        }
    }

    public void notifyModuleLoadAll() {
        Map map = this.moduleList.getModuleItems();
        for (String string : map.keySet()) {
            ModuleItem moduleItem = this.moduleList.getModuleItem(string);
            this.notifyModuleLoad(moduleItem);
        }
    }

    public void notifyModuleUnloadAll() {
        Map map = this.moduleList.getModuleItems();
        for (String string : map.keySet()) {
            ModuleItem moduleItem = this.moduleList.getModuleItem(string);
            this.notifyModuleUnload(moduleItem);
        }
    }

    @Override
    public IApplication getApplication() {
        return this.application;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public MediaStreamMap getStreams() {
        return this.streams;
    }

    @Override
    public IVHost getVHost() {
        return this.application.getVHost();
    }

    @Override
    public String getStreamStoragePath() {
        String string = this.streamStorageDir;
        if (string.length() == 0) {
            string = this.application.getApplicationPath() + File.separatorChar + "streams";
            File file = null;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getStreamStoragePath: mkdir1: " + exception.toString());
            }
            string = string + File.separatorChar + this.name;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getStreamStoragePath: mkdir2: " + exception.toString());
            }
        }
        return string;
    }

    @Override
    public String getRsoStoragePath() {
        String string = this.rsoStorageDir;
        if (string.length() == 0) {
            string = this.application.getApplicationPath() + File.separatorChar + "sharedobjects";
            File file = null;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getRsoStoragePath: mkdir1: " + exception.toString());
            }
            string = string + File.separatorChar + this.name;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getRsoStoragePath: mkdir2: " + exception.toString());
            }
        }
        return string;
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getStreamType() {
        return this.streamType;
    }

    @Override
    public void setStreamType(String string) {
        this.streamType = string;
    }

    @Override
    public boolean isAcceptConnection() {
        return this.acceptConnection;
    }

    @Override
    public void setAcceptConnection(boolean bl) {
        this.acceptConnection = bl;
    }

    @Override
    public WMSReadWriteLock getClientsLockObj() {
        return this.clientsLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClientCount() {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            n = this.clients.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getClientCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClientCountTotal() {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            n = this.clientsTotal;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getClientCountTotal: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClient getClient(int n) {
        IClient iClient = null;
        this.clientsLock.readLock().lock();
        try {
            if (n < this.clients.size()) {
                iClient = (IClient)this.clients.get(n);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return iClient;
    }

    @Override
    public ISharedObjects getSharedObjects() {
        return this.getSharedObjects(false);
    }

    @Override
    public ISharedObjects getSharedObjects(boolean bl) {
        return bl ? this.sharedObjectsPersist : this.sharedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaCasterListener(IMediaCasterNotify iMediaCasterNotify) {
        List list = this.mediaCasterListeners;
        synchronized (list) {
            this.mediaCasterListeners.add(iMediaCasterNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaCasterListener(IMediaCasterNotify iMediaCasterNotify) {
        List list = this.mediaCasterListeners;
        synchronized (list) {
            this.mediaCasterListeners.remove(iMediaCasterNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterCreate(IMediaCaster iMediaCaster) {
        ArrayList arrayList = null;
        List list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onMediaCasterCreate(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterDestroy(IMediaCaster iMediaCaster) {
        ArrayList arrayList = null;
        List list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onMediaCasterDestroy(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
        ArrayList arrayList = null;
        List list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onRegisterPlayer(iMediaCaster, iMediaStreamPlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterUnRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
        ArrayList arrayList = null;
        List list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onUnRegisterPlayer(iMediaCaster, iMediaStreamPlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterSetSourceStream(IMediaCaster iMediaCaster, IMediaStream iMediaStream) {
        ArrayList arrayList = null;
        List list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onSetSourceStream(iMediaCaster, iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterConnectStart(IMediaCaster iMediaCaster) {
        ArrayList arrayList = null;
        List list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            if (!(iMediaCasterNotify instanceof IMediaCasterNotify2)) continue;
            ((IMediaCasterNotify2)iMediaCasterNotify).onConnectStart(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterConnectSuccess(IMediaCaster iMediaCaster) {
        ArrayList arrayList = null;
        List list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            if (!(iMediaCasterNotify instanceof IMediaCasterNotify2)) continue;
            ((IMediaCasterNotify2)iMediaCasterNotify).onConnectSuccess(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterConnectFailure(IMediaCaster iMediaCaster) {
        ArrayList arrayList = null;
        List list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            if (!(iMediaCasterNotify instanceof IMediaCasterNotify2)) continue;
            ((IMediaCasterNotify2)iMediaCasterNotify).onConnectFailure(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientListener(IClientNotify iClientNotify) {
        List list = this.clientListeners;
        synchronized (list) {
            this.clientListeners.add(iClientNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientListener(IClientNotify iClientNotify) {
        List list = this.clientListeners;
        synchronized (list) {
            this.clientListeners.remove(iClientNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModuleListener(IModuleNotify iModuleNotify) {
        List list = this.moduleListeners;
        synchronized (list) {
            this.moduleListeners.add(iModuleNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModuleListener(IModuleNotify iModuleNotify) {
        List list = this.moduleListeners;
        synchronized (list) {
            this.moduleListeners.remove(iModuleNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyModuleLoad(ModuleItem moduleItem) {
        ArrayList arrayList = null;
        List list = this.moduleListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.moduleListeners);
        }
        for (IModuleNotify iModuleNotify : arrayList) {
            iModuleNotify.onModuleLoad(moduleItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyModuleUnload(ModuleItem moduleItem) {
        ArrayList arrayList = null;
        List list = this.moduleListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.moduleListeners);
        }
        for (IModuleNotify iModuleNotify : arrayList) {
            iModuleNotify.onModuleUnload(moduleItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientConnect(IClient iClient) {
        ArrayList arrayList = null;
        List list = this.clientListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.clientListeners);
        }
        for (IClientNotify iClientNotify : arrayList) {
            iClientNotify.onClientConnect(iClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientDisconnect(IClient iClient) {
        ArrayList arrayList = null;
        List list = this.clientListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.clientListeners);
        }
        for (IClientNotify iClientNotify : arrayList) {
            iClientNotify.onClientDisconnect(iClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientAccept(IClient iClient) {
        ArrayList arrayList = null;
        List list = this.clientListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.clientListeners);
        }
        for (IClientNotify iClientNotify : arrayList) {
            iClientNotify.onClientAccept(iClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientReject(IClient iClient) {
        ArrayList arrayList = null;
        List list = this.clientListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.clientListeners);
        }
        for (IClientNotify iClientNotify : arrayList) {
            iClientNotify.onClientReject(iClient);
        }
    }

    @Override
    public void addMediaStreamListener(IMediaStreamNotify iMediaStreamNotify) {
        this.streams.addMediaStreamListener(iMediaStreamNotify);
    }

    @Override
    public void removeMediaStreamListener(IMediaStreamNotify iMediaStreamNotify) {
        this.streams.removeMediaStreamListener(iMediaStreamNotify);
    }

    @Override
    public void addSharedObjectListener(ISharedObjectNotify iSharedObjectNotify, boolean bl) {
        (bl ? this.sharedObjectsPersist : this.sharedObjects).addSharedObjectListener(iSharedObjectNotify);
    }

    @Override
    public void removeSharedObjectListener(ISharedObjectNotify iSharedObjectNotify, boolean bl) {
        (bl ? this.sharedObjectsPersist : this.sharedObjects).removeSharedObjectListener(iSharedObjectNotify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOPerformanceCounter updateIOPerformance() {
        ArrayList arrayList = null;
        this.clientsLock.readLock().lock();
        try {
            arrayList = new ArrayList(this.clients);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.updateIOPerformance: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        if (arrayList != null) {
            for (Client client : arrayList) {
                client.addIOPerformance(this.ioPerformanceCounter);
            }
        }
        return this.ioPerformanceCounter;
    }

    public IOPerformanceCounter addIOPerformance(IOPerformanceCounter iOPerformanceCounter) {
        boolean bl = false;
        if (bl) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance: updateIOPerformance: addIOPerformance: start: " + this.ioPerformanceCounter.getMessagesInBytes() + ":" + this.ioPerformanceCounter.getMessagesOutBytes());
        }
        this.updateIOPerformance();
        IOPerformanceCounter iOPerformanceCounter2 = this.ioPerformanceCounter.clone();
        iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.ioPerformanceCounterLast);
        this.ioPerformanceCounterLast = iOPerformanceCounter2;
        if (bl) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: doWatchdog: updateApplicationIOPerformance: updateIOPerformance: addIOPerformance: stop: " + this.ioPerformanceCounter.getMessagesInBytes() + ":" + this.ioPerformanceCounter.getMessagesOutBytes());
        }
        return this.ioPerformanceCounter;
    }

    @Override
    public IOPerformanceCounter getIOPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    public long getMessagesInCount() {
        return this.ioPerformanceCounter.getMessagesInCount();
    }

    public long getMessagesInCountRate() {
        return this.ioPerformanceCounter.getMessagesInCountRate();
    }

    public long getMessagesOutCount() {
        return this.ioPerformanceCounter.getMessagesOutCount();
    }

    public long getMessagesOutCountRate() {
        return this.ioPerformanceCounter.getMessagesOutCountRate();
    }

    public long getMessagesInBytes() {
        return this.ioPerformanceCounter.getMessagesInBytes();
    }

    public double getMessagesInBytesRate() {
        return this.ioPerformanceCounter.getMessagesInBytesRate();
    }

    public long getMessagesOutBytes() {
        return this.ioPerformanceCounter.getMessagesOutBytes();
    }

    public double getMessagesOutBytesRate() {
        return this.ioPerformanceCounter.getMessagesOutBytesRate();
    }

    @Override
    public ConnectionCounter getConnectionCounter() {
        return this.connectionCounter;
    }

    public IConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    @Override
    public String getDateStarted() {
        return this.elapsedTime.getDateString();
    }

    @Override
    public String getTimeRunning() {
        return this.elapsedTime.getTimeString();
    }

    @Override
    public double getTimeRunningSeconds() {
        return this.elapsedTime.getTimeSeconds();
    }

    public void updateLoggingDuration() {
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
    }

    public long getClientRemoveTime() {
        return this.clientRemoveTime;
    }

    public void setClientRemoveTime(long l) {
        this.clientRemoveTime = l;
    }

    @Override
    public void broadcastMsg(List<IClient> list, String string) {
        this.broadcastMsg(list, string, null);
    }

    @Override
    public void broadcastMsg(List<IClient> list, String string, Object ... objectArray) {
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        for (Client client : list) {
            if (client == null) continue;
            client.callInternal(string, null, aMFDataArray);
        }
    }

    public void broadcastMsg(String string) {
        this.broadcastMsg(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcastMsg(String string, Object ... objectArray) {
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        ArrayList arrayList = null;
        this.clientsLock.readLock().lock();
        try {
            arrayList = new ArrayList(this.clients);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.broadcastMsg: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        for (Client client : arrayList) {
            client.callInternal(string, null, aMFDataArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlayStreamByName(IMediaStream iMediaStream, String string) {
        Map map = this.playNameToStream;
        synchronized (map) {
            this.removePlayStreamByName(iMediaStream);
            this.streamToPlayName.put(iMediaStream, string);
            ArrayList<IMediaStream> arrayList = (ArrayList<IMediaStream>)this.playNameToStream.get(string);
            if (arrayList != null) {
                arrayList.add(iMediaStream);
            } else {
                arrayList = new ArrayList<IMediaStream>();
                arrayList.add(iMediaStream);
                this.playNameToStream.put(string, arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlayStreamByName(IMediaStream iMediaStream) {
        Map map = this.playNameToStream;
        synchronized (map) {
            String string = (String)this.streamToPlayName.get(iMediaStream);
            if (string != null) {
                this.streamToPlayName.remove(iMediaStream);
                List list = (List)this.playNameToStream.get(string);
                if (list != null) {
                    list.remove(iMediaStream);
                    if (list.size() == 0) {
                        this.playNameToStream.remove(string);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPlayStreamsByName(String string) {
        Map map = this.playNameToStream;
        synchronized (map) {
            List list = (List)this.playNameToStream.get(string);
            if (list == null) {
                return null;
            }
            return new ArrayList(list);
        }
    }

    @Override
    public MediaCasterStreamMap getMediaCasterStreams() {
        return this.mediaCasterStreams;
    }

    public void doWatchdog() {
        this.mediaCasterStreams.doWatchdog();
    }

    @Override
    public int getStreamCount() {
        return this.streams.getCount();
    }

    @Override
    public ModuleFunctions getModFunctions() {
        return this.modFunctions;
    }

    @Override
    public ModuleList getModuleList() {
        return this.moduleList;
    }

    @Override
    public Object getModuleInstance(String string) {
        Object object = null;
        ModuleItem moduleItem = this.moduleList.getModuleItem(string);
        if (moduleItem != null) {
            object = moduleItem.getInstance();
        }
        return object;
    }

    public int getPublishStreamIdByName(String string) {
        IMediaStream iMediaStream = this.streams.getStream(string);
        return iMediaStream == null ? -1 : iMediaStream.getSrc();
    }

    @Override
    public int getApplicationTimeout() {
        return this.applicationTimeout;
    }

    @Override
    public void setApplicationTimeout(int n) {
        this.applicationTimeout = n;
    }

    @Override
    public int getPingTimeout() {
        return this.pingTimeout;
    }

    @Override
    public void setPingTimeout(int n) {
        this.pingTimeout = n;
    }

    @Override
    public int getValidationFrequency() {
        return this.validationFrequency;
    }

    @Override
    public void setValidationFrequency(int n) {
        this.validationFrequency = n;
    }

    @Override
    public int getMaximumPendingWriteBytes() {
        return this.maximumPendingWriteBytes;
    }

    @Override
    public void setMaximumPendingWriteBytes(int n) {
        this.maximumPendingWriteBytes = n;
    }

    @Override
    public int getMaximumSetBufferTime() {
        return this.maximumSetBufferTime;
    }

    @Override
    public void setMaximumSetBufferTime(int n) {
        this.maximumSetBufferTime = n;
    }

    @Override
    public String getRepeaterOriginUrl() {
        return this.repeaterOriginUrl;
    }

    @Override
    public void setRepeaterOriginUrl(String string) {
        this.repeaterOriginUrl = string;
    }

    @Override
    public String getRepeaterQueryString() {
        return this.repeaterQueryString;
    }

    @Override
    public void setRepeaterQueryString(String string) {
        this.repeaterQueryString = string;
    }

    @Override
    public String[] getAllowDomains() {
        return this.allowDomains;
    }

    @Override
    public void setAllowDomains(String[] stringArray) {
        this.allowDomains = stringArray;
    }

    @Override
    public void parseAllowDomains(String string) {
        if (string == null) {
            this.allowDomains = null;
            return;
        }
        this.allowDomains = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split("[,]");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        if (arrayList.size() > 0) {
            this.allowDomains = arrayList.toArray(new String[0]);
        }
    }

    @Override
    public int getClientIdleFrequency() {
        return this.clientIdleFrequency;
    }

    @Override
    public void setClientIdleFrequency(int n) {
        this.clientIdleFrequency = n;
    }

    @Override
    public String decodeStorageDir(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.getVHost() != null) {
            hashMap.put("com.wowza.wms.context.VHost", this.getVHost().getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", this.getVHost().getHomePath());
        }
        hashMap.put("com.wowza.wms.context.Application", this.getApplication().getName());
        if (this != null) {
            hashMap.put("com.wowza.wms.context.ApplicationInstance", this.getName());
        }
        String string2 = SystemUtils.expandEnvironmentVariables(string, hashMap);
        WMSLoggerFactory.getLogger(null).debug("explodeStorageDir: " + string + "=" + string2);
        return string2;
    }

    private void validateStoragePath(String string) {
        String string2;
        if (this.maxStorageDirDepth <= 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        File file = new File(string.replace("\\", "/"));
        WMSLoggerFactory.getLogger(null).debug("validateStoragePath: start: " + file);
        int n = 0;
        while (!file.exists()) {
            string2 = file.getParent();
            WMSLoggerFactory.getLogger(null).debug("  parent: " + string2);
            if (string2 == null) break;
            String string3 = file.toString().substring(string2.length(), file.toString().length());
            WMSLoggerFactory.getLogger(null).debug("  add: " + (String)string3);
            arrayList.add(0, string3);
            file = new File(string2);
            if (++n < this.maxStorageDirDepth) continue;
            WMSLoggerFactory.getLogger(null).warn("ApplicationInstance.validateStoragePath: maxStorageDirDepth has been exceeded[" + this.maxStorageDirDepth + "]: " + string);
            break;
        }
        if (n >= this.maxStorageDirDepth) {
            return;
        }
        string2 = file.getAbsolutePath();
        for (String string4 : arrayList) {
            string2 = string2 + string4;
            File file2 = new File(string2);
            try {
                WMSLoggerFactory.getLogger(null).debug("  mkdir: " + file2);
                file2.mkdir();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).error("Application.validateStoragePath: Invalid path (" + string2 + "): " + exception.toString());
                break;
            }
        }
    }

    @Override
    public String getStreamStorageDir() {
        return this.streamStorageDir;
    }

    @Override
    public void setStreamStorageDir(String string) {
        this.streamStorageDir = this.decodeStorageDir(string);
        this.validateStoragePath(this.streamStorageDir);
    }

    @Override
    public String getRsoStorageDir() {
        return this.rsoStorageDir;
    }

    @Override
    public void setRsoStorageDir(String string) {
        this.rsoStorageDir = this.decodeStorageDir(string);
        this.validateStoragePath(this.rsoStorageDir);
    }

    @Override
    public String getStreamVideoSampleAccess() {
        return this.streamVideoSampleAccess;
    }

    @Override
    public void setStreamVideoSampleAccess(String string) {
        this.streamVideoSampleAccess = string;
    }

    @Override
    public String getStreamAudioSampleAccess() {
        return this.streamAudioSampleAccess;
    }

    @Override
    public void setStreamAudioSampleAccess(String string) {
        this.streamAudioSampleAccess = string;
    }

    @Override
    public String getStreamReadAccess() {
        return this.streamReadAccess;
    }

    @Override
    public void setStreamReadAccess(String string) {
        this.streamReadAccess = string;
    }

    @Override
    public String getStreamWriteAccess() {
        return this.streamWriteAccess;
    }

    @Override
    public void setStreamWriteAccess(String string) {
        this.streamWriteAccess = string;
    }

    @Override
    public String getSharedObjectReadAccess() {
        return this.sharedObjectReadAccess;
    }

    @Override
    public void setSharedObjectReadAccess(String string) {
        this.sharedObjectReadAccess = string;
    }

    @Override
    public String getSharedObjectWriteAccess() {
        return this.sharedObjectWriteAccess;
    }

    @Override
    public void setSharedObjectWriteAccess(String string) {
        this.sharedObjectWriteAccess = string;
    }

    @Override
    public String getRTPAuthenticationMethod() {
        return this.rtpAuthenticationMethod;
    }

    @Override
    public void setRTPAuthenticationMethod(String string) {
        this.rtpAuthenticationMethod = string;
    }

    @Override
    public int getRTPMaxRTCPWaitTime() {
        return this.rtpMaxRTCPWaitTime;
    }

    @Override
    public void setRTPMaxRTCPWaitTime(int n) {
        this.rtpMaxRTCPWaitTime = n;
    }

    @Override
    public int getRTPAVSyncMethod() {
        return this.rtpAVSyncMethod;
    }

    @Override
    public void setRTPAVSyncMethod(int n) {
        this.rtpAVSyncMethod = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RTPSession> getRTPSessions() {
        HashSet<RTPSession> hashSet = new HashSet<RTPSession>();
        this.clientsLock.readLock().lock();
        try {
            hashSet.addAll(this.rtpSessions);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getRTPSessions: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRTPSessionCount() {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            n = this.rtpSessions.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getRTPSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRTPSession(RTPSession rTPSession) {
        this.clientsLock.writeLock().lock();
        try {
            this.rtpSessions.add(rTPSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.addRTPSession: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRTPSession(RTPSession rTPSession) {
        this.clientsLock.writeLock().lock();
        try {
            this.rtpSessions.remove(rTPSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.removeRTPSession: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    @Override
    public WMSProperties getStreamProperties() {
        return this.streamProperties;
    }

    @Override
    public WMSProperties getMediaCasterProperties() {
        return this.mediaCasterProperties;
    }

    @Override
    public WMSProperties getMediaReaderProperties() {
        return this.mediaReaderProperties;
    }

    @Override
    public WMSProperties getRTPProperties() {
        return this.rtpProperties;
    }

    @Override
    public int getMaxStorageDirDepth() {
        return this.maxStorageDirDepth;
    }

    @Override
    public void setMaxStorageDirDepth(int n) {
        this.maxStorageDirDepth = n;
    }

    @Override
    public IMediaStreamFileMapper getStreamFileMapper() {
        return this.streamFileMapper;
    }

    @Override
    public void setStreamFileMapper(IMediaStreamFileMapper iMediaStreamFileMapper) {
        this.streamFileMapper = iMediaStreamFileMapper;
    }

    class ConnectionValidator
    implements IConnectionValidator {
        private ApplicationInstance applicationInstance = null;

        public ConnectionValidator(ApplicationInstance applicationInstance2) {
            this.applicationInstance = applicationInstance2;
        }

        public boolean validateConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, byte[] byArray) {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 3) % byArray2.length]);
            }
            return ((Application)this.applicationInstance.application).getConnectionValidator().validateConnection(connectionCounter, connectionHolder, byArray);
        }
    }
}

