/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.authentication;

import com.wowza.util.HTTPUtils;
import com.wowza.util.MD5DigestUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.authentication.AuthenticationItem;
import com.wowza.wms.authentication.IAuthenticate;
import com.wowza.wms.authentication.IAuthenticateRTSP;
import com.wowza.wms.authentication.file.AuthenticationPasswordFile;
import com.wowza.wms.authentication.file.AuthenticationPasswordFiles;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.util.HashMap;

public class AuthenticateDigest
implements IAuthenticate,
IAuthenticateRTSP {
    private static final String NOUNCEKEY = "WowzaMediaServerPro";
    private AuthenticationItem authenticationItem = null;
    private boolean isAuthenticated = false;
    private String realm = null;
    private File passwordFile = null;
    private String savedNonce = null;

    public void init(IApplicationInstance iApplicationInstance, AuthenticationItem authenticationItem) {
        this.authenticationItem = authenticationItem;
        this.realm = this.authenticationItem.getProperties().getPropertyStr("realm", this.realm);
        String string = this.authenticationItem.getProperties().getPropertyStr("passwordFile", null);
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            IVHost iVHost = iApplicationInstance.getVHost();
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
            hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
            hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
            string = SystemUtils.expandEnvironmentVariables(string, hashMap);
            this.passwordFile = new File(string);
        }
    }

    private String getAuthString(String string) {
        String string2 = "Digest";
        String string3 = "";
        if (this.realm != null) {
            if (string3.length() > 0) {
                string3 = string3 + ", ";
            }
            string3 = string3 + " realm=\"" + this.realm + "\"";
        }
        if (string3.length() > 0) {
            string3 = string3 + ", ";
        }
        this.savedNonce = MD5DigestUtils.generateHash(string + ":" + System.currentTimeMillis() + ":" + NOUNCEKEY);
        string3 = string3 + " nonce=\"" + this.savedNonce + "\"";
        string2 = string2 + string3;
        return string2;
    }

    private String removeQuotes(String string) {
        return this.removeQuotes(string, false);
    }

    private String removeQuotes(String string, boolean bl) {
        if (string.length() > 0 && string.charAt(0) != '\"' && !bl) {
            return string;
        }
        if (string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        return new String();
    }

    public boolean authenticateRTSP(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        Object object;
        String[] stringArray;
        if (this.isAuthenticated) {
            return true;
        }
        boolean bl = false;
        String string = rTSPRequestMessage.getHeader("authorization");
        if (string != null) {
            AuthenticationPasswordFile authenticationPasswordFile;
            String string2;
            if ((string = string.trim()).toLowerCase().startsWith("digest ")) {
                string = string.substring(7);
            }
            string = string.trim();
            stringArray = HTTPUtils.splitPragmas(string);
            object = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = rTSPRequestMessage.getHeader("method");
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                if (string2.length() == 0) continue;
                int n = string2.indexOf(61);
                if (n < 0) break;
                String string11 = string2.substring(0, n).trim();
                String string12 = string2.substring(n + 1).trim();
                if ("username".equals(string11)) {
                    object = this.removeQuotes(string12);
                }
                if ("realm".equals(string11)) {
                    string3 = this.removeQuotes(string12, true);
                }
                if ("nonce".equals(string11)) {
                    string4 = this.removeQuotes(string12);
                }
                if ("nc".equals(string11)) {
                    string5 = this.removeQuotes(string12);
                }
                if ("cnonce".equals(string11)) {
                    string6 = this.removeQuotes(string12);
                }
                if ("qop".equals(string11)) {
                    string7 = this.removeQuotes(string12);
                }
                if ("uri".equals(string11)) {
                    string8 = this.removeQuotes(string12);
                }
                if (!"response".equals(string11)) continue;
                string9 = this.removeQuotes(string12);
            }
            if ((authenticationPasswordFile = AuthenticationPasswordFiles.getInstance().getPasswordFile(this.passwordFile)) != null) {
                if (string10 != null && string8 != null && object != null && (string2 = authenticationPasswordFile.getPassword((String)object)) != null) {
                    String string13;
                    String string14 = string3 = string3 != null ? string3 : this.realm;
                    if (string3 != null && string4 != null && this.savedNonce != null && string4.equals(this.savedNonce) && (string13 = MD5DigestUtils.generateAuth(string10, string8, (String)object, string2, string3, string4, string7, string5, string6)) != null && string13.equals(string9)) {
                        bl = true;
                        this.isAuthenticated = true;
                    }
                }
            } else {
                WMSLoggerFactory.getLogger(AuthenticationPasswordFile.class).warn("AuthenticateDigest.authenticateRTSP: Password file not found: " + this.passwordFile);
            }
        }
        if (!bl) {
            stringArray = new RTPRequestStatus();
            RTSPStatics.setStatus((RTPRequestStatus)stringArray, 401);
            object = new RTSPResponseMessage();
            ((RTSPResponseMessage)object).setResponseCode(stringArray.getResponseCode());
            ((RTSPResponseMessage)object).setResponseMessage(stringArray.getResponseMessage());
            ((RTSPResponseMessage)object).setHeader("WWW-Authenticate", this.getAuthString(rTSPRequestMessage.getWMSSessionInfo().getIpAddress()));
            ((RTSPResponseMessage)object).setCSeq(rTSPRequestMessage.getCSeq());
            ((RTSPResponseMessage)object).setSession(rTPSession.getSessionId());
            rTSPResponseMessages.addMessage((RTSPResponseMessage)object);
        }
        return bl;
    }
}

