/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.authentication.file;

import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;

public class AuthenticationPasswordFile {
    private long lastModDate = -1L;
    private long lastSize = -1L;
    private File file = null;
    private Map<String, String> passwordVals = new HashMap<String, String>();

    public AuthenticationPasswordFile(File file) {
        this.file = file;
        this.load();
    }

    private void load() {
        WMSLoggerFactory.getLogger(AuthenticationPasswordFile.class).debug("AuthenticationPasswordFile.load: " + this.file.getAbsolutePath());
        this.passwordVals.clear();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("#") || string.length() == 0) continue;
                String string2 = null;
                String string3 = null;
                int n = string.indexOf(" ");
                if (n < 0) {
                    n = string.indexOf("\t");
                }
                if (n >= 0) {
                    string2 = string.substring(0, n).trim();
                    string3 = string.substring(n + 1).trim();
                } else {
                    string2 = string.trim();
                }
                this.passwordVals.put(string2, string3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AuthenticationPasswordFile.class).error("AuthenticationPasswordFile.load: " + exception.toString());
        }
        this.lastModDate = this.file.lastModified();
        this.lastSize = this.file.length();
    }

    private void checkReload() {
        if (this.lastModDate != this.file.lastModified() || this.lastSize != this.file.length()) {
            this.load();
        }
    }

    public synchronized boolean userExists(String string) {
        this.checkReload();
        return this.passwordVals.containsKey(string);
    }

    public synchronized String getPassword(String string) {
        this.checkReload();
        return this.passwordVals.get(string);
    }
}

