/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.client;

import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RequestData;
import com.wowza.wms.request.RequestProcessData;
import com.wowza.wms.request.RequestProcessFunctions;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.response.ResponseFunctions;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;

public class ClientWorker
implements Runnable {
    IVHost vhost = null;
    Client client = null;
    boolean isRunning = false;
    Thread thread = null;

    public ClientWorker(IVHost iVHost, Client client) {
        this.vhost = iVHost;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this;
        synchronized (object) {
            if (!this.isRunning) {
                WMSLoggerFactory.getLogger(Client.class).debug("ClientWorker: nothingtodo: " + this.client.getClientId());
                return;
            }
            this.thread = Thread.currentThread();
        }
        try {
            while (true) {
                object = null;
                ClientWorker clientWorker = this;
                synchronized (clientWorker) {
                    object = this.client.getNextRequestData();
                    if (object == null) {
                        break;
                    }
                }
                this.client.setThreadContext();
                ClientWorker.processNextReq(this.vhost, this.client, ((RequestData)object).getData(), ((RequestData)object).getHeaderLength(), ((RequestData)object).getContentLength());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ClientWorker.class).error("ClientWorker: run: " + this.client.getClientId() + " :" + exception.toString());
        }
        finally {
            ClientWorker clientWorker = this;
            synchronized (clientWorker) {
                this.isRunning = false;
                this.thread = null;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    public static void processNextReq(IVHost iVHost, Client client, ByteBuffer byteBuffer, int n, int n2) {
        ArrayList arrayList = new ArrayList();
        RequestProcessData.processNextRequest(iVHost, client, byteBuffer, n, n2, arrayList);
        ClientWorker.packetCompleteLiveStreams(client);
        if (!client.isLeftOverData()) {
            ClientWorker.trimLiveStreams(client);
        }
        RequestProcessFunctions.processFunctions(iVHost, client, arrayList);
        client.checkPingTimeout();
        long l = client.getTotalInBytes();
        if (l >= client.getNextConfirmBytesReceived()) {
            client.incrementNextConfirmBytesReceived();
            long l2 = l;
            byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 4, 3, 0, 0, 0, 0, (byte)(0x7FL & l2 >> 24), (byte)(0xFFL & l2 >> 16), (byte)(0xFFL & l2 >> 8), (byte)(0xFFL & l2)};
            ResponseFunction responseFunction = new ResponseFunction(client);
            responseFunction.addBytes(byArray);
            ResponseFunctions responseFunctions = client.getRespFunctions();
            responseFunctions.add(responseFunction);
        }
        if (client.getRespFunctions().isPending()) {
            client.doIdle();
        }
    }

    private static void trimLiveStreams(IClient iClient) {
        List list = iClient.getPublishStreams();
        if (list.size() > 0) {
            for (IMediaStream iMediaStream : list) {
                iMediaStream.trim();
            }
        }
    }

    private static void packetCompleteLiveStreams(Client client) {
        if (client.isLeftOverData()) {
            return;
        }
        List list = client.getPublishStreams();
        if (list.size() > 0) {
            for (IMediaStream iMediaStream : list) {
                iMediaStream.packetComplete();
            }
        }
    }

    public synchronized Thread getThread() {
        return this.thread;
    }
}

