/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.aac;

import com.wowza.wms.media.aac.AACFrame;

public class AACUtils {
    public static final int AAC_HEADER_SIZE = 7;
    public static final int[] AAC_SAMPLERATES = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
    public static final int[] AAC_CHANNELS = new int[]{0, 1, 2, 3, 4, 5, 6, 8};

    public static int decodeFirstChunkAACP(byte[] byArray, int n, long l) {
        int n2 = n;
        int n3 = 0;
        while ((long)n3 < l - 7L) {
            AACFrame aACFrame;
            AACFrame aACFrame2 = AACUtils.decodeFrame(byArray, n3 + n);
            if (aACFrame2 != null && (long)(n3 + n + aACFrame2.getSize() + 7) < l && (aACFrame = AACUtils.decodeFrame(byArray, n3 + n + aACFrame2.getSize())) != null) {
                n2 = n3 + n;
                break;
            }
            ++n3;
        }
        return n2;
    }

    public static boolean compareFrameParams(byte[] byArray, long l, int n, int n2) {
        boolean bl;
        block1: {
            bl = false;
            int n3 = (int)l;
            if ((byArray[n3 + 0] & 0xFF) != 255 || (byArray[n3 + 1] & 0xF0) != 240) break block1;
            int n4 = byArray[n3 + 2] & 0x3C;
            int n5 = byArray[n3 + 2] & 1;
            n5 <<= 2;
            if (n == (n4 >>= 2) && n2 == (n5 += (byte)(byArray[n3 + 3] >> 6) & 3)) {
                bl = true;
            }
        }
        return bl;
    }

    public static AACFrame decodeFrame(byte[] byArray, long l) {
        AACFrame aACFrame;
        block3: {
            aACFrame = null;
            int n = (int)l;
            if ((byArray[n + 0] & 0xFF) != 255 || (byArray[n + 1] & 0xF0) != 240) break block3;
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            bl = (byArray[n + 1] & 1) == 1;
            int n4 = byArray[n + 2] & 0x3C;
            if ((n4 >>= 2) >= 0 && n4 < AAC_SAMPLERATES.length) {
                n2 = AAC_SAMPLERATES[n4];
                int n5 = byArray[n + 2] & 1;
                n5 <<= 2;
                if ((n5 += (byte)(byArray[n + 3] >> 6) & 3) >= 0 && n5 < AAC_CHANNELS.length) {
                    n3 = AAC_CHANNELS[n5];
                    int n6 = byArray[n + 3] & 3;
                    n6 <<= 8;
                    n6 += byArray[n + 4] & 0xFF;
                    n6 <<= 3;
                    if ((n6 += byArray[n + 5] >> 5 & 7) > 0) {
                        int n7 = byArray[n + 6] & 3;
                        aACFrame = new AACFrame();
                        aACFrame.setChannelIndex(n5);
                        aACFrame.setChannels(n3);
                        aACFrame.setRdb(n7);
                        aACFrame.setRateIndex(n4);
                        aACFrame.setSampleRate(n2);
                        aACFrame.setSize(n6);
                        aACFrame.setErrorBitsAbsent(bl);
                    }
                }
            }
        }
        return aACFrame;
    }

    public static AACFrame decodeAACCodecConfig(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xF) << 1;
        int n3 = (byArray[n + 1] & 0x7F) >> 3;
        int n4 = 0;
        int n5 = 0;
        if ((n2 += (byArray[n + 1] & 0x80) >> 7 & 1) >= 0 && n2 < AAC_SAMPLERATES.length) {
            n4 = AAC_SAMPLERATES[n2];
        }
        if (n3 >= 0 && n3 < AAC_CHANNELS.length) {
            n5 = AAC_CHANNELS[n3];
        }
        AACFrame aACFrame = null;
        aACFrame = new AACFrame();
        aACFrame.setChannelIndex(n3);
        aACFrame.setChannels(n5);
        aACFrame.setRateIndex(n2);
        aACFrame.setSampleRate(n4);
        return aACFrame;
    }
}

