/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.h264;

import com.wowza.util.BitReader;
import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;

public class H264Utils {
    public static final int[][] pixel_aspect = new int[][]{{0, 1}, {1, 1}, {12, 11}, {10, 11}, {16, 11}, {40, 33}, {24, 11}, {20, 11}, {32, 11}, {80, 33}, {18, 11}, {15, 11}, {64, 33}, {160, 99}, {4, 3}, {3, 2}, {2, 1}};
    public static final byte[][] default_scaling4 = new byte[][]{{6, 13, 20, 28, 13, 20, 28, 32, 20, 28, 32, 37, 28, 32, 37, 42}, {10, 14, 20, 24, 14, 20, 24, 27, 20, 24, 27, 30, 24, 27, 30, 34}};
    public static final byte[][] default_scaling8 = new byte[][]{{6, 10, 13, 16, 18, 23, 25, 27, 10, 11, 16, 18, 23, 25, 27, 29, 13, 16, 18, 23, 25, 27, 29, 31, 16, 18, 23, 25, 27, 29, 31, 33, 18, 23, 25, 27, 29, 31, 33, 36, 23, 25, 27, 29, 31, 33, 36, 38, 25, 27, 29, 31, 33, 36, 38, 40, 27, 29, 31, 33, 36, 38, 40, 42}, {9, 13, 15, 17, 19, 21, 22, 24, 13, 13, 17, 19, 21, 22, 24, 25, 15, 17, 19, 21, 22, 24, 25, 27, 17, 19, 21, 22, 24, 25, 27, 28, 19, 21, 22, 24, 25, 27, 28, 30, 21, 22, 24, 25, 27, 28, 30, 32, 22, 24, 25, 27, 28, 30, 32, 33, 24, 25, 27, 28, 30, 32, 33, 35}};
    public static final byte[] zigzag_scan = new byte[]{0, 1, 4, 8, 5, 2, 3, 6, 9, 12, 13, 10, 7, 11, 14, 15};
    public static final byte[] zigzag_scan8x8 = new byte[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public static H264CodecConfigInfo decodeAVCC(byte[] byArray) {
        H264CodecConfigInfo h264CodecConfigInfo = new H264CodecConfigInfo();
        try {
            int n = 6;
            int n2 = BufferUtils.byteArrayToInt(byArray, n, 2);
            BitReader bitReader = new BitReader(byArray);
            bitReader.skip((n += 2) * 8);
            bitReader.skip(8);
            h264CodecConfigInfo.profileIDC = bitReader.getInt(8);
            bitReader.skip(4);
            bitReader.skip(4);
            h264CodecConfigInfo.levelIDC = bitReader.getInt(8);
            h264CodecConfigInfo.spsID = bitReader.readExpGolomb();
            if (h264CodecConfigInfo.profileIDC >= 100) {
                h264CodecConfigInfo.chromaFormatIDC = bitReader.readExpGolomb();
                h264CodecConfigInfo.residualColorTransformFlag = 0;
                if (h264CodecConfigInfo.chromaFormatIDC == 3) {
                    h264CodecConfigInfo.residualColorTransformFlag = bitReader.getInt(1);
                }
                h264CodecConfigInfo.bitDepthLumaMinus8 = bitReader.readExpGolomb();
                h264CodecConfigInfo.bitDepthChromaMinus8 = bitReader.readExpGolomb();
                h264CodecConfigInfo.transformBypass = bitReader.getInt(1);
                h264CodecConfigInfo.scalingMatrixFlag = bitReader.getInt(1);
                if (h264CodecConfigInfo.scalingMatrixFlag == 1) {
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[0]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[0]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[0]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[1]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[1]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[1]);
                }
            }
            h264CodecConfigInfo.log2MaxFrameNum = bitReader.readExpGolomb() + 4;
            h264CodecConfigInfo.pocType = bitReader.readExpGolomb();
            h264CodecConfigInfo.log2MaxPocLSB = 0;
            if (h264CodecConfigInfo.pocType == 0) {
                h264CodecConfigInfo.log2MaxPocLSB = bitReader.readExpGolomb() + 4;
            } else if (h264CodecConfigInfo.pocType == 1) {
                h264CodecConfigInfo.deltaPicOrderAlwaysZeroFlag = bitReader.getInt(1);
                h264CodecConfigInfo.offsetForNonRefPic = bitReader.readExpGolombSigned();
                h264CodecConfigInfo.offsetForTopToBottomField = bitReader.readExpGolombSigned();
                h264CodecConfigInfo.pocCycleLength = bitReader.readExpGolomb();
                h264CodecConfigInfo.offsetForRefFrame = new int[h264CodecConfigInfo.pocCycleLength];
                for (int i = 0; i < h264CodecConfigInfo.pocCycleLength; ++i) {
                    h264CodecConfigInfo.offsetForRefFrame[i] = bitReader.readExpGolombSigned();
                }
            } else if (h264CodecConfigInfo.pocType != 2) {
                // empty if block
            }
            h264CodecConfigInfo.refFrameCount = bitReader.readExpGolomb();
            h264CodecConfigInfo.gapsInFrameNumAllowedFlag = bitReader.getInt(1);
            h264CodecConfigInfo.mbWidth = bitReader.readExpGolomb() + 1;
            h264CodecConfigInfo.mbHeight = bitReader.readExpGolomb() + 1;
            h264CodecConfigInfo.frameMBSOnlyFlag = bitReader.getInt(1);
            h264CodecConfigInfo.mbAFF = 0;
            if (h264CodecConfigInfo.frameMBSOnlyFlag == 0) {
                h264CodecConfigInfo.mbAFF = bitReader.getInt(1);
            }
            h264CodecConfigInfo.adjWidth = h264CodecConfigInfo.mbWidth;
            h264CodecConfigInfo.adjHeight = h264CodecConfigInfo.mbHeight * (2 - h264CodecConfigInfo.frameMBSOnlyFlag);
            h264CodecConfigInfo.direct8x8InferenceFlag = bitReader.getInt(1);
            h264CodecConfigInfo.crop = bitReader.getInt(1);
            h264CodecConfigInfo.cropLeft = 0;
            h264CodecConfigInfo.cropRight = 0;
            h264CodecConfigInfo.cropTop = 0;
            h264CodecConfigInfo.cropBottom = 0;
            if (h264CodecConfigInfo.crop != 0) {
                h264CodecConfigInfo.cropLeft = bitReader.readExpGolomb();
                h264CodecConfigInfo.cropRight = bitReader.readExpGolomb();
                h264CodecConfigInfo.cropTop = bitReader.readExpGolomb();
                h264CodecConfigInfo.cropBottom = bitReader.readExpGolomb();
            }
            h264CodecConfigInfo.vuiParametersPresentFlag = bitReader.getInt(1);
            if (h264CodecConfigInfo.vuiParametersPresentFlag != 0) {
                h264CodecConfigInfo.sarNum = 0;
                h264CodecConfigInfo.sarDen = 0;
                h264CodecConfigInfo.aspectRatioIDC = 0;
                h264CodecConfigInfo.aspectRatioInfoPresentFlag = bitReader.getInt(1);
                if (h264CodecConfigInfo.aspectRatioInfoPresentFlag != 0) {
                    h264CodecConfigInfo.aspectRatioIDC = bitReader.getInt(8);
                    if (h264CodecConfigInfo.aspectRatioIDC == 255) {
                        h264CodecConfigInfo.sarNum = bitReader.getInt(16);
                        h264CodecConfigInfo.sarDen = bitReader.getInt(16);
                    } else if (h264CodecConfigInfo.aspectRatioIDC < pixel_aspect.length) {
                        h264CodecConfigInfo.sarNum = pixel_aspect[h264CodecConfigInfo.aspectRatioIDC][0];
                        h264CodecConfigInfo.sarDen = pixel_aspect[h264CodecConfigInfo.aspectRatioIDC][1];
                    }
                }
            }
            h264CodecConfigInfo.height = 0;
            h264CodecConfigInfo.width = 16 * h264CodecConfigInfo.mbWidth - 2 * (h264CodecConfigInfo.cropLeft + h264CodecConfigInfo.cropRight);
            h264CodecConfigInfo.height = h264CodecConfigInfo.frameMBSOnlyFlag != 0 ? 16 * h264CodecConfigInfo.adjHeight - 2 * (h264CodecConfigInfo.cropTop + h264CodecConfigInfo.cropBottom) : 16 * h264CodecConfigInfo.adjHeight - 4 * (h264CodecConfigInfo.cropTop + h264CodecConfigInfo.cropBottom);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(H264Utils.class).error("H264CodecConfigInfo.decodeAVCC: " + exception.toString());
            exception.printStackTrace();
        }
        return h264CodecConfigInfo;
    }

    static void decode_scaling_list(BitReader bitReader, int n, byte[] byArray) {
        byte[] byArray2 = n == 16 ? zigzag_scan : zigzag_scan8x8;
        int n2 = bitReader.getInt(1);
        if (n2 == 1) {
            int n3 = 8;
            int n4 = 8;
            for (int i = 0; i < n; ++i) {
                if (n3 != 0) {
                    int n5 = bitReader.readExpGolombSigned();
                    n3 = n4 + n5 & 0xFF;
                }
                if (i == 0 && n3 == 0) break;
                byte by = (byte)(n3 != 0 ? n3 : n4);
                byArray[byArray2[i]] = by;
                n4 = by;
            }
        }
    }
}

