/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.IVHost;

public abstract class MediaCaster
implements IMediaCaster {
    protected IApplicationInstance appInstance = null;
    protected String mediaCasterId = "unknown";
    protected IMediaStream stream = null;
    protected String streamExt = "flv";
    protected MediaCasterItem mediaCasterDef = null;
    protected MediaCasterStreamItem mediaCasterStreamItem = null;
    protected WMSProperties properties = new WMSProperties();

    public void init(MediaCasterStreamItem mediaCasterStreamItem, MediaCasterItem mediaCasterItem, IApplicationInstance iApplicationInstance, String string, String string2) {
        this.mediaCasterStreamItem = mediaCasterStreamItem;
        this.mediaCasterDef = mediaCasterItem;
        this.mediaCasterId = string;
        this.appInstance = iApplicationInstance;
        this.streamExt = string2;
        WMSProperties.cloneProperties(mediaCasterItem.getProperties(), this.properties);
        WMSProperties.cloneProperties(iApplicationInstance.getMediaCasterProperties(), this.properties);
    }

    public IVHost getVHost() {
        return this.appInstance != null ? this.appInstance.getVHost() : null;
    }

    public String getMediaCasterId() {
        return this.mediaCasterId;
    }

    public void setMediaCasterId(String string) {
        this.mediaCasterId = string;
    }

    public IMediaStream getStream() {
        return this.stream;
    }

    public void setStream(IMediaStream iMediaStream) {
        this.stream = iMediaStream;
        ((ApplicationInstance)this.appInstance).notifyMediaCasterSetSourceStream(this, iMediaStream);
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    public void setAppInstance(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
    }

    public MediaCasterItem getMediaCasterDef() {
        return this.mediaCasterDef;
    }

    public void setMediaCasterDef(MediaCasterItem mediaCasterItem) {
        this.mediaCasterDef = mediaCasterItem;
    }

    public int getIdleTimeout() {
        return this.mediaCasterDef.getConnectionTimeout();
    }

    public MediaCasterStreamItem getMediaCasterStreamItem() {
        return this.mediaCasterStreamItem;
    }

    public void forceReset() {
        WMSLoggerFactory.getLogger(MediaCaster.class).warn("MediaCaster.forceReset: not implemented for this MediaCaster type");
    }

    public boolean doWatchdog() {
        return false;
    }

    public WMSProperties getProperties() {
        return this.properties;
    }

    public String getStreamExt() {
        return this.streamExt;
    }

    public void setStreamExt(String string) {
        this.streamExt = string;
    }
}

