/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterSessionHandler;
import com.wowza.wms.vhost.VHost;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;

public class MediaCasterConnection {
    private VHost vhost = null;
    private SocketConnector connector = null;
    private SocketConnectorConfig cfg = null;

    public MediaCasterConnection(VHost vHost) {
        this.vhost = vHost;
    }

    private SocketConnector getConnector() {
        if (this.connector == null) {
            this.connector = new SocketConnector(this.vhost.getMediaCasterSettings().getMediaCasterProcessorCount(), this.vhost.getThreadPool().getExecutor());
            this.cfg = new SocketConnectorConfig();
            this.vhost.getMediaCasterSettings().getMediaCasterHostPortConfig().configureSocketConnector(this.cfg);
        }
        return this.connector;
    }

    public IoSession connect(MediaCasterSessionHandler mediaCasterSessionHandler, String string, int n, int n2) {
        SocketConnector socketConnector = this.getConnector();
        IoSession ioSession = null;
        try {
            ConnectFuture connectFuture = socketConnector.connect((SocketAddress)new InetSocketAddress(string, n), (IoHandler)mediaCasterSessionHandler, (IoServiceConfig)this.cfg);
            connectFuture.join();
            ioSession = connectFuture.getSession();
        }
        catch (RuntimeIOException runtimeIOException) {
            WMSLoggerFactory.getLogger(MediaCasterConnection.class).error("Failed to connect: " + runtimeIOException.toString());
            ioSession = null;
        }
        return ioSession;
    }
}

