/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.MediaCasterFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.stream.IMediaStreamPlay;
import java.util.ArrayList;
import java.util.List;

public class MediaCasterStreamItem {
    private String mediaCasterId = "";
    private String streamExt = "flv";
    private MediaCasterItem mediaCasterDef = null;
    private MediaCasterStreamMap parent = null;
    private IMediaCaster mediaCaster = null;
    private boolean shutdownOnRelease = false;
    private List players = new ArrayList();
    private int lockCount = 0;
    private long removeTime = 0L;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaCaster getMediaCaster() {
        IMediaCaster iMediaCaster = null;
        Object object = this.lock;
        synchronized (object) {
            iMediaCaster = this.mediaCaster;
        }
        return iMediaCaster;
    }

    public void init(String string, String string2, MediaCasterItem mediaCasterItem, MediaCasterStreamMap mediaCasterStreamMap) {
        this.mediaCasterId = string;
        this.streamExt = string2;
        this.mediaCasterDef = mediaCasterItem;
        this.parent = mediaCasterStreamMap;
    }

    public String getMediaCasterId() {
        return this.mediaCasterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMediaCaster(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mediaCaster == null && bl) {
                this.mediaCaster = MediaCasterFactory.createMediaCaster(this, this.mediaCasterDef, this.parent.getApplicationInstance(), this.mediaCasterId, this.streamExt);
                ((ApplicationInstance)this.parent.getApplicationInstance()).notifyMediaCasterCreate(this.mediaCaster);
            }
        }
        return this.mediaCaster != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlayer(IMediaStreamPlay iMediaStreamPlay) {
        if (!this.checkMediaCaster(true)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.players.contains(iMediaStreamPlay)) {
                this.players.add(iMediaStreamPlay);
            }
        }
        this.mediaCaster.registerPlayer(iMediaStreamPlay);
        ((ApplicationInstance)this.parent.getApplicationInstance()).notifyMediaCasterRegisterPlayer(this.mediaCaster, iMediaStreamPlay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPlayer(IMediaStreamPlay iMediaStreamPlay) {
        if (!this.checkMediaCaster(false)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.players.contains(iMediaStreamPlay)) {
                this.players.remove(iMediaStreamPlay);
            }
            this.removeTime = System.currentTimeMillis();
        }
        this.mediaCaster.unregisterPlayer(iMediaStreamPlay);
        ((ApplicationInstance)this.parent.getApplicationInstance()).notifyMediaCasterUnRegisterPlayer(this.mediaCaster, iMediaStreamPlay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWatchdog() {
        if (!this.checkMediaCaster(false)) {
            return false;
        }
        boolean bl = false;
        long l = System.currentTimeMillis();
        int n = this.mediaCasterDef.getKeepAliveTime();
        Object object = this.lock;
        synchronized (object) {
            if (this.lockCount == 0 && this.players.size() == 0 && n > 0 && this.removeTime > 0L && l - this.removeTime > (long)n) {
                this.shutdown(false);
                bl = true;
            }
            if (!bl) {
                bl = this.mediaCaster.doWatchdog();
            }
        }
        return bl;
    }

    public void reset() {
        if (!this.checkMediaCaster(false)) {
            return;
        }
        this.mediaCaster.forceReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        if (!this.checkMediaCaster(false)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.players.clear();
        }
        this.mediaCaster.shutdown(bl);
        ((ApplicationInstance)this.parent.getApplicationInstance()).notifyMediaCasterDestroy(this.mediaCaster);
        this.mediaCaster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerCount() {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            n = this.players.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLockCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.lockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        Object object = this.lock;
        synchronized (object) {
            ++this.lockCount;
        }
        if (!this.checkMediaCaster(true)) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            --this.lockCount;
            this.removeTime = System.currentTimeMillis();
            if (this.lockCount == 0 && this.isShutdownOnRelease()) {
                this.shutdown(false);
            }
        }
    }

    public String getStreamExt() {
        return this.streamExt;
    }

    public void setStreamExt(String string) {
        this.streamExt = string;
    }

    public boolean isShutdownOnRelease() {
        return this.shutdownOnRelease;
    }

    public void setShutdownOnRelease(boolean bl) {
        this.shutdownOnRelease = bl;
    }
}

