/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamManager;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaCasterStreamMap {
    private IApplicationInstance appInstance = null;
    private Map mediaCasters = new HashMap();
    private Map<Long, String> streamToMediaCaster = new HashMap<Long, String>();
    private WMSReadWriteLock lock = null;
    private MediaCasterStreamManager streamManager = new MediaCasterStreamManager(this);

    public MediaCasterStreamMap(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.lock = iApplicationInstance.getClientsLockObj();
    }

    public WMSReadWriteLock getLock() {
        return this.lock;
    }

    public MediaCasterStreamManager getStreamManager() {
        return this.streamManager;
    }

    public IApplicationInstance getApplicationInstance() {
        return this.appInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMediaCasterCount() {
        int n = 0;
        this.lock.readLock().lock();
        try {
            n = this.mediaCasters.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.getMediaCasterCount: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWatchdog() {
        ArrayList arrayList = null;
        this.lock.readLock().lock();
        try {
            arrayList = new ArrayList(this.mediaCasters.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.doWatchdog: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList<MediaCasterStreamItem> arrayList2 = new ArrayList<MediaCasterStreamItem>();
        if (arrayList != null) {
            for (MediaCasterStreamItem mediaCasterStreamItem : arrayList) {
                if (!mediaCasterStreamItem.doWatchdog()) continue;
                arrayList2.add(mediaCasterStreamItem);
            }
        }
        if (arrayList2.size() > 0) {
            this.lock.writeLock().lock();
            try {
                for (MediaCasterStreamItem mediaCasterStreamItem : arrayList2) {
                    this.mediaCasters.remove(mediaCasterStreamItem.getMediaCasterId());
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.doWatchdog: " + exception.toString());
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        ArrayList arrayList = null;
        this.lock.writeLock().lock();
        try {
            arrayList = new ArrayList(this.mediaCasters.values());
            this.mediaCasters.clear();
            this.streamToMediaCaster.clear();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (arrayList != null) {
            for (MediaCasterStreamItem mediaCasterStreamItem : arrayList) {
                mediaCasterStreamItem.shutdown(bl);
            }
        }
    }

    private String getMediaCasterId(IMediaStreamPlay iMediaStreamPlay, MediaCasterItem mediaCasterItem) {
        return mediaCasterItem.getIdString(iMediaStreamPlay.getParent().getName());
    }

    private String getMediaCasterId(String string, MediaCasterItem mediaCasterItem) {
        return mediaCasterItem.getIdString(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMediaCasterNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.lock.readLock().lock();
        try {
            arrayList.addAll(this.mediaCasters.keySet());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.getMediaCasterNames: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaCasterStreamItem getMediaCasterStreamItem(String string, String string2, MediaCasterItem mediaCasterItem) {
        MediaCasterStreamItem mediaCasterStreamItem = null;
        this.lock.writeLock().lock();
        try {
            mediaCasterStreamItem = (MediaCasterStreamItem)this.mediaCasters.get(string);
            if (mediaCasterStreamItem == null) {
                mediaCasterStreamItem = new MediaCasterStreamItem();
                mediaCasterStreamItem.init(string, string2, mediaCasterItem, this);
                this.mediaCasters.put(string, mediaCasterStreamItem);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.getMediaCasterStreamItem: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return mediaCasterStreamItem;
    }

    public MediaCasterStreamItem acquire(String string) {
        return this.acquire(string, (String)null);
    }

    public MediaCasterStreamItem getMediaCaster(String string) {
        MediaCasterStreamItem mediaCasterStreamItem = null;
        mediaCasterStreamItem = (MediaCasterStreamItem)this.mediaCasters.get(string);
        return mediaCasterStreamItem;
    }

    public MediaCasterStreamItem acquire(String string, MediaCasterItem mediaCasterItem) {
        String string2;
        MediaCasterStreamItem mediaCasterStreamItem;
        MediaCasterStreamItem mediaCasterStreamItem2 = null;
        String string3 = string;
        String string4 = "flv";
        String string5 = "";
        String[] stringArray = ModuleUtils.decodeStreamExtension(string3, string4);
        string3 = stringArray[0];
        string4 = stringArray[1];
        boolean bl = string3.indexOf("://") >= 0;
        int n = string3.indexOf("?");
        if (!bl && n >= 0) {
            string5 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        if ((mediaCasterStreamItem = this.getMediaCasterStreamItem(string2 = this.getMediaCasterId(string3, mediaCasterItem), string4, mediaCasterItem)) != null) {
            mediaCasterStreamItem.acquire();
        }
        mediaCasterStreamItem2 = mediaCasterStreamItem;
        return mediaCasterStreamItem2;
    }

    public MediaCasterStreamItem acquire(String string, String string2) {
        StreamList streamList;
        StreamItem streamItem;
        MediaCasterStreamItem mediaCasterStreamItem = null;
        String string3 = string;
        String string4 = "flv";
        String string5 = "";
        String[] stringArray = ModuleUtils.decodeStreamExtension(string3, string4);
        string3 = stringArray[0];
        string4 = stringArray[1];
        boolean bl = string3.indexOf("://") >= 0;
        int n = string3.indexOf("?");
        if (!bl && n >= 0) {
            string5 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        IVHost iVHost = this.appInstance.getVHost();
        if (string2 == null) {
            string2 = this.appInstance.getStreamType();
        }
        if ((streamItem = (streamList = iVHost.getStreamTypes()).getStreamDef(string2)) == null) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.acquire: Can't find StreamType definition: " + string2);
        } else {
            String string6 = null;
            WMSProperties wMSProperties = streamItem.getProperties();
            if (wMSProperties != null) {
                string6 = wMSProperties.getPropertyStr("mediaCasterType", string6);
            }
            if (string6 == null) {
                WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.acquire: Can't find MediaCaster definition for stream type: " + string2);
            } else {
                MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
                MediaCasterItem mediaCasterItem = mediaCasterList.getMediaCasterDef(string6);
                if (mediaCasterItem == null) {
                    WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.acquire: Can't find MediaCaster definition: " + string6);
                } else {
                    String string7 = this.getMediaCasterId(string3, mediaCasterItem);
                    MediaCasterStreamItem mediaCasterStreamItem2 = this.getMediaCasterStreamItem(string7, string4, mediaCasterItem);
                    if (mediaCasterStreamItem2 != null) {
                        mediaCasterStreamItem2.acquire();
                    }
                    mediaCasterStreamItem = mediaCasterStreamItem2;
                }
            }
        }
        return mediaCasterStreamItem;
    }

    public void release(MediaCasterStreamItem mediaCasterStreamItem) {
        mediaCasterStreamItem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(MediaCasterStreamItem mediaCasterStreamItem, boolean bl) {
        this.lock.writeLock().lock();
        try {
            mediaCasterStreamItem.release();
            if (bl && mediaCasterStreamItem.getLockCount() == 0) {
                this.mediaCasters.remove(mediaCasterStreamItem.getMediaCasterId());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.doWatchdog: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MediaCasterStreamItem mediaCasterStreamItem) {
        this.lock.writeLock().lock();
        try {
            this.mediaCasters.remove(mediaCasterStreamItem.getMediaCasterId());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.doWatchdog: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String streamSrcToMediaCaster(long l) {
        if (l <= 0L) {
            return null;
        }
        String string = null;
        this.lock.readLock().lock();
        try {
            string = this.streamToMediaCaster.get(new Long(l));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.streamSrcToMediaCaster: " + exception.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamSrcToMediaCaster(long l, String string) {
        if (l <= 0L) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.streamToMediaCaster.put(new Long(l), string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.addStreamSrcToMediaCaster: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStreamSrcToMediaCaster(long l) {
        if (l <= 0L) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.streamToMediaCaster.remove(new Long(l));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamMap.clearStreamSrcToMediaCaster: " + exception.toString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private long playerToStreamSrc(IMediaStreamPlay iMediaStreamPlay) {
        IMediaStream iMediaStream;
        long l = -1L;
        if (iMediaStreamPlay != null && (iMediaStream = iMediaStreamPlay.getParent()) != null) {
            l = iMediaStream.getSrc();
            IClient iClient = iMediaStream.getClient();
            if (iClient != null) {
                long l2 = iClient.getClientId();
                l += l2 << 32;
            }
        }
        if (WMSLoggerFactory.getLogger(null).isDebugEnabled()) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).debug("MediaCasterStreamMap.playerToStreamSrc: " + Long.toHexString(l));
        }
        return l;
    }

    private boolean mediaCasterEquals(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public void registerPlayer(IMediaStreamPlay iMediaStreamPlay, MediaCasterItem mediaCasterItem) {
        block2: {
            long l = this.playerToStreamSrc(iMediaStreamPlay);
            String string = this.streamSrcToMediaCaster(l);
            String string2 = this.getMediaCasterId(iMediaStreamPlay, mediaCasterItem);
            String string3 = iMediaStreamPlay.getParent().getExt();
            if (this.mediaCasterEquals(string, string2)) break block2;
            MediaCasterStreamItem mediaCasterStreamItem = null;
            if (string != null && (mediaCasterStreamItem = this.getMediaCasterStreamItem(string, string3, mediaCasterItem)) != null) {
                mediaCasterStreamItem.unregisterPlayer(iMediaStreamPlay);
            }
            if ((mediaCasterStreamItem = this.getMediaCasterStreamItem(string2, string3, mediaCasterItem)) != null) {
                mediaCasterStreamItem.registerPlayer(iMediaStreamPlay);
            }
            this.addStreamSrcToMediaCaster(l, string2);
        }
    }

    public void unregisterPlayer(IMediaStreamPlay iMediaStreamPlay, MediaCasterItem mediaCasterItem) {
        String string;
        long l = this.playerToStreamSrc(iMediaStreamPlay);
        String string2 = this.getMediaCasterId(iMediaStreamPlay, mediaCasterItem);
        MediaCasterStreamItem mediaCasterStreamItem = this.getMediaCasterStreamItem(string2, string = iMediaStreamPlay.getParent().getExt(), mediaCasterItem);
        if (mediaCasterStreamItem != null) {
            mediaCasterStreamItem.unregisterPlayer(iMediaStreamPlay);
        }
        this.clearStreamSrcToMediaCaster(l);
    }
}

