/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster.rtp;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCaster;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.rtp.IRTPSessionDescriptionDataProvider;
import com.wowza.wms.mediacaster.rtp.IRTPSessionDescriptionSessionHandler;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import java.util.List;
import org.apache.mina.common.IoSession;

public class RTPMediaCaster
extends MediaCaster {
    private boolean isReconnectorRunning = false;
    private Object lock = new Object();
    private String streamName = null;
    private boolean tryConnect = false;
    private RTPSession rtpSession = null;
    private IRTPSessionDescriptionDataProvider rtpSessionDescriptionDataProvider = null;
    private IRTPSessionDescriptionSessionHandler rtpSessionDescriptionSessionHandler = new RTPSessionDescriptionSessionHandler();
    private String rtpSessionDescriptionDataProviderClass = "com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasic";
    private int streamTimeout = 0;
    private long streamMissingTime = -1L;
    private long streamLastSeq = -1L;

    public RTPMediaCaster() {
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.create");
    }

    public void init(MediaCasterStreamItem mediaCasterStreamItem, MediaCasterItem mediaCasterItem, IApplicationInstance iApplicationInstance, String string, String string2) {
        super.init(mediaCasterStreamItem, mediaCasterItem, iApplicationInstance, string, string2);
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.init");
        this.streamTimeout = this.getProperties().getPropertyInt("streamTimeout", this.streamTimeout);
        this.rtpSessionDescriptionDataProviderClass = this.getProperties().getPropertyStr("rtpSessionDescriptionDataProviderClass", this.rtpSessionDescriptionDataProviderClass);
        this.instantiateRTPSessionDescriptionDataProvider();
        this.streamName = string;
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantiateRTPSessionDescriptionDataProvider() {
        block5: {
            try {
                Class<?> clazz = Class.forName(this.rtpSessionDescriptionDataProviderClass);
                if (clazz == null) break block5;
                Object object = this.lock;
                synchronized (object) {
                    this.rtpSessionDescriptionDataProvider = (IRTPSessionDescriptionDataProvider)clazz.newInstance();
                    this.rtpSessionDescriptionDataProvider.init(this);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.instantiateRTPSessionDescriptionDataProvider (" + this.rtpSessionDescriptionDataProviderClass + "): " + exception.toString());
            }
        }
    }

    public String getStreamInfo(String string, int n) {
        if (this.rtpSessionDescriptionDataProvider != null) {
            return this.rtpSessionDescriptionDataProvider.getSessionDescriptionData(this.getAppInstance(), string, n, this.rtpSessionDescriptionSessionHandler);
        }
        return null;
    }

    public void onSessionStart(RTPSession rTPSession) {
        if (this.rtpSessionDescriptionDataProvider != null) {
            this.rtpSessionDescriptionDataProvider.sessionStart(rTPSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRTPSession(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (this.rtpSession != null) {
                this.closeRTPSession();
            }
            IApplicationInstance iApplicationInstance = this.getAppInstance();
            IVHost iVHost = iApplicationInstance.getVHost();
            RTPContext rTPContext = iVHost.getRTPContext();
            RTPSessions rTPSessions = rTPContext.getSessions();
            String string2 = rTPSessions.getNextSessionId();
            RTPSession rTPSession = new RTPSession(string2);
            rTPSessions.addSession(rTPSession);
            rTPSessions.notifySessionCreate(rTPSession);
            String string3 = iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName() + "/" + this.streamName;
            RTPStream rTPStream = RTPUtils.decodeStreamInfo(rTPContext, string3, string);
            rTPStream.setPublish(true);
            rTPSession.addRTSPStream(rTPStream);
            rTPSession.setAppInstance(iApplicationInstance);
            rTPStream.setAppName(iApplicationInstance.getApplication().getName());
            rTPStream.setAppInstanceName(iApplicationInstance.getName());
            String string4 = this.streamName;
            String string5 = this.mediaCasterStreamItem.getStreamExt();
            String[] stringArray = ModuleUtils.decodeStreamExtension(string4, string5);
            string4 = stringArray[0];
            string5 = stringArray[1];
            rTPStream.setStreamName(string4);
            rTPStream.setStreamExt(string5);
            rTPStream.setStreamType(this.mediaCasterDef.getStreamType());
            rTPStream.setCheckSSRC(false);
            rTPStream.setCheckIpAddr(true);
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            rTPStream.announce(rTPRequestStatus);
            if (!rTPStream.streamExists()) {
                rTPStream.createStream(rTPRequestStatus);
            }
            if (rTPStream.streamExists()) {
                this.setStream(rTPStream.getStream());
                List<String> list = rTPStream.getTrackNames();
                for (String string6 : list) {
                    RTPTrack rTPTrack = rTPStream.getTrack(string6);
                    if (rTPTrack == null) continue;
                    rTPTrack.setup(rTPRequestStatus, null);
                }
                rTPStream.record(rTPRequestStatus);
                rTPStream.getMetadataPacket();
                this.rtpSession = rTPSession;
                this.onSessionStart(rTPSession);
            }
            if (this.rtpSession == null) {
                rTPSessions.removeSession(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRTPSession() {
        Object object = this.lock;
        synchronized (object) {
            if (this.rtpSessionDescriptionDataProvider != null) {
                this.rtpSessionDescriptionDataProvider.sessionStop(this.rtpSession);
            }
            if (this.rtpSession != null) {
                IApplicationInstance iApplicationInstance = this.getAppInstance();
                IVHost iVHost = iApplicationInstance.getVHost();
                RTPContext rTPContext = iVHost.getRTPContext();
                RTPSessions rTPSessions = rTPContext.getSessions();
                RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
                rTPSessions.notifySessionDestroy(this.rtpSession);
                this.rtpSession.shutdown(rTPRequestStatus);
                rTPSessions.removeSession(this.rtpSession);
                this.setStream(null);
            }
            this.rtpSession = null;
            this.streamMissingTime = -1L;
            this.streamLastSeq = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.tryConnect = true;
            bl = true;
            this.tryToConnect();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToConnect() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isReconnectorRunning) {
                this.isReconnectorRunning = true;
                this.getAppInstance().getVHost().getThreadPool().execute(new Reconnector(this));
            }
        }
    }

    public void registerPlayer(IMediaStreamPlay iMediaStreamPlay) {
    }

    public void unregisterPlayer(IMediaStreamPlay iMediaStreamPlay) {
    }

    public void sessionOpened(IoSession ioSession) {
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.sessionOpened: NEVER GET HERE");
    }

    public void sessionClosed(IoSession ioSession) {
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.sessionClosed: NEVER GET HERE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.disconnect");
            this.tryConnect = false;
            this.closeRTPSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceReset() {
        Object object = this.lock;
        synchronized (object) {
            WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.resetConnection: ");
            this.closeRTPSession();
            this.tryToConnect();
        }
    }

    public void shutdown(boolean bl) {
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.shutdown: " + this.streamName);
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWatchdog() {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.rtpSessionDescriptionDataProvider != null) {
                bl = this.rtpSessionDescriptionDataProvider.doIdle(this);
            }
        }
        boolean bl2 = false;
        if (!bl && this.streamTimeout > 0) {
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.isReconnectorRunning) {
                } else if (this.rtpSession == null) {
                } else {
                    IMediaStream iMediaStream = this.getStream();
                    if (iMediaStream == null) {
                    } else {
                        List list = iMediaStream.getPlayPackets();
                        boolean bl3 = false;
                        if (list.size() == 0) {
                            bl3 = true;
                        } else {
                            AMFPacket aMFPacket = (AMFPacket)list.get(list.size() - 1);
                            long l = aMFPacket.getSeq();
                            if (l != this.streamLastSeq) {
                                this.streamLastSeq = l;
                            } else {
                                bl3 = true;
                            }
                        }
                        if (bl3) {
                            long l = System.currentTimeMillis();
                            if (this.streamMissingTime == -1L) {
                                this.streamMissingTime = l;
                            } else if (l - this.streamMissingTime > (long)this.streamTimeout) {
                                bl2 = true;
                            }
                        } else {
                            this.streamMissingTime = -1L;
                        }
                        if (bl2) {
                            this.forceReset();
                        }
                    }
                }
            }
        }
        return false;
    }

    class RTPSessionDescriptionSessionHandler
    implements IRTPSessionDescriptionSessionHandler {
        RTPSessionDescriptionSessionHandler() {
        }

        public void onDisconnect() {
            if (RTPMediaCaster.this.tryConnect) {
                RTPMediaCaster.this.forceReset();
            }
        }
    }

    class Reconnector
    implements Runnable {
        private RTPMediaCaster rtpMediaCaster = null;

        public Reconnector(RTPMediaCaster rTPMediaCaster2) {
            this.rtpMediaCaster = rTPMediaCaster2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.Reconnector: start");
            try {
                int n = 0;
                while (true) {
                    Object object = RTPMediaCaster.this.lock;
                    synchronized (object) {
                        if (this.rtpMediaCaster == null || !RTPMediaCaster.this.tryConnect) {
                            RTPMediaCaster.this.isReconnectorRunning = false;
                            break;
                        }
                        ((ApplicationInstance)RTPMediaCaster.this.appInstance).notifyMediaCasterConnectStart(this.rtpMediaCaster);
                        String string = RTPMediaCaster.this.getStreamInfo(RTPMediaCaster.this.streamName, n);
                        if (string != null) {
                            RTPMediaCaster.this.openRTPSession(string);
                        }
                        ++n;
                        if (RTPMediaCaster.this.rtpSession != null) {
                            RTPMediaCaster.this.isReconnectorRunning = false;
                            ((ApplicationInstance)RTPMediaCaster.this.appInstance).notifyMediaCasterConnectSuccess(this.rtpMediaCaster);
                            break;
                        }
                        ((ApplicationInstance)RTPMediaCaster.this.appInstance).notifyMediaCasterConnectFailure(this.rtpMediaCaster);
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPMediaCaster.class).error("RTPMediaCaster.Reconnector: " + exception.toString());
                exception.printStackTrace();
            }
            WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.Reconnector: stop");
        }
    }
}

