/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster.shoutcast;

import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.mediacaster.IMediaCasterDataReceiver;
import com.wowza.wms.mediacaster.MediaCaster;
import com.wowza.wms.mediacaster.MediaCasterConnection;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.shoutcast.IShoutCastFrameReceiver;
import com.wowza.wms.mediacaster.shoutcast.ShoutCastDecoder;
import com.wowza.wms.mediacaster.shoutcast.ShoutCastSessionHandler;
import com.wowza.wms.mediacaster.shoutcast.ShoutCastURL;
import com.wowza.wms.mediacaster.wowza.LiveMediaStreamReceiver;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.VHost;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;

public class ShoutCastReceiver
extends MediaCaster
implements IMediaCasterDataReceiver {
    private ShoutCastDecoder decoder = null;
    private FrameReceiver frameReceiver = null;
    private Object lock = new Object();
    private ShoutCastURL shoutCastURL = null;
    private ShoutCastURL shoutCastRedirectURL = null;
    private ShoutCastSessionHandler sessionHandler = null;
    private IoSession session = null;
    private boolean tryConnect = false;
    private boolean isReconnectorRunning = false;
    private AtomicReference headerDataPacket = new AtomicReference<Object>(null);
    private LinkedList metaDataPacketList = new LinkedList();
    private boolean reconnectWithDelay = false;
    private int reconnectTimeout = 2000;
    private int streamTimeout = 0;
    private long streamMissingTime = -1L;
    private long streamLastSeq = -1L;
    private String characterEncoding = "8859_1";

    public ShoutCastReceiver() {
        this.sessionHandler = new ShoutCastSessionHandler(this, (IMediaCasterDataReceiver)this);
        WMSLoggerFactory.getLogger(ShoutCastReceiver.class).debug("ShoutCastReceiver.create");
    }

    public void init(MediaCasterStreamItem mediaCasterStreamItem, MediaCasterItem mediaCasterItem, IApplicationInstance iApplicationInstance, String string, String string2) {
        super.init(mediaCasterStreamItem, mediaCasterItem, iApplicationInstance, string, string2);
        this.streamTimeout = this.getProperties().getPropertyInt("streamTimeout", this.streamTimeout);
        this.characterEncoding = this.getProperties().getPropertyStr("characterEncoding", this.characterEncoding);
        this.reconnectTimeout = this.getProperties().getPropertyInt("reconnectTimeout", this.reconnectTimeout);
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        int n = mediaStreamMap.getNextStreamIndex();
        String string3 = mediaCasterItem.getStreamType();
        IMediaStream iMediaStream = mediaStreamMap.getStreamClientless(n, string3);
        WMSLoggerFactory.getLogger(null).info(null, iMediaStream, "stream", "create", 200, null);
        String string4 = mediaCasterItem.idStringToName(string);
        boolean bl = false;
        boolean bl2 = false;
        iMediaStream.setOpen(true);
        iMediaStream.setPlay(false);
        iMediaStream.setRecord(bl);
        iMediaStream.setAppend(bl2);
        iMediaStream.setName(string);
        iMediaStream.setExt(string2);
        iMediaStream.setQueryStr("");
        MetaDataProvider metaDataProvider = new MetaDataProvider();
        iMediaStream.setMetaDataProvider(metaDataProvider);
        mediaStreamMap.notifyPlayPublish(iMediaStream);
        iMediaStream.startPublishing();
        WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
        WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
        WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "publish", 200, string);
        iMediaStream.notifyActionPublish(string, bl, bl2);
        this.setStream(iMediaStream);
        WMSLoggerFactory.getLogger(ShoutCastReceiver.class).debug("ShoutCastReceiver.init: " + string);
        this.connect(string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoSession internalConnect() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shoutCastURL == null) {
                return null;
            }
            ShoutCastURL shoutCastURL = this.shoutCastRedirectURL == null ? this.shoutCastURL : this.shoutCastRedirectURL;
            WMSLoggerFactory.getLogger(ShoutCastReceiver.class).info("ShoutCastReceiver.internalConnect: " + shoutCastURL.toString());
            this.headerDataPacket.set(null);
            this.metaDataPacketList.clear();
            VHost vHost = (VHost)this.getStream().getStreams().getVHost();
            MediaCasterConnection mediaCasterConnection = vHost.getMediaCasterConnection();
            this.sessionHandler.setPath(shoutCastURL.getPathWithQuery());
            this.decoder = null;
            int n = this.getMediaCasterDef().getConnectionTimeout();
            return mediaCasterConnection.connect(this.sessionHandler, shoutCastURL.getIp(), shoutCastURL.getPort(), n);
        }
    }

    private ShoutCastURL decodeURL(String string) {
        Object object;
        String string2 = null;
        int n = -1;
        String string3 = null;
        String string4 = null;
        try {
            object = new URI(string);
            string2 = ((URI)object).getHost();
            n = ((URI)object).getPort();
            string3 = ((URI)object).getPath();
            string4 = ((URI)object).getQuery();
        }
        catch (Exception exception) {
            string2 = null;
            WMSLoggerFactory.getLogger(ShoutCastReceiver.class).error("Invalid Shoutcast URL: " + exception.toString());
        }
        if (n == -1) {
            n = 80;
        }
        if (string3 == null) {
            string3 = "/";
        } else if (string3.length() == 0) {
            string3 = "/";
        }
        WMSLoggerFactory.getLogger(ShoutCastReceiver.class).debug("ShoutCastReceiver.decodeURL: url:" + string + " ip:" + string2 + " port:" + n + " path:" + string3);
        if (string2 != null) {
            object = new ShoutCastURL(string2, n, string3);
            if (string4 != null) {
                ((ShoutCastURL)object).setQuery(string4);
            }
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToConnect() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isReconnectorRunning) {
                this.isReconnectorRunning = true;
                this.getStream().getStreams().getVHost().getThreadPool().execute(new Reconnector(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(String string) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.shoutCastURL = this.decodeURL(string);
            if (this.shoutCastURL != null) {
                WMSLoggerFactory.getLogger(ShoutCastReceiver.class).debug("ShoutCastReceiver.connect: " + string + ":" + this.shoutCastURL.toString());
                this.tryConnect = true;
                bl = true;
                this.tryToConnect();
            } else {
                WMSLoggerFactory.getLogger(ShoutCastReceiver.class).debug("ShoutCastReceiver.connect: failure");
                this.tryConnect = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            IMediaStream iMediaStream;
            WMSLoggerFactory.getLogger(ShoutCastReceiver.class).debug("ShoutCastReceiver.disconnect: " + this.shoutCastURL);
            this.shoutCastURL = null;
            this.shoutCastRedirectURL = null;
            this.tryConnect = false;
            IoSession ioSession = this.session;
            if (ioSession != null) {
                this.session = null;
                WMSLoggerFactory.getLogger(ShoutCastReceiver.class).debug("ShoutCastReceiver.close1");
                ioSession.close();
            }
            if ((iMediaStream = this.getStream()) != null) {
                MediaStreamMap mediaStreamMap = this.getAppInstance().getStreams();
                int n = this.getStream().getSrc();
                try {
                    IApplicationInstance iApplicationInstance = this.getAppInstance();
                    if (iApplicationInstance != null) {
                        WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                    }
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "unpublish", 200, iMediaStream.getName());
                    iMediaStream.close();
                    iMediaStream.publish();
                    iMediaStream.stopPublishing();
                    iMediaStream.notifyActionUnPublish(iMediaStream.getName(), iMediaStream.isRecord(), iMediaStream.isAppend());
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ShoutCastReceiver.class).error("ShoutCastReceiver.disconnect: " + exception.toString());
                }
                mediaStreamMap.removeStream(n);
                this.setStream(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onData(ByteBuffer byteBuffer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.decoder == null) {
                if (this.frameReceiver == null) {
                    this.frameReceiver = new FrameReceiver();
                }
                this.decoder = new ShoutCastDecoder(this, this.frameReceiver);
            }
            byte[] byArray = null;
            int n = byteBuffer.limit();
            try {
                byArray = byteBuffer.array();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (byArray == null) {
                byArray = new byte[byteBuffer.limit()];
                byteBuffer.get(byArray);
            }
            this.decoder.addData(byArray, 0, n);
        }
    }

    public void sessionOpened(IoSession ioSession) {
    }

    public void resetStream() {
        if (this.decoder != null) {
            this.decoder.reset();
        }
        this.frameReceiver = null;
        this.streamMissingTime = -1L;
        this.streamLastSeq = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoSession ioSession) {
        WMSLoggerFactory.getLogger(ShoutCastReceiver.class).info("ShoutCastReceiver.sessionClosed: ");
        Object object = this.lock;
        synchronized (object) {
            this.session = null;
            this.resetStream();
            if (this.tryConnect) {
                this.tryToConnect();
            }
        }
    }

    public void shutdown(boolean bl) {
        WMSLoggerFactory.getLogger(ShoutCastReceiver.class).debug("ShoutCastReceiver.shutdown: " + this.shoutCastURL);
        this.disconnect();
    }

    public void registerPlayer(IMediaStreamPlay iMediaStreamPlay) {
    }

    public void unregisterPlayer(IMediaStreamPlay iMediaStreamPlay) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.lock;
        synchronized (object) {
            IoSession ioSession = this.session;
            WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("ShoutCastReceiver.resetConnection: ");
            if (ioSession != null) {
                this.session = null;
                ioSession.close();
            }
        }
    }

    public void forceReset() {
        this.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRedirect(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.shoutCastRedirectURL = this.decodeURL(string);
        }
        WMSLoggerFactory.getLogger(ShoutCastReceiver.class).info("ShoutCastReceiver.doRedirect: " + this.shoutCastRedirectURL);
    }

    public boolean isReconnectWithDelay() {
        return this.reconnectWithDelay;
    }

    public void setReconnectWithDelay(boolean bl) {
        this.reconnectWithDelay = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWatchdog() {
        boolean bl = false;
        if (this.streamTimeout > 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.session == null) {
                } else {
                    IMediaStream iMediaStream = this.getStream();
                    if (iMediaStream == null) {
                    } else {
                        List list = iMediaStream.getPlayPackets();
                        boolean bl2 = false;
                        if (list.size() == 0) {
                            bl2 = true;
                        } else {
                            AMFPacket aMFPacket = (AMFPacket)list.get(list.size() - 1);
                            long l = aMFPacket.getSeq();
                            if (l != this.streamLastSeq) {
                                this.streamLastSeq = l;
                            } else {
                                bl2 = true;
                            }
                        }
                        if (bl2) {
                            long l = System.currentTimeMillis();
                            if (this.streamMissingTime == -1L) {
                                this.streamMissingTime = l;
                            } else if (l - this.streamMissingTime > (long)this.streamTimeout) {
                                bl = true;
                            }
                        } else {
                            this.streamMissingTime = -1L;
                        }
                        if (bl) {
                            WMSLoggerFactory.getLogger(ShoutCastReceiver.class).info("ShoutCastReceiver.doWatchdog[" + this.shoutCastURL + "]: reset");
                            this.forceReset();
                        }
                    }
                }
            }
        }
        return false;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    class FrameReceiver
    implements IShoutCastFrameReceiver {
        boolean isFirst = true;
        long packetCount = 0L;
        long lastSample = 0L;
        long lastTimecode = 0L;
        int debugWriteSize = 0;
        int saveMP3frequency = -1;
        int saveMP3samplesPerFrame = -1;
        int saveMP3channels = -1;
        long mp3TimecodeOffset = 0L;
        int saveAACfrequency = -1;
        int saveAACsamplesPerFrame = -1;
        long aacTimecodeOffset = 0L;

        FrameReceiver() {
        }

        private long sample2TC(long l, int n) {
            return l * 1000L / (long)n;
        }

        private AMFPacket mapToDataPacket(Map map, String string, int n) {
            Object object2;
            AMFDataList aMFDataList = new AMFDataList();
            AMFDataMixedArray aMFDataMixedArray = new AMFDataMixedArray();
            WMSLogger wMSLogger = null;
            if (WMSLoggerFactory.getLogger(ShoutCastDecoder.class).isDebugEnabled()) {
                wMSLogger = WMSLoggerFactory.getLogger(ShoutCastDecoder.class);
            }
            if (wMSLogger != null) {
                wMSLogger.debug("ShoutCast Header:");
            }
            for (Object object2 : map.keySet()) {
                int n2;
                String string2 = (String)map.get(object2);
                if (wMSLogger != null) {
                    wMSLogger.debug("  " + (String)object2 + ": " + string2);
                }
                if (((String)object2).equals("icy-metaint")) {
                    n2 = 0;
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    aMFDataMixedArray.put((String)object2, new AMFDataItem((double)n2));
                    continue;
                }
                if (((String)object2).equals("icy-pub")) {
                    n2 = 0;
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    aMFDataMixedArray.put((String)object2, new AMFDataItem((double)n2));
                    continue;
                }
                if (((String)object2).equals("status")) {
                    n2 = 0;
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    aMFDataMixedArray.put((String)object2, new AMFDataItem((double)n2));
                    continue;
                }
                if (((String)object2).equals("icy-br")) {
                    n2 = 0;
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    aMFDataMixedArray.put((String)object2, new AMFDataItem((double)n2));
                    continue;
                }
                aMFDataMixedArray.put((String)object2, new AMFDataItem(string2));
            }
            aMFDataList.add(new AMFDataItem(string));
            aMFDataList.add(aMFDataMixedArray);
            object2 = aMFDataList.serialize();
            int n3 = ((Object)object2).length;
            AMFPacket aMFPacket = new AMFPacket(18, n, n3);
            aMFPacket.addData((byte[])object2, 0, n3);
            return aMFPacket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMetaData(Map map) {
            Object object = ShoutCastReceiver.this.lock;
            synchronized (object) {
                IMediaStream iMediaStream = ShoutCastReceiver.this.getStream();
                if (iMediaStream != null) {
                    AMFPacket aMFPacket = this.mapToDataPacket(map, "onMetaData", iMediaStream.getSrc());
                    aMFPacket.setAbsTimecode(this.lastTimecode);
                    ShoutCastReceiver.this.metaDataPacketList.add(aMFPacket);
                    AMFPacket aMFPacket2 = this.mapToDataPacket(map, "onMetaData", iMediaStream.getSrc());
                    AMFDataList aMFDataList = new AMFDataList(aMFPacket2.getData());
                    iMediaStream.setDataType(18);
                    iMediaStream.setDataTC(this.lastTimecode, true);
                    iMediaStream.setDataSize(aMFPacket2.getSize());
                    iMediaStream.startDataPacket();
                    iMediaStream.addDataData(aMFPacket2.getData(), 0, aMFPacket2.getSize());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onHeaderData(Map map) {
            Object object = ShoutCastReceiver.this.lock;
            synchronized (object) {
                IMediaStream iMediaStream = ShoutCastReceiver.this.getStream();
                if (iMediaStream != null) {
                    ShoutCastReceiver.this.headerDataPacket.set(this.mapToDataPacket(map, "onHeaderData", iMediaStream.getSrc()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCodecConfigAAC(AACFrame aACFrame, byte[] byArray, long l) {
            Object object = ShoutCastReceiver.this.lock;
            synchronized (object) {
                IMediaStream iMediaStream = ShoutCastReceiver.this.getStream();
                if (iMediaStream != null) {
                    long l2 = 0L;
                    iMediaStream.setAudioTC(l2, true);
                    int n = aACFrame.getRateIndex();
                    int n2 = aACFrame.getChannelIndex();
                    byte[] byArray2 = new byte[4];
                    byArray2[0] = -81;
                    byArray2[1] = 0;
                    byArray2[2] = 16;
                    byArray2[2] = (byte)(byArray2[2] + (n >> 1));
                    byArray2[3] = 0;
                    byArray2[3] = (byte)(byArray2[3] + (n << 7));
                    byArray2[3] = (byte)(byArray2[3] + (n2 << 3));
                    int n3 = byArray2.length;
                    iMediaStream.setAudioSize(n3);
                    iMediaStream.startAudioPacket();
                    iMediaStream.addAudioData(byArray2, 0, byArray2.length);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFrameAAC(AACFrame aACFrame, byte[] byArray, long l) {
            Object object = ShoutCastReceiver.this.lock;
            synchronized (object) {
                IMediaStream iMediaStream = ShoutCastReceiver.this.getStream();
                if (iMediaStream != null) {
                    int n = aACFrame.getSampleCount();
                    int n2 = aACFrame.getSampleRate();
                    if (this.saveAACfrequency == -1) {
                        this.saveAACfrequency = n2;
                        this.saveAACsamplesPerFrame = n;
                    }
                    if (this.saveAACfrequency != n2 || this.saveAACsamplesPerFrame != n) {
                        this.saveAACfrequency = n2;
                        this.saveAACsamplesPerFrame = n;
                        this.aacTimecodeOffset = this.lastTimecode;
                        this.lastSample = 0L;
                    }
                    long l2 = 0L;
                    if (this.isFirst) {
                        l2 = 0L;
                        this.lastSample = 0L;
                        this.lastTimecode = 0L;
                    } else {
                        this.lastSample += (long)n;
                        l2 = this.aacTimecodeOffset + this.sample2TC(this.lastSample, n2) - this.lastTimecode;
                        this.lastTimecode += l2;
                    }
                    iMediaStream.setAudioTC(l2, this.isFirst);
                    byte[] byArray2 = new byte[]{-81, 1};
                    int n3 = byArray2.length + aACFrame.getSize() - 7;
                    iMediaStream.setAudioSize(n3);
                    iMediaStream.startAudioPacket();
                    iMediaStream.addAudioData(byArray2, 0, byArray2.length);
                    iMediaStream.addAudioData(byArray, (int)(l + 7L), aACFrame.getSize() - 7);
                    this.isFirst = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFrameMP3(int n, int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            Object object = ShoutCastReceiver.this.lock;
            synchronized (object) {
                IMediaStream iMediaStream;
                if (this.saveMP3frequency == -1) {
                    this.saveMP3frequency = n;
                    this.saveMP3samplesPerFrame = n2;
                    this.saveMP3channels = n3;
                }
                if (this.saveMP3frequency != n || this.saveMP3samplesPerFrame != n2 || this.saveMP3channels != n3) {
                    this.saveMP3frequency = n;
                    this.saveMP3samplesPerFrame = n2;
                    this.saveMP3channels = n3;
                    this.mp3TimecodeOffset = this.lastTimecode;
                    this.lastSample = 0L;
                }
                if ((iMediaStream = ShoutCastReceiver.this.getStream()) != null) {
                    long l = 0L;
                    if (this.isFirst) {
                        l = 0L;
                        this.lastSample = 0L;
                        this.lastTimecode = 0L;
                    } else {
                        this.lastSample += (long)n2;
                        l = this.mp3TimecodeOffset + this.sample2TC(this.lastSample, n) - this.lastTimecode;
                        this.lastTimecode += l;
                    }
                    iMediaStream.setAudioTC(l, this.isFirst);
                    int n4 = byArray.length + byArray2.length + byArray3.length;
                    iMediaStream.setAudioSize(n4);
                    iMediaStream.startAudioPacket();
                    iMediaStream.addAudioData(byArray2, 0, byArray2.length);
                    iMediaStream.addAudioData(byArray, 0, byArray.length);
                    iMediaStream.addAudioData(byArray3, 0, byArray3.length);
                    this.isFirst = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTrim() {
            IMediaStream iMediaStream = ShoutCastReceiver.this.getStream();
            if (iMediaStream != null) {
                Object object = ShoutCastReceiver.this.lock;
                synchronized (object) {
                    iMediaStream.trim();
                }
            }
        }
    }

    class MetaDataProvider
    implements IMediaStreamMetaDataProvider {
        MetaDataProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStreamStart(List list, long l) {
            AMFPacket aMFPacket = (AMFPacket)ShoutCastReceiver.this.headerDataPacket.get();
            if (aMFPacket != null) {
                list.add(aMFPacket);
            }
            Object object = ShoutCastReceiver.this.lock;
            synchronized (object) {
                AMFPacket aMFPacket2;
                AMFPacket aMFPacket3 = null;
                long l2 = -1L;
                Iterator iterator = ShoutCastReceiver.this.metaDataPacketList.iterator();
                while (iterator.hasNext() && l >= (aMFPacket2 = (AMFPacket)iterator.next()).getAbsTimecode()) {
                    aMFPacket3 = aMFPacket2;
                    l2 = aMFPacket2.getAbsTimecode();
                }
                if (aMFPacket3 != null) {
                    list.add(aMFPacket3);
                    iterator = ShoutCastReceiver.this.metaDataPacketList.iterator();
                    while (iterator.hasNext()) {
                        aMFPacket2 = (AMFPacket)iterator.next();
                        long l3 = l - aMFPacket2.getAbsTimecode();
                        if (aMFPacket2.getAbsTimecode() == l2 || l3 <= 600000L) break;
                        iterator.remove();
                    }
                }
            }
        }
    }

    class Reconnector
    implements Runnable {
        private ShoutCastReceiver shoutCastReceiver = null;

        public Reconnector(ShoutCastReceiver shoutCastReceiver2) {
            this.shoutCastReceiver = shoutCastReceiver2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ShoutCastReceiver.this.resetStream();
                while (true) {
                    if (ShoutCastReceiver.this.isReconnectWithDelay()) {
                        Thread.sleep(ShoutCastReceiver.this.reconnectTimeout);
                        ShoutCastReceiver.this.setReconnectWithDelay(false);
                    }
                    Object object = ShoutCastReceiver.this.lock;
                    synchronized (object) {
                        if (ShoutCastReceiver.this.shoutCastURL == null) {
                            ShoutCastReceiver.this.isReconnectorRunning = false;
                            break;
                        }
                        ((ApplicationInstance)ShoutCastReceiver.this.appInstance).notifyMediaCasterConnectStart(this.shoutCastReceiver);
                        IoSession ioSession = ShoutCastReceiver.this.internalConnect();
                        if (ioSession != null) {
                            this.shoutCastReceiver.session = ioSession;
                            ShoutCastReceiver.this.isReconnectorRunning = false;
                            ((ApplicationInstance)ShoutCastReceiver.this.appInstance).notifyMediaCasterConnectSuccess(this.shoutCastReceiver);
                            break;
                        }
                        ((ApplicationInstance)ShoutCastReceiver.this.appInstance).notifyMediaCasterConnectFailure(this.shoutCastReceiver);
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ShoutCastReceiver.class).error("ShoutCastReceiver.Reconnector: " + exception.toString());
            }
        }
    }
}

