/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.module;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.response.ResponseFunctions;
import com.wowza.wms.server.ReleaseInfo;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamDisconnected;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.util.ModuleUtils;

public class ModuleCore
extends ModuleBase {
    public static void createStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        int n;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n = mediaStreamMap.getNextStreamIndex(iClient), true);
        if (iMediaStream != null && iClient.isConnected()) {
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "create", 200, "streamType:" + iClient.getStreamType() + " streamIndex:" + n);
        }
        ((Client)iClient).setLastStreamId(n);
        ModuleCore.sendResult(iClient, aMFDataList, n);
    }

    public static void initStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = 0;
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 0) {
            n = ((Double)((AMFData)object).getValue()).intValue();
        }
        if (n > 0) {
            object = mediaStreamMap.getStream(iClient, n);
            if (object != null) {
                ((Client)iClient).closeOpenStream((IMediaStream)object);
                mediaStreamMap.removeStream(iClient, n);
            }
            if ((object = mediaStreamMap.getStream(iClient, n, true)) != null) {
                if (iClient.isConnected()) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, (IMediaStream)object, "stream", "create", 200, "streamType:" + iClient.getStreamType() + " streamIndex:" + n);
                }
                ((Client)iClient).setLastStreamId(n);
            }
        }
    }

    public static void releaseStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = "[unknown]";
        if (aMFDataList.size() >= 4) {
            string = ModuleCore.getParamString(aMFDataList, 3);
            MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
            mediaStreamMap.clearStreamName(string);
            mediaStreamMap.notifyPlayUnpublish(string);
        }
    }

    public static void getLastStreamId(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleCore.sendResult(iClient, aMFDataList, ((Client)iClient).getLastStreamId());
    }

    public static void deleteStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = 0;
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 0) {
            n = ((Double)((AMFData)object).getValue()).intValue();
        }
        if (n > 0) {
            object = mediaStreamMap.getStream(iClient, n);
            ((Client)iClient).closeOpenStream((IMediaStream)object);
            mediaStreamMap.removeStream(iClient, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        ResponseFunctions responseFunctions = iClient.getRespFunctions();
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        double d = iClient.getClientId();
        String string = null;
        String string2 = "";
        Object object2 = "flv";
        int n = requestFunction.getSrc();
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 2 && (string = (String)((AMFData)object).getValue()) != null && ((string = string.trim()).equalsIgnoreCase("false") || string.equalsIgnoreCase("null"))) {
            string = null;
        }
        if (string != null) {
            String[] stringArray;
            String[] stringArray2;
            AMFData aMFData;
            object = ModuleUtils.decodeStreamExtension(string, (String)object2);
            string = object[0];
            object2 = object[1];
            boolean bl = string.indexOf("://") >= 0;
            int n2 = string.indexOf("?");
            if (!bl && n2 >= 0) {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (aMFDataList.size() >= 5 && (aMFData = aMFDataList.get(4)).getType() == 2 && (stringArray2 = (stringArray = (String)aMFData.getValue()).split("[:]")).length > 0) {
                if (stringArray2[0].compareToIgnoreCase("record") == 0 || stringArray2[0].compareToIgnoreCase("append") == 0) {
                    bl2 = true;
                }
                if (stringArray2[0].compareToIgnoreCase("append") == 0) {
                    bl3 = true;
                }
            }
            aMFData = null;
            stringArray = mediaStreamMap.getStream(iClient, n);
            if (stringArray != null) {
                stringArray2 = stringArray;
                synchronized (stringArray) {
                    Object object3;
                    boolean[] blArray = stringArray.getAccess(iClient, string);
                    ResponseFunction responseFunction = null;
                    responseFunction = new ResponseFunction(stringArray.getClient(), stringArray.getRespAMFDataObj());
                    responseFunction.createDefaultMessage("onStatus", 0.0);
                    responseFunction.setSrc(n);
                    if (blArray[1]) {
                        aMFData = new AMFDataObj();
                        ((AMFDataObj)aMFData).put("level", new AMFDataItem("status"));
                        ((AMFDataObj)aMFData).put("code", new AMFDataItem("NetStream.Publish.Start"));
                        ((AMFDataObj)aMFData).put("description", new AMFDataItem("Publishing " + string + "."));
                        ((AMFDataObj)aMFData).put("clientid", new AMFDataItem(d));
                        responseFunction.addBody(aMFData);
                        object3 = new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, (byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n)};
                        ResponseFunction responseFunction2 = new ResponseFunction(iClient);
                        responseFunction2.addBytes((byte[])object3);
                        responseFunction2.doBreak = true;
                        responseFunctions.add(responseFunction2);
                        stringArray.setSendPublishStopLogEvent(true);
                    } else {
                        aMFData = new AMFDataObj();
                        ((AMFDataObj)aMFData).put("level", new AMFDataItem("error"));
                        ((AMFDataObj)aMFData).put("code", new AMFDataItem("NetStream.Record.NoAccess"));
                        ((AMFDataObj)aMFData).put("description", new AMFDataItem("Write access denied for stream " + string + "."));
                        ((AMFDataObj)aMFData).put("clientid", new AMFDataItem(d));
                        responseFunction.addBody(aMFData);
                    }
                    responseFunctions.add(responseFunction);
                    if (blArray[1]) {
                        stringArray.setOpen(true);
                        stringArray.setRecord(bl2);
                        stringArray.setAppend(bl3);
                        stringArray.setName(string);
                        stringArray.setExt((String)object2);
                        stringArray.setQueryStr(string2);
                        ((Client)iClient).addPublishStreams((IMediaStream)stringArray);
                        if (blArray[1]) {
                            if (bl2) {
                                object3 = new ResponseFunction(stringArray.getClient(), stringArray.getRespAMFDataObj());
                                ((ResponseFunction)object3).createDefaultMessage("onStatus", 0.0);
                                ((ResponseFunction)object3).setSrc(n);
                                aMFData = new AMFDataObj();
                                ((AMFDataObj)aMFData).put("level", new AMFDataItem("status"));
                                ((AMFDataObj)aMFData).put("code", new AMFDataItem("NetStream.Record.Start"));
                                ((AMFDataObj)aMFData).put("description", new AMFDataItem("Recording " + string + "."));
                                ((AMFDataObj)aMFData).put("clientid", new AMFDataItem(d));
                                ((ResponseFunction)object3).addBody(aMFData);
                                responseFunctions.add((ResponseFunction)object3);
                                stringArray.setSendRecordStopLogEvent(true);
                            } else {
                                mediaStreamMap.notifyPlayPublish((IMediaStream)stringArray);
                            }
                        }
                        stringArray.startPublishing();
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, (IMediaStream)stringArray, "stream", "publish", 200, string);
                        if (bl2) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, (IMediaStream)stringArray, "stream", "record", 200, string);
                        }
                        stringArray.notifyActionPublish(string, bl2, bl3);
                    } else {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, (IMediaStream)stringArray, "stream", "publish", 401, string);
                    }
                    // ** MonitorExit[var18_17] (shouldn't be in output)
                }
            }
        } else {
            object = mediaStreamMap.getStream(iClient, n);
            if (object != null) {
                ((Client)iClient).closeOpenStream((IMediaStream)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void play(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        block19: {
            ResponseFunctions responseFunctions = iClient.getRespFunctions();
            MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
            double d = iClient.getClientId();
            String string = "unknown";
            String string2 = "flv";
            String string3 = "";
            double d2 = -2.0;
            double d3 = -1.0;
            int n = 1;
            try {
                Object object;
                if (aMFDataList.size() < 4) break block19;
                int n2 = requestFunction.getSrc();
                AMFData aMFData = aMFDataList.get(3);
                if (aMFData.getType() != 2) break block19;
                string = (String)aMFData.getValue();
                String[] stringArray = ModuleUtils.decodeStreamExtension(string, string2);
                string = stringArray[0];
                string2 = stringArray[1];
                boolean bl = string.indexOf("://") >= 0;
                int n3 = string.indexOf("?");
                if (!bl && n3 >= 0) {
                    string3 = string.substring(n3 + 1);
                    string = string.substring(0, n3);
                }
                if (string == null) {
                    string = "unknown";
                }
                if (aMFDataList.size() >= 5 && ((AMFData)(object = aMFDataList.get(4))).getType() == 0) {
                    d2 = (Double)((AMFData)object).getValue();
                }
                if (aMFDataList.size() >= 6 && ((AMFData)(object = aMFDataList.get(5))).getType() == 0) {
                    d3 = (Double)((AMFData)object).getValue();
                }
                if (aMFDataList.size() >= 7) {
                    object = aMFDataList.get(6);
                    if (((AMFData)object).getType() == 1) {
                        n = (Boolean)((AMFData)object).getValue() != false ? 1 : 0;
                    } else if (((AMFData)object).getType() == 0) {
                        n = ((Double)((AMFData)object).getValue()).intValue();
                    }
                }
                object = mediaStreamMap.getStream(iClient, n2);
                IApplicationInstance iApplicationInstance = ModuleCore.getAppInstance(iClient);
                if (object == null) break block19;
                Object object2 = object;
                synchronized (object2) {
                    boolean[] blArray = object.getAccess(iClient, string);
                    if (blArray[0]) {
                        object.setOpen(true);
                        object.setPlay(true);
                        object.setName(string, string2, string3, d2, d3, n);
                        string = object.getName();
                        IMediaStreamPlay iMediaStreamPlay = object.getPlayer();
                        if (n == 1 || n == 3) {
                            object.setFastPlaySettings(iClient.getFastPlaySettings());
                            iClient.clearFastPlaySettings();
                            ((Client)iClient).addPlayStreams((IMediaStream)object);
                            if (iMediaStreamPlay != null) {
                                iMediaStreamPlay.reset(true);
                                iMediaStreamPlay.interruptPlay();
                                iMediaStreamPlay.startPlay();
                            }
                            iApplicationInstance.addPlayStreamByName((IMediaStream)object, string);
                        } else if (iMediaStreamPlay != null) {
                            iMediaStreamPlay.reset(false);
                        }
                    } else {
                        ResponseFunction responseFunction = null;
                        responseFunction = new ResponseFunction(object.getClient(), object.getRespAMFDataObj());
                        responseFunction.createDefaultMessage("onStatus", 0.0);
                        responseFunction.setSrc(n2);
                        AMFDataObj aMFDataObj = null;
                        aMFDataObj = new AMFDataObj();
                        aMFDataObj.put("level", new AMFDataItem("error"));
                        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Failed"));
                        aMFDataObj.put("description", new AMFDataItem("Read access denied for stream " + string + "."));
                        aMFDataObj.put("clientid", new AMFDataItem(d));
                        responseFunction.addBody(aMFDataObj);
                        responseFunctions.add(responseFunction);
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, (IMediaStream)object, "stream", "play", 401, string);
                    }
                }
            }
            catch (Exception exception) {
                ModuleCore.getLogger().error("play: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static void closeStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        int n;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n = requestFunction.getSrc());
        if (iMediaStream != null) {
            if (iMediaStream.isPlay()) {
                ((Client)iClient).removePlayStreams(iMediaStream);
            } else {
                ((Client)iClient).removePublishStreams(iMediaStream);
            }
            ((Client)iClient).closeOpenStream(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void seek(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n);
        int n2 = 0;
        double d = 0.0;
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 0) {
            n2 = ((Double)((AMFData)object).getValue()).intValue();
            d = (Double)((AMFData)object).getValue();
        }
        if (iMediaStream != null) {
            object = iMediaStream;
            synchronized (object) {
                iMediaStream.setFastPlaySettings(iClient.getFastPlaySettings());
                iClient.clearFastPlaySettings();
                IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                if (iMediaStreamPlay != null) {
                    iMediaStreamPlay.seek(n2);
                }
                iMediaStream.notifyActionSeek(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        block8: {
            try {
                AMFData aMFData;
                AMFData aMFData2;
                MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
                int n = requestFunction.getSrc();
                IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n);
                int n2 = -1;
                if (aMFDataList.size() >= 4 && (aMFData2 = aMFDataList.get(3)).getType() == 1) {
                    n2 = (Boolean)aMFData2.getValue() != false ? 1 : 0;
                }
                long l = 0L;
                if (aMFDataList.size() >= 5 && (aMFData = aMFDataList.get(4)).getType() == 0) {
                    l = ((Double)aMFData.getValue()).longValue();
                }
                if (iMediaStream == null) break block8;
                boolean bl = n2 == -1 ? iMediaStream.isPlaying() : n2 == 1;
                IMediaStream iMediaStream2 = iMediaStream;
                synchronized (iMediaStream2) {
                    iMediaStream.setFastPlaySettings(iClient.getFastPlaySettings());
                    iClient.clearFastPlaySettings();
                    IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                    if (iMediaStreamPlay != null) {
                        iMediaStreamPlay.pause(n2, l);
                    }
                    iMediaStream.notifyActionPause(bl, l);
                }
            }
            catch (Exception exception) {
                ModuleCore.getLogger().error("pause: error: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBufferTime(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        int n2 = 0;
        if (aMFDataList.size() >= 4 && ((AMFData)(object = aMFDataList.get(3))).getType() == 0) {
            n2 = ((Double)((AMFData)object).getValue()).intValue();
        }
        if (n > 0 && (object = mediaStreamMap.getStream(iClient, n)) != null) {
            Object object2 = object;
            synchronized (object2) {
                object.setBufferTime(n2);
                WMSLoggerFactory.getLogger(ModuleCore.class).debug(n2 + "", null, "session", "setbuffertime", 200, "[" + iClient.getClientId() + "," + object.getSrc() + "]: " + n2 + "");
            }
        }
    }

    public static void getClientID(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        double d = iClient.getClientId();
        ModuleCore.sendResult(iClient, aMFDataList, d);
    }

    public static void getVersion(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = MediaStreamBase.p + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber();
        ModuleCore.sendResult(iClient, aMFDataList, string);
    }

    public static void setStreamType(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = ModuleCore.getParamString(aMFDataList, 3);
        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, null, "application", "setstreamtype", 200, string);
        iClient.setStreamType(string);
    }

    public static void getStreamType(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleCore.sendResult(iClient, aMFDataList, iClient.getStreamType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveAudio(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        IMediaStream iMediaStream;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        boolean bl = ModuleCore.getParamBoolean(aMFDataList, 3, true);
        if (n > 0 && (iMediaStream = mediaStreamMap.getStream(iClient, n)) != null) {
            IMediaStream iMediaStream2 = iMediaStream;
            synchronized (iMediaStream2) {
                iMediaStream.setReceiveAudio(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveVideo(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
        int n = requestFunction.getSrc();
        boolean bl = true;
        int n2 = -1;
        if (aMFDataList.size() > 3) {
            object = aMFDataList.get(3);
            if (((AMFData)object).getType() == 0) {
                int n3 = ((Double)((AMFData)object).getValue()).intValue();
                if (n3 > 0) {
                    bl = true;
                    n2 = n3;
                } else if (n3 == -1) {
                    bl = true;
                    n2 = -1;
                } else if (n3 == -2) {
                    bl = true;
                    n2 = -2;
                } else if (n3 == -3) {
                    bl = true;
                    n2 = -3;
                } else {
                    bl = false;
                    n2 = -1;
                }
            } else if (((AMFData)object).getType() == 1) {
                bl = (Boolean)((AMFData)object).getValue();
                n2 = -1;
            }
        }
        if (n > 0 && (object = mediaStreamMap.getStream(iClient, n)) != null) {
            Object object2 = object;
            synchronized (object2) {
                object.setReceiveVideo(bl);
                object.setReceiveVideoFPS(n2);
            }
        }
    }

    public static void getStreamLength(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        AMFData aMFData = aMFDataList.get(3);
        if (aMFData != null) {
            if (aMFData.getType() == 2) {
                IApplicationInstance iApplicationInstance;
                IMediaReader iMediaReader;
                double d = 0.0;
                String string = ModuleCore.getParamString(aMFDataList, 3);
                String string2 = "flv";
                String string3 = "";
                String[] stringArray = ModuleUtils.decodeStreamExtension(string, string2);
                string = stringArray[0];
                string2 = stringArray[1];
                boolean bl = string.indexOf("://") >= 0;
                int n = string.indexOf("?");
                if (!bl && n >= 0) {
                    string3 = string.substring(n + 1);
                    string = string.substring(0, n);
                }
                if ((iMediaReader = MediaReaderFactory.getInstance(iApplicationInstance = iClient.getAppInstance(), iClient.getVHost().getMediaReaders(), string2)) != null) {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    MediaStreamDisconnected mediaStreamDisconnected = new MediaStreamDisconnected();
                    mediaStreamDisconnected.init(mediaStreamMap, 0, new WMSProperties());
                    mediaStreamDisconnected.setName(string, string2, string3, 0.0, -1.0, 1);
                    String string4 = iClient.getAppInstance().getStreamStoragePath();
                    iMediaReader.init(iClient.getAppInstance(), mediaStreamDisconnected, string2, string4, string);
                    long l = iMediaReader.getDuration();
                    d = (double)l / 1000.0;
                    iMediaReader.close();
                }
                ModuleCore.getLogger().debug("stream getStreamLength [" + string + "] streamLength:" + d);
                ModuleCore.sendResult(iClient, aMFDataList, d);
            } else if (aMFData.getType() == 8) {
                AMFDataArray aMFDataArray = new AMFDataArray();
                AMFDataMixedArray aMFDataMixedArray = (AMFDataMixedArray)aMFDataList.get(3);
                for (int i = 0; i < aMFDataMixedArray.size(); ++i) {
                    String string = ModuleCore.getParamString(aMFDataList, 3);
                    String string5 = "flv";
                    String string6 = "";
                    String[] stringArray = ModuleUtils.decodeStreamExtension(string, string5);
                    string = stringArray[0];
                    string5 = stringArray[1];
                    boolean bl = string.indexOf("://") >= 0;
                    int n = string.indexOf("?");
                    if (!bl && n >= 0) {
                        string6 = string.substring(n + 1);
                        string = string.substring(0, n);
                    }
                    IApplicationInstance iApplicationInstance = iClient.getAppInstance();
                    double d = 0.0;
                    IMediaReader iMediaReader = MediaReaderFactory.getInstance(iApplicationInstance, iClient.getVHost().getMediaReaders(), string5);
                    if (iMediaReader != null) {
                        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                        MediaStreamDisconnected mediaStreamDisconnected = new MediaStreamDisconnected();
                        mediaStreamDisconnected.init(mediaStreamMap, 0, new WMSProperties());
                        mediaStreamDisconnected.setName(string, string5, string6, 0.0, -1.0, 1);
                        String string7 = iClient.getAppInstance().getStreamStoragePath();
                        iMediaReader.init(iClient.getAppInstance(), null, string5, string7, string);
                        long l = iMediaReader.getDuration();
                        d = (double)l / 1000.0;
                        iMediaReader.close();
                    }
                    ModuleCore.getLogger().debug("stream getStreamLength [" + string + "] streamLength:" + d);
                    aMFDataArray.add(new AMFDataItem(d));
                }
                ModuleCore.sendResult(iClient, aMFDataList, aMFDataArray);
            }
        }
    }

    public static void getRepeaterOriginUrl(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = iClient.getRepeaterOriginUrl();
        ModuleCore.sendResult(iClient, aMFDataList, string);
    }

    public static void setRepeaterOriginUrl(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = ModuleCore.getParamString(aMFDataList, 3);
        iClient.setRepeaterOriginUrl(string);
    }

    public static void FCPublish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
    }

    public static void FCUnpublish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseRaw(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        block7: {
            try {
                AMFData aMFData;
                AMFData aMFData2;
                MediaStreamMap mediaStreamMap = ModuleCore.getAppInstance(iClient).getStreams();
                int n = requestFunction.getSrc();
                IMediaStream iMediaStream = mediaStreamMap.getStream(iClient, n);
                int n2 = -1;
                if (aMFDataList.size() >= 4 && (aMFData2 = aMFDataList.get(3)).getType() == 1) {
                    n2 = (Boolean)aMFData2.getValue() != false ? 1 : 0;
                }
                long l = 0L;
                if (aMFDataList.size() >= 5 && (aMFData = aMFDataList.get(4)).getType() == 0) {
                    l = ((Double)aMFData.getValue()).longValue();
                }
                if (iMediaStream == null) break block7;
                boolean bl = n2 == -1 ? iMediaStream.isPlaying() : n2 == 1;
                IMediaStream iMediaStream2 = iMediaStream;
                synchronized (iMediaStream2) {
                    iMediaStream.notifyActionPauseRaw(bl, l);
                }
            }
            catch (Exception exception) {
                ModuleCore.getLogger().error("pause: error: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static void getReferrer(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = iClient.getReferrer();
        if (string == null) {
            string = "";
        }
        ModuleCore.sendResult(iClient, aMFDataList, new AMFDataItem(string));
    }

    public static void getPageUrl(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = iClient.getPageUrl();
        if (string == null) {
            string = "";
        }
        ModuleCore.sendResult(iClient, aMFDataList, new AMFDataItem(string));
    }
}

