/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleFunction;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleFunctions {
    public static final String[] SPECIALFUNCTIONS = new String[]{"onAppStart", "onAppStop", "onConnect", "onDisconnect", "onConnectAccept", "onConnectReject", "onStreamCreate", "onStreamDestroy", "onCall"};
    private Map<String, List<ModuleFunction>> functions = new HashMap<String, List<ModuleFunction>>();
    private Map<String, List<ModuleFunction>> specials = new HashMap<String, List<ModuleFunction>>();
    private Map components = new HashMap();

    public ModuleFunctions() {
        for (int i = 0; i < SPECIALFUNCTIONS.length; ++i) {
            this.specials.put(SPECIALFUNCTIONS[i], new ArrayList());
        }
    }

    public void add(String string, ModuleFunction moduleFunction) {
        List<ModuleFunction> list = this.functions.get(string);
        if (list == null) {
            list = new ArrayList<ModuleFunction>();
            this.functions.put(string, list);
        }
        list.add(moduleFunction);
    }

    public void addSpecial(String string, ModuleFunction moduleFunction) {
        List<ModuleFunction> list = this.specials.get(string);
        if (list != null) {
            list.add(moduleFunction);
        }
    }

    public int size() {
        return this.functions.size();
    }

    public ModuleFunction get(String string) {
        List<ModuleFunction> list = this.functions.get(string);
        if (list != null) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public ModuleFunction get(String string, int n) {
        List<ModuleFunction> list = this.functions.get(string);
        if (list != null) {
            return list.get(n);
        }
        return null;
    }

    public int getIndex(String string, Object object) {
        List<ModuleFunction> list = this.functions.get(string);
        if (list != null) {
            int n = 0;
            for (ModuleFunction moduleFunction : list) {
                if (moduleFunction.instance == object) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean exists(String string) {
        return this.functions.containsKey(string);
    }

    public boolean invokePrevious(String string, Object object, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl;
        block0: {
            ModuleFunction moduleFunction;
            bl = false;
            int n = this.getIndex(string, object);
            if (n <= 0 || (moduleFunction = this.get(string, --n)) == null) break block0;
            moduleFunction.invoke(iClient, requestFunction, aMFDataList);
            bl = true;
        }
        return bl;
    }

    public boolean invoke(String string, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleFunction moduleFunction = this.get(string);
        if (moduleFunction != null) {
            moduleFunction.invoke(iClient, requestFunction, aMFDataList);
            return true;
        }
        return false;
    }

    public boolean invokeComponent(String string, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String[] stringArray = string.split("[.]");
        if (stringArray.length == 3) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            ComponentItem componentItem = (ComponentItem)this.components.get(string2);
            if (componentItem != null) {
                Object object;
                ComponentInstance componentInstance = (ComponentInstance)componentItem.instances.get(string3);
                if (componentInstance == null) {
                    try {
                        object = Class.forName(componentItem.classStr);
                        if (object != null) {
                            Object t = ((Class)object).newInstance();
                            componentInstance = new ComponentInstance(string3, t);
                            componentItem.instances.put(string3, componentInstance);
                        }
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(ModuleFunction.class).error("invokeComponent: createClass(" + componentItem.classStr + "): " + exception.toString());
                    }
                }
                if ((object = (ModuleFunction)componentItem.functions.get(string4)) != null) {
                    ((ModuleFunction)object).invoke(iClient, requestFunction, aMFDataList, componentInstance.instance);
                    if (string4.equals("onDisconnect")) {
                        componentItem.instances.remove(string3);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean invokeSpecial(String string, String string2, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = false;
        List<ModuleFunction> list = this.specials.get(string);
        for (ModuleFunction moduleFunction : list) {
            if (moduleFunction == null) continue;
            moduleFunction.invoke(string2, iClient, requestFunction, aMFDataList);
            bl = true;
        }
        return bl;
    }

    private boolean invokeSpecial(String string, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = false;
        List<ModuleFunction> list = this.specials.get(string);
        for (ModuleFunction moduleFunction : list) {
            if (moduleFunction == null) continue;
            moduleFunction.invoke(iClient, requestFunction, aMFDataList);
            bl = true;
        }
        return bl;
    }

    private boolean invokeSpecial(String string, Object object) {
        boolean bl = false;
        List<ModuleFunction> list = this.specials.get(string);
        for (ModuleFunction moduleFunction : list) {
            if (moduleFunction == null) continue;
            moduleFunction.invoke(object);
            bl = true;
        }
        return bl;
    }

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.invokeSpecial("onAppStart", iApplicationInstance);
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        this.invokeSpecial("onAppStop", iApplicationInstance);
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        this.invokeSpecial("onConnect", iClient, requestFunction, aMFDataList);
    }

    public void onDisconnect(IClient iClient) {
        this.invokeSpecial("onDisconnect", iClient);
    }

    public void onConnectAccept(IClient iClient) {
        this.invokeSpecial("onConnectAccept", iClient);
    }

    public void onConnectReject(IClient iClient) {
        this.invokeSpecial("onConnectReject", iClient);
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        this.invokeSpecial("onStreamCreate", iMediaStream);
    }

    public void onStreamDestroy(IMediaStream iMediaStream) {
        this.invokeSpecial("onStreamDestroy", iMediaStream);
    }

    public void onCall(String string, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        this.invokeSpecial("onCall", string, iClient, requestFunction, aMFDataList);
    }

    public boolean isOnCall() {
        return this.specials.get("onCall").size() > 0;
    }

    public boolean isSpecial(String string) {
        return this.specials.containsKey(string);
    }

    public void addComponentFunction(String string, String string2, ModuleFunction moduleFunction) {
        ComponentItem componentItem = (ComponentItem)this.components.get(string);
        if (componentItem != null) {
            componentItem.functions.put(string2, moduleFunction);
        }
    }

    public void addComponentClass(String string, String string2) {
        ComponentItem componentItem = (ComponentItem)this.components.get(string);
        if (componentItem == null) {
            componentItem = new ComponentItem(string, string2);
            this.components.put(string, componentItem);
        }
    }

    class ComponentInstance {
        public String name = null;
        public Object instance = null;

        ComponentInstance(String string, Object object) {
            this.name = string;
            this.instance = object;
        }
    }

    class ComponentItem {
        public String name = null;
        public String classStr = null;
        public Map functions = new HashMap();
        public Map instances = new HashMap();

        ComponentItem(String string, String string2) {
            this.name = string;
            this.classStr = string2;
        }
    }
}

