/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.netconnection;

import com.wowza.util.AMFUtils;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.NoMBean;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.netconnection.INetConnectionCallResult;
import com.wowza.wms.netconnection.INetConnectionCallback;
import com.wowza.wms.netconnection.INetConnectionIdle;
import com.wowza.wms.netconnection.INetConnectionPingResult;
import com.wowza.wms.netconnection.INetConnectionPublisher;
import com.wowza.wms.netconnection.NetConnectionCallResults;
import com.wowza.wms.netconnection.NetConnectionPingResult;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.response.ResponseFunctions;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.VHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.BaseIoSession;

public class NetConnection
implements INetConnection {
    public static final int CONFIRM_BYTESRECEIVED = 625500;
    private NetConnectionCallResults callResults = new NetConnectionCallResults(1);
    private ResponseFunctions respFunctions = new ResponseFunctions();
    private MediaStreamMap streams = null;
    private IApplicationInstance appInstance = null;
    private int handshake = 0;
    private INetConnectionCallResult handshakeResult = null;
    private INetConnectionIdle idleHandler = null;
    private byte[] leftOverData = null;
    private Map partialFunctions = new HashMap();
    private List reqAMFObjs = new ArrayList();
    private List respAMFObjs = new ArrayList();
    private int receiveChunkSize = 128;
    private int sendChunkSize = 512;
    private String streamType = "netconnection";
    private List streamList = new ArrayList();
    private Map callbacks = new HashMap();
    private IoSession ioSession = null;
    private int netConnectionId = 0;
    private int clientId = 0;
    private IMediaStream targetStream = null;
    private int idleFrequency = 3000;
    private NetConnectionPingResult pingResults = new NetConnectionPingResult();
    private long pingRoundTripTime = 0L;
    private long connectTime;
    private long lastIdlePingTime = 0L;
    private boolean lastIdlePingWaiting = false;
    private Object lastIdlePingLock = new Object();
    private IOPerformanceCounter totalIOPerformance = new IOPerformanceCounter();
    private IOPerformanceCounter totalIOPerformanceLast = null;
    private IOPerformanceCounter mediaIOPerformance = new IOPerformanceCounter();
    private long nextConfirmBytesReceived = 625500L;
    private int objectEncoding = 0;
    private Map respAMFMap = new HashMap();
    private List publishStreams = new ArrayList();
    private INetConnectionPublisher publishHandler = null;
    private long lastValidateTime = 0L;
    private boolean isValidatingConnection = false;
    private long lastPingWriteId = -1L;

    public NetConnection(IApplicationInstance iApplicationInstance, int n) {
        this.appInstance = iApplicationInstance;
        this.netConnectionId = n;
        this.streams = new MediaStreamMap(this.appInstance);
        for (int i = 0; i <= 4; ++i) {
            this.respAMFObjs.add(null);
            this.reqAMFObjs.add(null);
        }
        this.respAMFObjs.set(3, new AMFObj(3, this.objectEncoding));
        this.respAMFObjs.set(4, new AMFObj(4, this.objectEncoding));
        VHost vHost = (VHost)this.appInstance.getVHost();
        this.idleFrequency = vHost.getNetConnectionIdleFrequency();
        this.connectTime = System.currentTimeMillis();
    }

    public ResponseFunctions getRespFunctions() {
        return this.respFunctions;
    }

    public void connect(String string, int n, int n2, INetConnectionCallResult iNetConnectionCallResult) {
        this.handshakeResult = iNetConnectionCallResult;
        VHost vHost = (VHost)this.appInstance.getVHost();
        this.ioSession = vHost.getNetConnectionConnection().connect(this, string, n, n2);
    }

    public void callConnect(INetConnectionCallResult iNetConnectionCallResult, AMFDataObj aMFDataObj, Object ... objectArray) {
        double d = this.callResults.add(iNetConnectionCallResult);
        int n = this.getSendChunkSize();
        byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 4, 1, 0, 0, 0, 0, (byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 0)};
        ResponseFunction responseFunction = new ResponseFunction(this);
        responseFunction.addBytes(byArray);
        this.respFunctions.add(responseFunction);
        ResponseFunction responseFunction2 = new ResponseFunction(this, this.getResponseAMFObj(4));
        responseFunction2.createConnectMessage("connect", d);
        responseFunction2.setSrc(0);
        responseFunction2.setTimecode(0L);
        responseFunction2.addBody(aMFDataObj);
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        if (aMFDataArray != null) {
            for (int i = 0; i < aMFDataArray.length; ++i) {
                responseFunction2.addBody(aMFDataArray[i]);
            }
        }
        this.respFunctions.add(responseFunction2);
    }

    public void call(String string, INetConnectionCallResult iNetConnectionCallResult, Object ... objectArray) {
        double d = 0.0;
        if (iNetConnectionCallResult != null) {
            d = this.callResults.add(iNetConnectionCallResult);
        }
        ResponseFunction responseFunction = new ResponseFunction(this, this.getResponseAMFObj(4));
        responseFunction.createDefaultMessage(string, d);
        responseFunction.setSrc(0);
        responseFunction.setTimecode(0L);
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        if (aMFDataArray != null) {
            for (int i = 0; i < aMFDataArray.length; ++i) {
                responseFunction.addBody(aMFDataArray[i]);
            }
        }
        WMSLoggerFactory.getLogger(NetConnection.class).debug("NetConnection: call[" + this.netConnectionId + ":" + this.clientId + "]: " + string);
        this.respFunctions.add(responseFunction);
    }

    public void call(String string, IMediaStream iMediaStream, INetConnectionCallResult iNetConnectionCallResult, Object ... objectArray) {
        double d = 0.0;
        if (iNetConnectionCallResult != null) {
            d = this.callResults.add(iNetConnectionCallResult);
        }
        ResponseFunction responseFunction = new ResponseFunction(this, this.getResponseAMFObj(4));
        responseFunction.createDefaultMessage(string, d);
        responseFunction.setSrc(iMediaStream.getSrc());
        responseFunction.setTimecode(0L);
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        if (aMFDataArray != null) {
            for (int i = 0; i < aMFDataArray.length; ++i) {
                responseFunction.addBody(aMFDataArray[i]);
            }
        }
        this.respFunctions.add(responseFunction);
    }

    public MediaStreamMap getStreams() {
        return this.streams;
    }

    public void setStreams(MediaStreamMap mediaStreamMap) {
        this.streams = mediaStreamMap;
    }

    public int getHandshake() {
        return this.handshake;
    }

    public void setHandshake(int n) {
        this.handshake = n;
    }

    public INetConnectionCallResult getHandshakeResult() {
        return this.handshakeResult;
    }

    public void setHandshakeResult(INetConnectionCallResult iNetConnectionCallResult) {
        this.handshakeResult = iNetConnectionCallResult;
    }

    public byte[] getLeftOverData() {
        return this.leftOverData;
    }

    public void setLeftOverData(byte[] byArray, int n, int n2) {
        this.leftOverData = new byte[n2];
        System.arraycopy(byArray, n, this.leftOverData, 0, n2);
    }

    public void clearLeftOverData() {
        this.leftOverData = null;
    }

    public boolean isLeftOverData() {
        return this.leftOverData != null;
    }

    public Map getPartialFunctions() {
        return this.partialFunctions;
    }

    public void setPartialFunctions(Map map) {
        this.partialFunctions.putAll(map);
    }

    public void clearPartialFunctions() {
        this.partialFunctions.clear();
    }

    public void addPartialFunction(Integer n, RequestFunction requestFunction) {
        this.partialFunctions.put(n, requestFunction);
    }

    public List getReqAMFObjs() {
        return this.reqAMFObjs;
    }

    public int getReceiveChunkSize() {
        return this.receiveChunkSize;
    }

    public void setReceiveChunkSize(int n) {
        this.receiveChunkSize = n;
    }

    public int getSendChunkSize() {
        return this.sendChunkSize;
    }

    public void setSendChunkSize(int n) {
        this.sendChunkSize = n;
    }

    public String getStreamType() {
        return this.streamType;
    }

    public void setStreamType(String string) {
        this.streamType = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStream(IMediaStream iMediaStream) {
        List list = this.streamList;
        synchronized (list) {
            this.streamList.add(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStream(IMediaStream iMediaStream) {
        List list = this.streamList;
        synchronized (list) {
            this.streamList.remove(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packetComplete() {
        List list = this.streamList;
        synchronized (list) {
            for (IMediaStream iMediaStream : this.streamList) {
                iMediaStream.packetComplete();
            }
        }
    }

    public NetConnectionCallResults getCallResults() {
        return this.callResults;
    }

    public void handleCallback(RequestFunction requestFunction) {
        String string;
        INetConnectionCallback iNetConnectionCallback;
        AMFDataList aMFDataList = requestFunction.getMessage();
        AMFData aMFData = aMFDataList.get(0);
        if (aMFData.getType() == 2 && (iNetConnectionCallback = (INetConnectionCallback)this.callbacks.get(string = (String)aMFData.getValue())) != null) {
            iNetConnectionCallback.onCallback(this, requestFunction, aMFDataList);
        }
    }

    public void unregisterCallback(String string) {
        this.callbacks.remove(string);
    }

    public void registerCallback(String string, INetConnectionCallback iNetConnectionCallback) {
        this.callbacks.put(string, iNetConnectionCallback);
    }

    public void close() {
        if (this.ioSession != null) {
            this.ioSession.close();
        }
        this.ioSession = null;
    }

    public IoSession getSession() {
        return this.ioSession;
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    public int getNetConnectionId() {
        return this.netConnectionId;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int n) {
        this.clientId = n;
    }

    public AMFObj getResponseAMFObj(int n) {
        return (AMFObj)this.respAMFObjs.get(n);
    }

    public IMediaStream getTargetStream() {
        return this.targetStream;
    }

    public void setTargetStream(IMediaStream iMediaStream) {
        this.targetStream = iMediaStream;
    }

    public INetConnectionIdle getIdleHandler() {
        return this.idleHandler;
    }

    public void setIdleHandler(INetConnectionIdle iNetConnectionIdle) {
        this.idleHandler = iNetConnectionIdle;
    }

    public int getIdleFrequency() {
        return this.idleFrequency;
    }

    public void setIdleFrequency(int n) {
        this.idleFrequency = n;
    }

    public int ping(INetConnectionPingResult iNetConnectionPingResult) {
        long l = System.currentTimeMillis() - this.connectTime;
        int n = (int)(l % 0x100000000L & 0xFFFFFFFFL);
        while (this.pingResults.exists(n)) {
            n = (int)(++l % 0x100000000L & 0xFFFFFFFFL);
        }
        ResponseFunction responseFunction = new ResponseFunction(this);
        byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 6, (byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 0)};
        responseFunction.addBytes(byArray);
        this.getRespFunctions().add(responseFunction);
        this.pingResults.add(l, n, iNetConnectionPingResult);
        return n;
    }

    public void handlePingResult(int n, boolean bl) {
        long l = System.currentTimeMillis() - this.connectTime;
        long l2 = this.pingResults.handleResult(this, n, bl);
        if (l2 > 0L) {
            this.pingRoundTripTime = l - l2;
        }
    }

    public void checkPingTimeout() {
        long l = System.currentTimeMillis() - this.connectTime;
        this.pingResults.checkPingTimeout(this, l);
    }

    public void resetConnection() {
        this.respAMFObjs.clear();
        this.reqAMFObjs.clear();
        for (int i = 0; i <= 4; ++i) {
            this.respAMFObjs.add(null);
            this.reqAMFObjs.add(null);
        }
        this.respAMFObjs.set(3, new AMFObj(3, this.objectEncoding));
        this.respAMFObjs.set(4, new AMFObj(4, this.objectEncoding));
        this.handshake = 0;
        this.clearLeftOverData();
        this.clearPartialFunctions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void doIdle() {
        if (this.ioSession != null) {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)this.ioSession.getAttribute("wmsSessionInfo");
            boolean bl = false;
            if (rtmpSessionInfo != null) {
                IoSession ioSession = this.ioSession;
                synchronized (ioSession) {
                    if (rtmpSessionInfo.getInHandler() > 0) {
                        rtmpSessionInfo.addMessageQueue(null);
                    } else {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.ioSession.getFilterChain().fireSessionIdle(this.ioSession, IdleStatus.BOTH_IDLE);
            }
            ((BaseIoSession)this.ioSession).increaseIdleCount(IdleStatus.BOTH_IDLE);
        }
    }

    public long getLastIdlePingTime() {
        return this.lastIdlePingTime;
    }

    public void setLastIdlePingTime(long l) {
        this.lastIdlePingTime = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLastIdlePing() {
        Object object = this.lastIdlePingLock;
        synchronized (object) {
            if (this.lastIdlePingTime == 0L) {
                this.lastIdlePingTime = System.currentTimeMillis();
            } else if (!this.lastIdlePingWaiting && System.currentTimeMillis() - this.lastIdlePingTime > 30000L) {
                this.lastIdlePingWaiting = true;
                class LastIdlePingResult
                implements INetConnectionPingResult {
                    LastIdlePingResult() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResult(INetConnection iNetConnection, long l, int n, boolean bl) {
                        Object object = NetConnection.this.lastIdlePingLock;
                        synchronized (object) {
                            NetConnection.this.lastIdlePingWaiting = false;
                            NetConnection.this.lastIdlePingTime = System.currentTimeMillis();
                        }
                    }
                }
                this.ping(new LastIdlePingResult());
            }
        }
    }

    public long getTotalInBytes() {
        return this.totalIOPerformance.getMessagesInBytes();
    }

    @NoMBean
    public IOPerformanceCounter addIOPerformance(IOPerformanceCounter iOPerformanceCounter) {
        IOPerformanceCounter iOPerformanceCounter2 = this.totalIOPerformance.clone();
        iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.totalIOPerformanceLast);
        this.totalIOPerformanceLast = iOPerformanceCounter2;
        return this.totalIOPerformance;
    }

    @NoMBean
    public IOPerformanceCounter getTotalIOPerformanceCounter() {
        return this.totalIOPerformance;
    }

    @NoMBean
    public long incrementTotalInBytes(long l) {
        long l2 = this.totalIOPerformance.incrementMessagesIn(l);
        return l2;
    }

    @NoMBean
    public long incrementTotalOutBytes(long l) {
        long l2 = this.totalIOPerformance.incrementMessagesOut(l);
        return l2;
    }

    @NoMBean
    public long incrementTotalLossBytes(long l, long l2) {
        return this.totalIOPerformance.incrementMessagesLoss(l, l2);
    }

    @NoMBean
    public long getNextConfirmBytesReceived() {
        return this.nextConfirmBytesReceived;
    }

    @NoMBean
    public void setNextConfirmBytesReceived(long l) {
        this.nextConfirmBytesReceived = l;
    }

    @NoMBean
    public long incrementNextConfirmBytesReceived() {
        this.nextConfirmBytesReceived += 625500L;
        return this.nextConfirmBytesReceived;
    }

    public boolean isObjectEncodingAMF3() {
        return this.objectEncoding != 0;
    }

    public boolean isObjectEncodingAMF0() {
        return this.objectEncoding == 0;
    }

    public void setObjectEncoding(int n) {
        this.objectEncoding = n;
        for (AMFObj aMFObj : this.respAMFObjs) {
            if (aMFObj == null) continue;
            aMFObj.setObjectEncoding(n);
        }
    }

    public int getObjectEncoding() {
        return this.objectEncoding;
    }

    @NoMBean
    public int getRespAFMIndex(IMediaStream iMediaStream) {
        int n = -1;
        try {
            Integer n2 = (Integer)this.respAMFMap.get(iMediaStream);
            if (n2 != null) {
                n = n2;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(NetConnection.class).error("unregisterPlayStream: " + exception.toString());
        }
        return n;
    }

    @NoMBean
    public AMFObj getRespAMFAudioObj(IMediaStream iMediaStream) {
        AMFObj aMFObj = null;
        try {
            int n = this.getRespAFMIndex(iMediaStream);
            if (n >= 0) {
                aMFObj = (AMFObj)this.respAMFObjs.get(n + 1);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(NetConnection.class).error("getRespAMFAudioObj: " + exception.toString());
        }
        return aMFObj;
    }

    @NoMBean
    public AMFObj getRespAMFVideoObj(IMediaStream iMediaStream) {
        AMFObj aMFObj = null;
        try {
            int n = this.getRespAFMIndex(iMediaStream);
            if (n >= 0) {
                aMFObj = (AMFObj)this.respAMFObjs.get(n + 2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(NetConnection.class).error("getRespAMFVideoObj: " + exception.toString());
        }
        return aMFObj;
    }

    @NoMBean
    public AMFObj getRespAMFDataObj(IMediaStream iMediaStream) {
        AMFObj aMFObj = null;
        try {
            int n = this.getRespAFMIndex(iMediaStream);
            if (n >= 0) {
                aMFObj = (AMFObj)this.respAMFObjs.get(n + 0);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(NetConnection.class).error("getRespAMFDataObj: " + exception.toString());
        }
        return aMFObj;
    }

    private void registerPublishStream(IMediaStream iMediaStream) {
        int n;
        if (this.respAMFMap.containsKey(iMediaStream)) {
            return;
        }
        boolean bl = false;
        for (n = 5; n <= this.respAMFObjs.size() - 3; n += 3) {
            if (this.respAMFObjs.get(n) != null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.respAMFObjs.add(null);
            this.respAMFObjs.add(null);
            this.respAMFObjs.add(null);
        }
        this.respAMFMap.put(iMediaStream, new Integer(n));
        this.respAMFObjs.set(n, new AMFObj(n, this.objectEncoding));
        this.respAMFObjs.set(n + 1, new AMFObj(n + 1, this.objectEncoding));
        this.respAMFObjs.set(n + 2, new AMFObj(n + 2, this.objectEncoding));
    }

    private void unregisterPublishStream(IMediaStream iMediaStream) {
        try {
            int n = this.getRespAFMIndex(iMediaStream);
            if (n >= 0) {
                this.respAMFObjs.set(n, null);
                this.respAMFObjs.set(n + 1, null);
                this.respAMFObjs.set(n + 2, null);
            }
            this.respAMFMap.remove(iMediaStream);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(NetConnection.class).error("unregisterPublishStream: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removePublishStreams(IMediaStream iMediaStream) {
        try {
            List list = this.publishStreams;
            synchronized (list) {
                int n = this.publishStreams.indexOf(iMediaStream);
                if (n >= 0) {
                    this.publishStreams.remove(n);
                }
                this.unregisterPublishStream(iMediaStream);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(NetConnection.class).error("removePublishStreams: " + exception.toString());
        }
    }

    @NoMBean
    public List getPublishStreams() {
        return this.publishStreams;
    }

    @NoMBean
    public void addPublishStreams(IMediaStream iMediaStream) {
        this.publishStreams.add(iMediaStream);
        this.registerPublishStream(iMediaStream);
    }

    @NoMBean
    public INetConnectionPublisher getPublishHandler() {
        return this.publishHandler;
    }

    @NoMBean
    public void setPublishHandler(INetConnectionPublisher iNetConnectionPublisher) {
        this.publishHandler = iNetConnectionPublisher;
    }

    public boolean isValidatingConnection() {
        return this.isValidatingConnection;
    }

    @NoMBean
    public void setValidatingConnection(boolean bl) {
        this.isValidatingConnection = bl;
    }

    public long getLastValidateTime() {
        return this.lastValidateTime;
    }

    public void setLastValidateTime(long l) {
        this.lastValidateTime = l;
    }

    @NoMBean
    public IOPerformanceCounter getMediaIOPerformanceCounter() {
        return this.mediaIOPerformance;
    }

    @NoMBean
    public long incrementMediaOutBytes(long l, long l2) {
        return this.mediaIOPerformance.incrementMessagesOut(l, l2);
    }

    @NoMBean
    public long incrementMediaLossBytes(long l, long l2) {
        return this.mediaIOPerformance.incrementMessagesLoss(l, l2);
    }

    @NoMBean
    public long incrementMediaInBytes(long l) {
        return this.mediaIOPerformance.incrementMessagesIn(l);
    }

    public void sendMediaStreamBufferTime(IMediaStream iMediaStream, int n) {
        int n2 = iMediaStream == null ? 0 : iMediaStream.getSrc();
        byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 10, 4, 0, 0, 0, 0, 0, 3, (byte)(0xFF & n2 >> 24), (byte)(0xFF & n2 >> 16), (byte)(0xFF & n2 >> 8), (byte)(0xFF & n2 >> 0), (byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 0)};
        ResponseFunction responseFunction = new ResponseFunction(this);
        responseFunction.addBytes(byArray);
        this.respFunctions.add(responseFunction);
    }

    public long getLastPingWriteId() {
        return this.lastPingWriteId;
    }

    public void setLastPingWriteId(long l) {
        this.lastPingWriteId = l;
    }
}

