/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.netconnection;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.netconnection.NetConnectionSessionHandler;
import com.wowza.wms.server.RtmpServerProtocolCodecFactory;
import com.wowza.wms.vhost.VHost;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;

public class NetConnectionConnection {
    private VHost vhost = null;
    private SocketConnector connector = null;
    private SocketConnectorConfig cfg = null;
    private Object lock = new Object();

    public NetConnectionConnection(VHost vHost) {
        this.vhost = vHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketConnector getConnector() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connector == null) {
                this.connector = new SocketConnector(this.vhost.getNetConnectionProcessorCount(), this.vhost.getThreadPool().getExecutor());
                this.cfg = new SocketConnectorConfig();
                this.vhost.getNetConnectionHostPortConfig().configureSocketConnector(this.cfg);
                this.cfg.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new RtmpServerProtocolCodecFactory()));
            }
        }
        return this.connector;
    }

    public IoSession connect(INetConnection iNetConnection, String string, int n, int n2) {
        return this.connect(iNetConnection, string, n, n2, null);
    }

    public IoSession connect(INetConnection iNetConnection, String string, int n, int n2, IoHandlerAdapter ioHandlerAdapter) {
        SocketConnector socketConnector = this.getConnector();
        IoSession ioSession = null;
        try {
            ioHandlerAdapter = ioHandlerAdapter == null ? new NetConnectionSessionHandler(iNetConnection) : ioHandlerAdapter;
            int n3 = n2 / 1000;
            if (n3 == 0) {
                n3 = 1;
            }
            this.cfg.setConnectTimeout(n3);
            ConnectFuture connectFuture = socketConnector.connect((SocketAddress)new InetSocketAddress(string, n), (IoHandler)ioHandlerAdapter, (IoServiceConfig)this.cfg);
            connectFuture.join();
            ioSession = connectFuture.getSession();
        }
        catch (RuntimeIOException runtimeIOException) {
            WMSLoggerFactory.getLogger(NetConnectionConnection.class).warn("Failed to connect: " + runtimeIOException.toString());
            runtimeIOException.printStackTrace();
            ioSession = null;
        }
        return ioSession;
    }
}

