/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.request;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;

public class RequestProcessData {
    public static final long TIMEROLLOVERSLOP = 250L;

    private static void killConnection(IVHost iVHost, Client client) {
        WMSLoggerFactory.getLogger(RequestProcessData.class).error("Data format incorrect, killing client connection.");
        if (iVHost != null && client != null) {
            iVHost.removeClient(client.getClientId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processNextRequest(IVHost iVHost, Client client, ByteBuffer byteBuffer, int n, int n2, List list) {
        boolean bl = false;
        try {
            Object object2;
            ContentChunk[] contentChunkArray;
            byte[] byArray = client.getLeftOverData();
            int n3 = client.getLeftOverMissing();
            client.clearLeftOverData();
            byteBuffer.position(0);
            int n4 = n;
            byte[] byArray2 = byteBuffer.array();
            if (byArray != null) {
                if (n3 > 0 && n3 <= n2) {
                    contentChunkArray = new ContentChunk[n3 < n2 ? 2 : 1];
                    contentChunkArray[0] = new ContentChunk();
                    contentChunkArray[0].myDataLen = byArray.length + n3;
                    contentChunkArray[0].myData = new byte[contentChunkArray[0].myDataLen];
                    System.arraycopy(byArray, 0, contentChunkArray[0].myData, 0, byArray.length);
                    System.arraycopy(byArray2, n4, contentChunkArray[0].myData, byArray.length, n3);
                    if (contentChunkArray.length > 1) {
                        contentChunkArray[1] = new ContentChunk();
                        contentChunkArray[1].myDataLen = n4 + n2;
                        contentChunkArray[1].myData = byArray2;
                        contentChunkArray[1].index = n4 + n3;
                    }
                } else {
                    contentChunkArray = new ContentChunk[]{new ContentChunk()};
                    contentChunkArray[0].myDataLen = byArray.length + n2;
                    contentChunkArray[0].myData = new byte[contentChunkArray[0].myDataLen];
                    System.arraycopy(byArray, 0, contentChunkArray[0].myData, 0, byArray.length);
                    System.arraycopy(byArray2, n4, contentChunkArray[0].myData, byArray.length, n2);
                }
            } else {
                contentChunkArray = new ContentChunk[]{new ContentChunk()};
                contentChunkArray[0].myDataLen = n4 + n2;
                contentChunkArray[0].myData = byArray2;
                contentChunkArray[0].index = n4;
            }
            HashMap hashMap = new HashMap();
            Map map = client.getPartialFunctions();
            for (Object object2 : map.keySet()) {
                hashMap.put(object2, map.get(object2));
                list.add(map.get(object2));
            }
            client.clearPartialFunctions();
            object2 = client.getReqAMFObjs();
            IApplicationInstance iApplicationInstance = client.getAppInstance();
            MediaStreamMap mediaStreamMap = null;
            if (iApplicationInstance != null) {
                mediaStreamMap = iApplicationInstance.getStreams();
            }
            int n5 = client.getReceiveChunkSize();
            IMediaStream iMediaStream = null;
            int n6 = -1;
            AMFObj aMFObj = null;
            int n7 = -1;
            int n8 = -1;
            int n9 = 0;
            for (int i = 0; i < contentChunkArray.length; ++i) {
                int n10;
                int n11 = contentChunkArray[i].index;
                byte[] byArray3 = contentChunkArray[i].myData;
                int n12 = contentChunkArray[i].myDataLen;
                do {
                    boolean bl2;
                    int n13;
                    int n14;
                    n8 = n11;
                    n9 = 0;
                    int n15 = 1;
                    switch (byArray3[n11] & 0xC0) {
                        case 0: {
                            n15 = 12;
                            break;
                        }
                        case 64: {
                            n15 = 8;
                            break;
                        }
                        case 128: {
                            n15 = 4;
                            break;
                        }
                        case 192: {
                            n15 = 1;
                            break;
                        }
                        default: {
                            WMSLoggerFactory.getLogger(RequestProcessData.class).error("Bad header (" + (byArray3[n11] & 0xC0) + ")");
                            if (!bl) {
                                bl = true;
                            }
                            RequestProcessData.killConnection(iVHost, client);
                        }
                    }
                    int n16 = 0;
                    int n17 = byArray3[n11] & 0x3F;
                    if (n17 <= 1) {
                        if (++n11 + (n16 += n17 + 1) > n12) {
                            n11 = n8;
                            break;
                        }
                        int n18 = BufferUtils.byteArrayToInt(byArray3, n11, n16, true);
                        n17 = 64 + n18;
                        n11 += n16 - 1;
                    }
                    if (n7 != n17) {
                        AMFObj aMFObj2 = aMFObj = n17 < object2.size() ? (AMFObj)object2.get(n17) : null;
                        if (aMFObj == null) {
                            aMFObj = new AMFObj(n17, client.getObjectEncoding());
                            while (object2.size() <= n17) {
                                object2.add(null);
                            }
                            object2.set(n17, aMFObj);
                        }
                        n7 = n17;
                    }
                    if (n11 + n15 + n16 > n12) {
                        n11 = n8;
                        break;
                    }
                    ++n11;
                    long l = -1L;
                    if (n15 >= 4) {
                        l = BufferUtils.byteArrayToInt(byArray3, n11, 3, false);
                        aMFObj.setLongTimecode(l == 0xFFFFFFL);
                        n11 += 3;
                    }
                    if (n15 >= 8) {
                        n14 = BufferUtils.byteArrayToInt(byArray3, n11, 3, false);
                        aMFObj.setSize(n14);
                        aMFObj.setType(0xFF & byArray3[n11 += 3]);
                        ++n11;
                    }
                    if (n15 == 12) {
                        aMFObj.setSrc(BufferUtils.byteArrayToInt(byArray3, n11, 4, true));
                        n11 += 4;
                    }
                    if (aMFObj.isLongTimecode()) {
                        if (n11 + 4 > n12) {
                            n11 = n8;
                            break;
                        }
                        l = BufferUtils.byteArrayToLong(byArray3, n11, 4, false);
                        n11 += 4;
                    }
                    n14 = aMFObj.getSrc();
                    int n19 = aMFObj.getType();
                    n10 = n5;
                    if (n15 >= 4) {
                        if (!aMFObj.isByteContainerEmpty()) {
                            WMSLoggerFactory.getLogger(RequestProcessData.class).error("packetSizeReset: " + n15 + ":" + aMFObj.getByteContainerLevel());
                            if (!bl) {
                                bl = true;
                            }
                            RequestProcessData.killConnection(iVHost, client);
                        }
                        aMFObj.setByteContainerLevel(0);
                    }
                    if ((n13 = aMFObj.getSize() - aMFObj.getByteContainerLevel()) < 0) {
                        WMSLoggerFactory.getLogger(RequestProcessData.class).error("Bad block size: " + n13);
                        if (!bl) {
                            bl = true;
                        }
                        RequestProcessData.killConnection(iVHost, client);
                        n13 = 0;
                    }
                    if (n10 > n13) {
                        n10 = n13;
                    }
                    if (n11 + n10 > n12) {
                        n9 = n10 - (n12 - n11);
                        n11 = n8;
                        break;
                    }
                    if (l == -1L) {
                        l = aMFObj.getTimecode();
                    } else if (n15 < 12 && !aMFObj.isLongTimecode()) {
                        aMFObj.setTimecode(l);
                    }
                    boolean bl3 = aMFObj.isByteContainerEmpty();
                    if (bl3) {
                        long l2 = aMFObj.getAbsTimecode();
                        String string = "";
                        if (aMFObj.isLongTimecode()) {
                            aMFObj.setAbsTimecodeLong(l);
                            string = "long";
                        } else if (n15 == 12) {
                            long l3 = aMFObj.getAbsTimecode();
                            long l4 = l3 & 0xFFFFFFFFFF000000L;
                            long l5 = l3 & 0xFFFFFFL;
                            if (l4 > 0L && l5 <= 250L && l >= 0xFFFF06L) {
                                long l6 = l4 - 0x1000000L + l;
                                aMFObj.setAbsTimecodeLong(l6);
                                string = "weird";
                                WMSLoggerFactory.getLogger(RequestProcessData.class).warn("RequestProcessData: timecode backtrack: ovfl:" + l4 + " short:" + l5 + " new:" + l + " adj:" + l6);
                            } else {
                                aMFObj.setAbsTimecodeShort(l);
                                if (l2 == 0L) {
                                    aMFObj.setTimecode(l);
                                }
                                string = "short";
                            }
                        } else {
                            aMFObj.incAbsTimecode(l);
                            string = "inc";
                        }
                    }
                    aMFObj.incByteContainerLevel(n10);
                    boolean bl4 = aMFObj.isByteContainerFull();
                    if (bl4) {
                        aMFObj.setByteContainerLevel(0);
                        aMFObj.setLongTimecode(false);
                    }
                    if ((n19 == 8 || n19 == 9 || n19 == 18 || n19 == 15) && n14 > 0) {
                        IClient iClient;
                        if (n14 != n6) {
                            iMediaStream = mediaStreamMap.getStream(client, n14);
                        }
                        if (iMediaStream != null && (iClient = iMediaStream.getClient()) != null && iClient.getClientId() != client.getClientId()) {
                            iMediaStream = null;
                        }
                        if (iMediaStream != null) {
                            n6 = n14;
                            int n20 = aMFObj.getSize();
                            if (n19 == 8) {
                                if (bl3) {
                                    iMediaStream.setAudioSize(n20);
                                    iMediaStream.setAudioTC(aMFObj.getAbsTimecode());
                                    iMediaStream.setHeaderSize(n15);
                                    iMediaStream.startAudioPacket();
                                }
                                iMediaStream.addAudioData(byArray3, n11, n10);
                            } else if (n19 == 9) {
                                if (bl3) {
                                    iMediaStream.setVideoSize(n20);
                                    iMediaStream.setVideoTC(aMFObj.getAbsTimecode());
                                    iMediaStream.setHeaderSize(n15);
                                    iMediaStream.startVideoPacket();
                                }
                                iMediaStream.addVideoData(byArray3, n11, n10);
                            } else if (n19 == 18 || n19 == 15) {
                                if (bl3) {
                                    iMediaStream.setDataType(n19);
                                    iMediaStream.setDataSize(n20);
                                    iMediaStream.setDataTC(aMFObj.getAbsTimecode());
                                    iMediaStream.setHeaderSize(n15);
                                    iMediaStream.startDataPacket();
                                }
                                iMediaStream.addDataData(byArray3, n11, n10);
                            }
                            if (bl3) {
                                int n21 = n20 + n15 + n20 / n5;
                                client.incrementMediaInBytes(n21);
                                iMediaStream.incrementMediaInBytes(n21);
                            }
                        } else {
                            n6 = -1;
                        }
                    }
                    if (n19 == 8 || n19 == 9) continue;
                    if (n19 == 1) {
                        n5 = BufferUtils.byteArrayToInt(byArray3, n11);
                        client.setReceiveChunkSize(n5);
                        continue;
                    }
                    if (n19 == 3) {
                        int n22 = BufferUtils.byteArrayToInt(byArray3, n11);
                        continue;
                    }
                    if (n19 == 4) {
                        Object object3;
                        int n23 = BufferUtils.byteArrayToInt(byArray3, n11, 2);
                        if (n23 == 3) {
                            int n24 = BufferUtils.byteArrayToInt(byArray3, n11 + 2, 4);
                            int n25 = BufferUtils.byteArrayToInt(byArray3, n11 + 6, 4);
                            if (n24 == 0) {
                                client.setBufferTime(n25);
                                continue;
                            }
                            object3 = new AMFDataList();
                            ((AMFDataList)object3).add(new AMFDataItem("setBufferTime"));
                            ((AMFDataList)object3).add(new AMFDataItem(0.0));
                            ((AMFDataList)object3).add(new AMFDataItem());
                            ((AMFDataList)object3).add(new AMFDataItem((double)n25));
                            byte[] byArray4 = ((AMFDataList)object3).serialize();
                            RequestFunction requestFunction = new RequestFunction();
                            requestFunction.setSize(byArray4.length);
                            requestFunction.setSrc(n24);
                            requestFunction.setType(20);
                            requestFunction.setTimecode(aMFObj.getAbsTimecode());
                            requestFunction.setWmsNumber(n17);
                            requestFunction.addData(byArray4, 0, byArray4.length);
                            list.add(requestFunction);
                            continue;
                        }
                        if (n23 == 6) {
                            int n26 = BufferUtils.byteArrayToInt(byArray3, n11 + 2, 4);
                            byte[] byArray5 = new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 7, (byte)(0xFF & n26 >> 24), (byte)(0xFF & n26 >> 16), (byte)(0xFF & n26 >> 8), (byte)(0xFF & n26)};
                            object3 = new ResponseFunction(client);
                            ((ResponseFunction)object3).addBytes(byArray5);
                            client.getRespFunctions().add((ResponseFunction)object3);
                            continue;
                        }
                        if (n23 != 7) continue;
                        int n27 = BufferUtils.byteArrayToInt(byArray3, n11 + 2, 4);
                        client.handlePingResult(n27, true);
                        continue;
                    }
                    if (n19 != 20 && n19 != 17 && n19 != 18 && n19 != 15 && n19 != 19 && n19 != 16) continue;
                    Integer n28 = new Integer(n17);
                    RequestFunction requestFunction = (RequestFunction)hashMap.get(n28);
                    if (aMFObj.getSize() <= 0) {
                        WMSLoggerFactory.getLogger(RequestProcessData.class).error("Zero sized function (client): type:" + n19 + " size:" + aMFObj.getSize() + " index:" + n11);
                        if (!bl) {
                            bl = true;
                        }
                    }
                    boolean bl5 = bl2 = requestFunction == null;
                    if (!bl2) {
                        bl2 = bl3;
                    }
                    if (bl2) {
                        requestFunction = new RequestFunction();
                        requestFunction.setSize(aMFObj.getSize());
                        requestFunction.setSrc(aMFObj.getSrc());
                        requestFunction.setType(n19);
                        requestFunction.setTimecode(aMFObj.getAbsTimecode());
                        requestFunction.setWmsNumber(n17);
                        requestFunction.setHeaderSize(n15);
                        hashMap.put(n28, requestFunction);
                        if (aMFObj.getSize() > 0) {
                            list.add(requestFunction);
                        }
                    }
                    if (requestFunction != null) {
                        requestFunction.addData(byArray3, n11, n10);
                        if (!bl4) continue;
                        hashMap.remove(n28);
                        continue;
                    }
                    WMSLoggerFactory.getLogger(RequestProcessData.class).error("Function missing");
                    if (bl) continue;
                    bl = true;
                } while ((n11 += n10) < n12);
                if (n11 >= n12) continue;
                client.setLeftOverData(byArray3, n11, n12 - n11, n9);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RequestFunction requestFunction = (RequestFunction)iterator.next();
                if (!requestFunction.isPartial()) continue;
                client.addPartialFunction(new Integer(requestFunction.getWmsNumber()), requestFunction);
                iterator.remove();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestProcessData.class).error("processNextRequest: error: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            byteBuffer.release();
        }
    }

    public static class ContentChunk {
        public byte[] myData = null;
        public int myDataLen = 0;
        public int index = 0;
    }
}

