/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizerWrapper;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtsp.RTSPCore;
import java.net.SocketAddress;
import java.util.SortedMap;
import java.util.TreeMap;

public class RTPDePacketizerWrapperPacketSorter
implements IRTPDePacketizerWrapper {
    private IRTPDePacketizer rtpDePacketizer = null;
    private RTPSequence seq = new RTPSequence();
    private PacketSender packetSender = null;
    private SortedMap<Long, PacketItem> packetMap = new TreeMap<Long, PacketItem>();
    private long startRTTimecode = -1L;
    private long startRTPTimecode = -1L;
    private int rtpDePacketizerPacketSorterBufferTime = 500;
    private int rtpDePacketizerPacketSorterFlushTime = 10;
    private boolean rtpDePacketizerPacketSorterLogPacketLoss = false;
    private WMSProperties properties = new WMSProperties();

    public WMSProperties getProperties() {
        return this.rtpDePacketizer.getProperties();
    }

    public void setDePacketizer(IRTPDePacketizer iRTPDePacketizer) {
        this.rtpDePacketizer = iRTPDePacketizer;
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        return this.rtpDePacketizer.canHandle(rTPTrack);
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        this.rtpDePacketizer.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        int n3 = rTPTrack.getTimescale();
        long l2 = Math.round((double)l * 1000.0 / (double)n3);
        if (this.startRTTimecode == -1L) {
            this.startRTTimecode = System.currentTimeMillis();
            this.startRTPTimecode = l2;
            this.packetSender = new PacketSender();
            this.packetSender.setDaemon(true);
            this.packetSender.setName("RTPDePacketizerWrapperPacketSorter");
            this.packetSender.start();
        }
        PacketItem packetItem = new PacketItem();
        packetItem.socketAddr = socketAddress;
        packetItem.rtpTrack = rTPTrack;
        packetItem.bytes = byArray;
        packetItem.offset = n;
        packetItem.len = n2;
        packetItem.adjTimecode = l2;
        packetItem.seq = this.seq.longValue();
        SortedMap<Long, PacketItem> sortedMap = this.packetMap;
        synchronized (sortedMap) {
            this.packetMap.put(new Long(this.seq.longValue()), packetItem);
        }
    }

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        this.rtpDePacketizer.init(rTPContext, rTPDePacketizerItem);
        this.rtpDePacketizerPacketSorterBufferTime = this.properties.getPropertyInt("rtpDePacketizerPacketSorterBufferTime", this.rtpDePacketizerPacketSorterBufferTime);
        this.rtpDePacketizerPacketSorterFlushTime = this.properties.getPropertyInt("rtpDePacketizerPacketSorterFlushTime", this.rtpDePacketizerPacketSorterFlushTime);
        this.rtpDePacketizerPacketSorterLogPacketLoss = this.properties.getPropertyBoolean("rtpDePacketizerPacketSorterLogPacketLoss", this.rtpDePacketizerPacketSorterLogPacketLoss);
        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPacketSorter.init: rtpDePacketizerPacketSorterBufferTime: " + this.rtpDePacketizerPacketSorterBufferTime);
        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPacketSorter.init: rtpDePacketizerPacketSorterFlushTime: " + this.rtpDePacketizerPacketSorterFlushTime);
        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPacketSorter.init: rtpDePacketizerPacketSorterLogPacketLoss: " + this.rtpDePacketizerPacketSorterLogPacketLoss);
    }

    public void setProperties(WMSProperties wMSProperties) {
        this.rtpDePacketizer.setProperties(wMSProperties);
        this.properties.putAll(wMSProperties);
    }

    public void shutdown(RTPTrack rTPTrack) {
        this.rtpDePacketizer.shutdown(rTPTrack);
        if (this.packetSender != null) {
            this.packetSender.quit();
        }
        this.packetSender = null;
    }

    public void startup(RTPTrack rTPTrack) {
        this.rtpDePacketizer.startup(rTPTrack);
    }

    class PacketItem {
        public SocketAddress socketAddr = null;
        public RTPTrack rtpTrack = null;
        public byte[] bytes = null;
        public int offset = 0;
        public int len = 0;
        public long adjTimecode = 0L;
        public long seq = 0L;

        PacketItem() {
        }
    }

    class PacketSender
    extends Thread {
        private boolean running = true;
        private boolean quit = false;
        private long lastPacketSeq = -1L;

        PacketSender() {
        }

        public synchronized void quit() {
            this.quit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object;
                        long l = System.currentTimeMillis();
                        long l2 = RTPDePacketizerWrapperPacketSorter.this.startRTPTimecode + (l - RTPDePacketizerWrapperPacketSorter.this.startRTTimecode);
                        while (true) {
                            Object object2;
                            object = null;
                            Object object3 = RTPDePacketizerWrapperPacketSorter.this.packetMap;
                            synchronized (object3) {
                                if (RTPDePacketizerWrapperPacketSorter.this.packetMap.size() != 0) {
                                    object2 = (Long)RTPDePacketizerWrapperPacketSorter.this.packetMap.firstKey();
                                    PacketItem packetItem = (PacketItem)RTPDePacketizerWrapperPacketSorter.this.packetMap.get(object2);
                                    if (packetItem.adjTimecode + (long)RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterBufferTime < l2) {
                                        object = packetItem;
                                        RTPDePacketizerWrapperPacketSorter.this.packetMap.remove(object2);
                                    }
                                }
                                if (object == null) break;
                            }
                            ((PacketItem)object).rtpTrack.getRTPStream().touch();
                            object3 = ((PacketItem)object).rtpTrack.getRTPStream().getStreamLock();
                            object3.writeLock().lock();
                            try {
                                RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizer.handleRTPPacket(((PacketItem)object).socketAddr, ((PacketItem)object).rtpTrack, ((PacketItem)object).bytes, ((PacketItem)object).offset, ((PacketItem)object).len);
                                if (RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterLogPacketLoss) {
                                    if (this.lastPacketSeq != -1L && ((PacketItem)object).seq != this.lastPacketSeq + 1L) {
                                        WMSLoggerFactory.getLogger(RTSPCore.class).warn("packetLoss[" + ((PacketItem)object).rtpTrack.getTrackId() + "]: last:" + this.lastPacketSeq + " curr:" + ((PacketItem)object).seq);
                                    }
                                    this.lastPacketSeq = ((PacketItem)object).seq;
                                }
                            }
                            catch (Exception exception) {
                                WMSLoggerFactory.getLogger(RTSPCore.class).warn("HandleRTPMessage.PacketSender.run: " + exception.toString());
                                exception.printStackTrace();
                            }
                            finally {
                                object3.writeLock().unlock();
                            }
                            object2 = this;
                            synchronized (object2) {
                                if (this.quit) {
                                    this.running = false;
                                    break;
                                }
                            }
                        }
                        object = this;
                        synchronized (object) {
                            if (this.quit) {
                                this.running = false;
                                return;
                            }
                        }
                        PacketSender.sleep(RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterFlushTime);
                        object = this;
                        synchronized (object) {
                            if (this.quit) {
                                this.running = false;
                                return;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error("RTPDePacketizerWrapperPacketSorter.PacketSender.run: " + exception.toString());
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

