/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BitReader;
import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.RTPPacketCodecConfigInfo;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentListReader;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.RTPUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPPacket {
    private List<RTPPacketFragment> fragments = new ArrayList<RTPPacketFragment>();
    private long seq = 0L;
    private long timecode = 0L;
    private long timeoffset = 0L;
    private int size = 0;
    private int type = 9;
    private int codec = 7;
    private int frameType = 0;
    protected boolean debugLog = false;
    private int nalUnitFilter = -1;
    private static long saveStartTimecode = -1L;
    private static boolean wroteVideoConfig = false;
    private static boolean wroteAudioConfig = false;

    public RTPPacket() {
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(boolean bl) {
        this.debugLog = bl;
    }

    public RTPPacket(long l, long l2) {
        this.seq = l;
        this.timecode = l2;
    }

    public List<RTPPacketFragment> getFragments() {
        return this.fragments;
    }

    public long getSeq() {
        return this.seq;
    }

    public void setSeq(long l) {
        this.seq = l;
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecode(long l) {
        this.timecode = l;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int n) {
        this.codec = n;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public void setFrameType(int n) {
        this.frameType = n;
    }

    public void addFragment(RTPPacketFragment rTPPacketFragment) {
        this.fragments.add(rTPPacketFragment);
        this.size += rTPPacketFragment.size();
    }

    public void clearFragments() {
        this.fragments.clear();
        this.size = 0;
    }

    public long getTimeoffset() {
        return this.timeoffset;
    }

    public void setTimeoffset(long l) {
        this.timeoffset = l;
    }

    public void write(RTPTrack rTPTrack, long l) {
        this.write(rTPTrack, l, false);
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.size];
        int n = 0;
        for (RTPPacketFragment rTPPacketFragment : this.fragments) {
            if (byArray == null) continue;
            System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, n, rTPPacketFragment.getLen());
            n += rTPPacketFragment.getLen();
        }
        return byArray;
    }

    public RTPPacketCodecConfigInfo getH264CodecConfigInfo(RTPTrack rTPTrack) {
        RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo = null;
        byte[] byArray = new byte[5];
        int n = this.getSize();
        RTPPacketFragmentListReader rTPPacketFragmentListReader = new RTPPacketFragmentListReader(this.fragments, n);
        while (rTPPacketFragmentListReader.remaining() >= 5) {
            byte[] byArray2;
            rTPPacketFragmentListReader.get(byArray);
            int n2 = BufferUtils.byteArrayToInt(byArray, 0, 4);
            byte by = byArray[4];
            int n3 = by & 0x1F;
            int n4 = 0;
            if (n2 > 1 && (n3 == 7 || n3 == 8)) {
                if (rTPPacketFragmentListReader.remaining() >= n2 - 1 - n4) {
                    byArray2 = new byte[n2];
                    byArray2[0] = byArray[4];
                    n4 = n2 - 1;
                    rTPPacketFragmentListReader.get(byArray2, 1, n4);
                    if (rTPPacketCodecConfigInfo == null) {
                        rTPPacketCodecConfigInfo = new RTPPacketCodecConfigInfo();
                    }
                    if (n3 == 7) {
                        rTPPacketCodecConfigInfo.sps = byArray2;
                    } else if (n3 == 8) {
                        if (rTPPacketCodecConfigInfo.ppss == null) {
                            rTPPacketCodecConfigInfo.ppss = new ArrayList<byte[]>();
                        }
                        rTPPacketCodecConfigInfo.ppss.add(byArray2);
                    }
                }
            } else if (n2 > 1 && n3 == 9 && rTPPacketFragmentListReader.remaining() >= n2 - 1 - n4) {
                byArray2 = new byte[n2];
                byArray2[0] = byArray[4];
                rTPPacketFragmentListReader.get(byArray2, 1, n4 += n2 - 1);
                AudDecode audDecode = this.decodeAud(byArray2, 3, byArray2.length - 3);
                if (audDecode.isKeyFrame) {
                    this.frameType = 1;
                }
                if (audDecode.codecConfigInfo != null) {
                    rTPPacketCodecConfigInfo = audDecode.codecConfigInfo;
                }
            }
            if (rTPPacketFragmentListReader.remaining() < n2 - 1 - n4) break;
            rTPPacketFragmentListReader.skip(n2 - 1 - n4);
            if (rTPPacketFragmentListReader.remaining() != 0) continue;
            break;
        }
        if (rTPPacketCodecConfigInfo != null) {
            RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo2;
            if (rTPTrack != null && (rTPPacketCodecConfigInfo.sps == null || rTPPacketCodecConfigInfo.ppss == null) && (rTPPacketCodecConfigInfo2 = rTPTrack.decodeParameterSets()) != null) {
                if (rTPPacketCodecConfigInfo.sps == null) {
                    rTPPacketCodecConfigInfo.sps = rTPPacketCodecConfigInfo2.sps;
                }
                if (rTPPacketCodecConfigInfo.ppss == null) {
                    rTPPacketCodecConfigInfo.ppss = rTPPacketCodecConfigInfo2.ppss;
                }
            }
            if (rTPPacketCodecConfigInfo.sps == null || rTPPacketCodecConfigInfo.ppss == null) {
                rTPPacketCodecConfigInfo = null;
            }
        }
        return rTPPacketCodecConfigInfo;
    }

    public void decodeAudNALUnit(AudDecode audDecode, byte[] byArray, int n, int n2) {
        if (n2 >= 1) {
            int n3 = byArray[n] & 0x1F;
            if (n3 == 5) {
                audDecode.isKeyFrame = true;
            } else if (n3 == 7 || n3 == 8) {
                if (audDecode.codecConfigInfo == null) {
                    audDecode.codecConfigInfo = new RTPPacketCodecConfigInfo();
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                if (n3 == 7) {
                    audDecode.codecConfigInfo.sps = byArray2;
                } else if (n3 == 8) {
                    if (audDecode.codecConfigInfo.ppss == null) {
                        audDecode.codecConfigInfo.ppss = new ArrayList<byte[]>();
                    }
                    audDecode.codecConfigInfo.ppss.add(byArray2);
                }
            } else if (n3 == 1) {
                byte[] byArray3 = new byte[20];
                int n4 = 0;
                for (int i = 1; i < byArray3.length + 1; ++i) {
                    if (i >= 2 && byArray[i] == 3 && byArray[i - 1] == 0 && byArray[i - 2] == 0) continue;
                    byArray3[n4] = byArray[i];
                    ++n4;
                }
                BitReader bitReader = new BitReader(byArray3, n4);
                int n5 = bitReader.readExpGolomb();
                int n6 = bitReader.readExpGolomb();
                if (n6 == 2 || n6 == 7) {
                    audDecode.isKeyFrame = true;
                }
            }
        }
    }

    public AudDecode decodeAud(byte[] byArray, int n, int n2) {
        AudDecode audDecode = new AudDecode();
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < n2 - 3; ++i) {
            if (byArray[n + i] != 0 || byArray[n + i + 1] != 0 || byArray[n + i + 2] != 1) continue;
            if (n4 >= 0) {
                ++n3;
                this.decodeAudNALUnit(audDecode, byArray, n + n4, i - n4);
            }
            n4 = i + 3;
        }
        if (n4 > 0) {
            ++n3;
            this.decodeAudNALUnit(audDecode, byArray, n + n4, n2 - n4);
        }
        return audDecode;
    }

    public String nalUnitTypeToStr(int n) {
        String string = "" + n;
        switch (n) {
            case 1: {
                string = "SLICE";
                break;
            }
            case 2: {
                string = "DPA";
                break;
            }
            case 3: {
                string = "DPB";
                break;
            }
            case 4: {
                string = "DPC";
                break;
            }
            case 5: {
                string = "IDR_SLICE";
                break;
            }
            case 6: {
                string = "SEI";
                break;
            }
            case 7: {
                string = "SPS";
                break;
            }
            case 8: {
                string = "PPS";
                break;
            }
            case 9: {
                string = "AUD";
                break;
            }
            case 10: {
                string = "END_SEQUENCE";
                break;
            }
            case 11: {
                string = "END_STREAM";
                break;
            }
            case 12: {
                string = "FILLER_DATA";
                break;
            }
            case 13: {
                string = "SPS_EXT";
                break;
            }
            case 19: {
                string = "AUXILIARY_SLICE";
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(RTPTrack rTPTrack, long l, boolean bl) {
        if (bl) {
            return;
        }
        try {
            int n;
            int n2;
            byte[] byArray;
            byte[] byArray2 = null;
            IMediaStream iMediaStream = rTPTrack.getRTPStream().getStream();
            boolean bl2 = true;
            if (this.type == 9) {
                if (this.codec == 7) {
                    void var12_16;
                    int n3;
                    int n4;
                    if (this.nalUnitFilter < 0) {
                        this.nalUnitFilter = iMediaStream != null ? iMediaStream.getProperties().getPropertyInt("nalUnitFilter", 0) : 0;
                    }
                    this.frameType = 2;
                    byte[] byArray3 = new byte[5];
                    byArray = new byte[20];
                    byte[] byArray4 = new byte[20];
                    int n5 = this.getSize();
                    Object var12_15 = null;
                    n2 = 0;
                    ArrayList<RTPPacketFragment> arrayList = this.nalUnitFilter > 0 ? new ArrayList<RTPPacketFragment>() : null;
                    RTPPacketFragmentListReader rTPPacketFragmentListReader = new RTPPacketFragmentListReader(this.fragments, n5);
                    bl2 = false;
                    do {
                        Object object;
                        int n6;
                        if (rTPPacketFragmentListReader.remaining() < 5) {
                            n6 = rTPPacketFragmentListReader.count();
                            if (n6 < 0) {
                                n6 = 0;
                            }
                            if (n6 > 0) {
                                RTPPacketFragmentListReader.trim(this.fragments, n6);
                            }
                            this.size = n6;
                            if (!bl) {
                                WMSLoggerFactory.getLogger(RTPPacket.class).warn("RTPPacket.write: Bad packet: Incomplete NAL Units.");
                            }
                            break;
                        }
                        n6 = rTPPacketFragmentListReader.count();
                        rTPPacketFragmentListReader.get(byArray3);
                        n4 = BufferUtils.byteArrayToInt(byArray3, 0, 4);
                        n = byArray3[4];
                        int n7 = n & 0x1F;
                        n3 = n4 + 4;
                        if (this.debugLog) {
                            WMSLoggerFactory.getLogger(RTPPacket.class).debug("  nalUnit: hdr:" + Integer.toHexString(n & 0xFF) + " sz:" + n4 + ":" + n5 + " typ:" + this.nalUnitTypeToStr(n7));
                        }
                        int n8 = 0;
                        if (n7 == 5) {
                            this.frameType = 1;
                            bl2 = true;
                        } else if (n7 == 9) {
                            bl2 = true;
                            if (rTPPacketFragmentListReader.remaining() >= n4 - 1 - n8) {
                                byte[] byArray5 = new byte[n4];
                                byArray5[0] = byArray3[4];
                                rTPPacketFragmentListReader.get(byArray5, 1, n8 += n4 - 1);
                                object = this.decodeAud(byArray5, 3, byArray5.length - 3);
                                if (((AudDecode)object).isKeyFrame) {
                                    this.frameType = 1;
                                }
                                if (((AudDecode)object).codecConfigInfo != null) {
                                    RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo = ((AudDecode)object).codecConfigInfo;
                                }
                            }
                        } else if (n7 == 7 || n7 == 8) {
                            if (rTPPacketFragmentListReader.remaining() >= n4 - 1 - n8) {
                                byte[] byArray6 = new byte[n4];
                                byArray6[0] = byArray3[4];
                                rTPPacketFragmentListReader.get(byArray6, 1, n8 += n4 - 1);
                                if (var12_16 == null) {
                                    RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo = new RTPPacketCodecConfigInfo();
                                }
                                if (n7 == 7) {
                                    var12_16.sps = byArray6;
                                } else if (n7 == 8) {
                                    if (var12_16.ppss == null) {
                                        var12_16.ppss = new ArrayList<byte[]>();
                                    }
                                    var12_16.ppss.add(byArray6);
                                }
                            }
                        } else if (n7 == 1) {
                            bl2 = true;
                            n8 = byArray.length;
                            if (n8 > rTPPacketFragmentListReader.remaining()) {
                                n8 = rTPPacketFragmentListReader.remaining();
                            }
                            if (n8 > n4 - 1) {
                                n8 = n4 - 1;
                            }
                            rTPPacketFragmentListReader.get(byArray, 0, n8);
                            int n9 = 0;
                            for (int i = 0; i < n8; ++i) {
                                if (i >= 2 && byArray[i] == 3 && byArray[i - 1] == 0 && byArray[i - 2] == 0) continue;
                                byArray4[n9] = byArray[i];
                                ++n9;
                            }
                            object = new BitReader(byArray4, n9);
                            int n10 = ((BitReader)object).readExpGolomb();
                            int n11 = ((BitReader)object).readExpGolomb();
                            if (n11 == 2 || n11 == 7) {
                                this.frameType = 1;
                            } else if (n11 == 1 || n11 == 6) {
                                this.frameType = 3;
                            }
                            if (this.debugLog) {
                                WMSLoggerFactory.getLogger(RTPPacket.class).debug("  sliceType:" + n11 + " frameType:" + this.frameType);
                            }
                        } else if (n7 <= 6) {
                            bl2 = true;
                        }
                        if (arrayList != null) {
                            if (n7 < this.nalUnitFilter) {
                                arrayList.add(new RTPPacketFragment(null, n6, n3));
                            } else {
                                n2 = 1;
                            }
                        }
                        if (rTPPacketFragmentListReader.remaining() < n4 - 1 - n8) {
                            int n12 = rTPPacketFragmentListReader.count() - 5 - n8;
                            if (n12 < 0) {
                                n12 = 0;
                            }
                            if (n12 > 0) {
                                RTPPacketFragmentListReader.trim(this.fragments, n12);
                            }
                            this.size = n12;
                            if (!bl) {
                                WMSLoggerFactory.getLogger(RTPPacket.class).warn("RTPPacket.write: Bad packet: Incomplete NAL Units.");
                            }
                            break;
                        }
                        rTPPacketFragmentListReader.skip(n4 - 1 - n8);
                    } while (rTPPacketFragmentListReader.remaining() != 0);
                    if (arrayList != null && n2 != 0) {
                        byte[] byArray7 = new byte[this.getSize()];
                        n4 = 0;
                        for (RTPPacketFragment rTPPacketFragment : this.fragments) {
                            n3 = rTPPacketFragment.getLen();
                            System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray7, n4, n3);
                            n4 += n3;
                        }
                        this.size = 0;
                        for (RTPPacketFragment rTPPacketFragment : arrayList) {
                            rTPPacketFragment.setBuffer(byArray7);
                            this.size += rTPPacketFragment.getLen();
                        }
                        this.fragments = arrayList;
                    }
                    if (var12_16 != null) {
                        RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo;
                        boolean bl3 = false;
                        byte[] byArray8 = null;
                        if ((var12_16.sps == null || var12_16.ppss == null) && (rTPPacketCodecConfigInfo = rTPTrack.decodeParameterSets()) != null) {
                            if (var12_16.sps == null) {
                                var12_16.sps = rTPPacketCodecConfigInfo.sps;
                            }
                            if (var12_16.ppss == null) {
                                var12_16.ppss = rTPPacketCodecConfigInfo.ppss;
                            }
                        }
                        if (var12_16.sps != null && var12_16.ppss != null) {
                            byte[] byArray9 = null;
                            String string = rTPTrack.getTrackInfo("profile-level-id");
                            if (string != null) {
                                byArray9 = BufferUtils.decodeHexString(string);
                            }
                            if ((byArray8 = RTPUtils.formatH264CodecConfig(var12_16.sps, var12_16.ppss, byArray9)) != null) {
                                byte[] byArray10 = rTPTrack.getCodecConfig();
                                if (byArray10 == null) {
                                    bl3 = true;
                                } else {
                                    boolean bl4 = bl3 = !Arrays.equals(byArray10, byArray8);
                                }
                            }
                        }
                        if (bl3) {
                            rTPTrack.setCodecConfig(byArray8);
                            WMSLoggerFactory.getLogger(null).debug("RTPPacket.flushAudioBuffer: videoCodecConfig: " + DebugUtils.formatBytesShort(byArray8));
                            RTPUtils.writeCodecConfig(rTPTrack, l, byArray8);
                        }
                    }
                }
                switch (this.codec) {
                    case 7: {
                        byArray2 = new byte[]{(byte)(this.codec + (this.frameType << 4)), 1, (byte)(this.timeoffset >> 16 & 0xFFL), (byte)(this.timeoffset >> 8 & 0xFFL), (byte)(this.timeoffset >> 0 & 0xFFL)};
                        break;
                    }
                    default: {
                        byArray2 = new byte[]{(byte)(this.codec + (this.frameType << 4))};
                        break;
                    }
                }
            } else if (this.type == 8) {
                switch (this.codec) {
                    case 10: {
                        byArray2 = new byte[]{(byte)((this.codec << 4) + this.frameType), 1};
                        break;
                    }
                    default: {
                        byArray2 = new byte[]{(byte)((this.codec << 4) + this.frameType)};
                    }
                }
            }
            if (!bl2 || this.getSize() <= 0) return;
            int n13 = this.getSize() + (byArray2 == null ? 0 : byArray2.length);
            if (iMediaStream == null) return;
            rTPTrack.checkSendMetadata(l);
            if (this.debugLog) {
                WMSLoggerFactory.getLogger(RTPPacket.class).debug("  writePacket[" + (this.type == 9 ? "vid" : "aud") + "]: sz:" + n13 + " tc:" + l + ":" + this.timecode + ":" + System.currentTimeMillis() + (this.type == 9 ? " key:" + (this.frameType == 1) : ""));
            }
            byArray = null;
            int n14 = 0;
            if (this.type == 9) {
                iMediaStream.setVideoTC(l, true);
                iMediaStream.setVideoSize(n13);
                iMediaStream.startVideoPacket();
                iMediaStream.addVideoData(byArray2, 0, byArray2.length);
            } else if (this.type == 8) {
                iMediaStream.setAudioTC(l, true);
                iMediaStream.setAudioSize(n13);
                iMediaStream.startAudioPacket();
                iMediaStream.addAudioData(byArray2, 0, byArray2.length);
            } else if (this.type == 18 || this.type == 15) {
                iMediaStream.setDataType(this.type);
                iMediaStream.setDataTC(l, true);
                iMediaStream.setDataSize(n13);
                iMediaStream.startDataPacket();
                if (byArray2 != null) {
                    iMediaStream.addDataData(byArray2, 0, byArray2.length);
                }
            }
            for (RTPPacketFragment rTPPacketFragment : this.fragments) {
                if (this.type == 9) {
                    if (byArray != null) {
                        System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, n14, rTPPacketFragment.getLen());
                        n14 += rTPPacketFragment.getLen();
                    }
                    iMediaStream.addVideoData(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), rTPPacketFragment.getLen());
                    continue;
                }
                if (this.type != 8) continue;
                iMediaStream.addAudioData(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), rTPPacketFragment.getLen());
            }
            if (byArray == null) return;
            boolean bl5 = false;
            n2 = 0;
            int n15 = 0;
            while (byArray.length - n2 >= 5) {
                int n16;
                int n17 = BufferUtils.byteArrayToInt(byArray, n2, 4);
                byte by = byArray[n2 + 4];
                int n18 = by & 0x1F;
                n = by >> 5 & 7;
                if (n > n16) {
                    n16 = n;
                }
                ++n15;
                if ((n2 += n17 + 4) < byArray.length) continue;
                break;
            }
            if (n2 == byArray.length) return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacket.class).error("RTPPacket.write: " + exception.toString());
            exception.printStackTrace();
        }
    }

    class AudDecode {
        public boolean isKeyFrame = false;
        public RTPPacketCodecConfigInfo codecConfigInfo = null;

        AudDecode() {
        }
    }
}

