/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerList;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.server.Server;
import com.wowza.wms.transport.udp.UDPPortManager;
import com.wowza.wms.transport.udp.UDPTransportManager;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RTPContext {
    private RTPSessions sessions = null;
    private IVHost vhost = null;
    private Map<String, RTPStream> cacheRTPStreams = new HashMap<String, RTPStream>();
    private RTPDePacketizerList rtpDePacketizerList = new RTPDePacketizerList();
    private UDPPortManager udpPortManager = null;

    public RTPContext(IVHost iVHost) {
        this.vhost = iVHost;
        this.sessions = new RTPSessions(this.vhost);
        this.udpPortManager = Server.getInstance().getUDPPortManager();
    }

    public RTPSessions getSessions() {
        return this.sessions;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    public UDPTransportManager getUDPTransportManager() {
        return this.vhost.getUDPTransportManager();
    }

    public int acquireUDPPortPair(int n) {
        return this.udpPortManager.acquireUDPPortPair(n);
    }

    public int acquireUDPPortPair() {
        return this.udpPortManager.acquireUDPPortPair();
    }

    public void releaseUDPPortPair(int n) {
        this.udpPortManager.releaseUDPPortPair(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheRTPStream(RTPStream rTPStream) {
        Map<String, RTPStream> map = this.cacheRTPStreams;
        synchronized (map) {
            this.cacheRTPStreams.put(rTPStream.getStreamId(), rTPStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPStream uncacheRTPStream(String string) {
        RTPStream rTPStream = null;
        Map<String, RTPStream> map = this.cacheRTPStreams;
        synchronized (map) {
            rTPStream = this.cacheRTPStreams.remove(string);
        }
        return rTPStream;
    }

    public RTPDePacketizerList getDePacketizerList() {
        return this.rtpDePacketizerList;
    }

    public String getDePacketizerName(RTPTrack rTPTrack) {
        String string = null;
        List<String> list = this.rtpDePacketizerList.getDePacketizerItemNames();
        for (String string2 : list) {
            RTPDePacketizerItem rTPDePacketizerItem = this.rtpDePacketizerList.getDePacketizerItem(string2);
            IRTPDePacketizer iRTPDePacketizer = rTPDePacketizerItem.getInstance();
            if (iRTPDePacketizer == null || !iRTPDePacketizer.canHandle(rTPTrack)) continue;
            string = string2;
            break;
        }
        return string;
    }
}

