/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.IRTPMessageHandler;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.IUDPTransportSession;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.transport.udp.IUDPTransportOutgoing;
import com.wowza.wms.transport.udp.IUDPTransportOutgoingConnection;
import com.wowza.wms.vhost.IVHost;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.apache.mina.common.ByteBuffer;

public class RTPPort
implements IUDPMessageHandler {
    private RTPTrack track = null;
    private String ipAddress = "127.0.0.1";
    private int port = -1;
    private IRTPMessageHandler handler = null;
    private RTPUDPDatagramConfig datagramConfig = null;
    private boolean isMulticast = false;
    private int ttl = 0;
    private int addressCount = 1;
    private InetSocketAddress socketAddr = null;
    private IUDPTransportSession session = null;
    private IUDPTransportOutgoingConnection outgoingConnection = null;

    public RTPPort(String string, int n) {
        this.ipAddress = string;
        this.port = n;
    }

    public RTPUDPDatagramConfig getUDPConfig() {
        RTPUDPDatagramConfig rTPUDPDatagramConfig;
        block0: {
            IVHost iVHost;
            RTPUDPDatagramConfig rTPUDPDatagramConfig2;
            rTPUDPDatagramConfig = null;
            if (this.datagramConfig != null || this.track == null || (rTPUDPDatagramConfig2 = (iVHost = this.track.getVHost()).getRTPDatagramConfig()) == null) break block0;
            rTPUDPDatagramConfig = rTPUDPDatagramConfig2.clone();
        }
        return rTPUDPDatagramConfig;
    }

    public RTPTrack getTrack() {
        return this.track;
    }

    public void setTrack(RTPTrack rTPTrack) {
        this.track = rTPTrack;
    }

    public IUDPTransport getUDPTransport() {
        return this.track.getRTPStream().getUDPTransport(this.isMulticast);
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    public int getPort() {
        return this.port;
    }

    public void connect(IUDPTransportOutgoing iUDPTransportOutgoing) {
        try {
            if (this.outgoingConnection != null) {
                this.disconnect();
            }
            this.outgoingConnection = iUDPTransportOutgoing.connect(this.datagramConfig, this.ipAddress, this.port);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.disconnect: " + exception.toString());
        }
    }

    public void disconnect() {
        try {
            if (this.outgoingConnection != null) {
                this.outgoingConnection.close();
            }
            this.outgoingConnection = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.disconnect: " + exception.toString());
        }
    }

    public void bind() {
        try {
            if (this.socketAddr != null) {
                this.unbind();
            }
            IUDPTransport iUDPTransport = this.getUDPTransport();
            IVHost iVHost = this.track.getVHost();
            Executor executor = iVHost.getThreadPool().getExecutor();
            this.socketAddr = iUDPTransport.bind(this.datagramConfig == null ? iVHost.getRTPDatagramConfig() : this.datagramConfig, executor, this, this.ipAddress, this.port);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.bind: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        try {
            if (this.socketAddr != null) {
                IUDPTransport iUDPTransport = this.getUDPTransport();
                iUDPTransport.unbind(this.socketAddr);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.unbind: " + exception.toString());
        }
        finally {
            this.socketAddr = null;
        }
    }

    public void shutdown() {
        this.unbind();
    }

    public synchronized IRTPMessageHandler getHandler() {
        return this.handler;
    }

    public synchronized void setHandler(IRTPMessageHandler iRTPMessageHandler) {
        this.handler = iRTPMessageHandler;
    }

    public void sendMessage(byte[] byArray, int n, int n2) {
        try {
            if (this.outgoingConnection != null) {
                this.outgoingConnection.sendMessage(byArray, n, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendResponse(byte[] byArray) {
        this.sendResponse(byArray, 0, byArray.length, null);
    }

    public void sendResponse(byte[] byArray, int n, int n2) {
        this.sendResponse(byArray, n, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(byte[] byArray, int n, int n2, SocketAddress socketAddress) {
        RTPPort rTPPort = this;
        synchronized (rTPPort) {
            if (this.session == null) {
                WMSLoggerFactory.getLogger(RTPPort.class).debug("RTSPPort.sendResponse: No session");
            } else {
                try {
                    this.session.write(byArray, n, n2, socketAddress);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.sendResponse: " + exception.toString());
                }
            }
        }
    }

    public synchronized void sessionOpened(IUDPTransportSession iUDPTransportSession) {
        WMSLoggerFactory.getLogger(RTPPort.class).debug("RTSPPort.sessionOpened: " + iUDPTransportSession);
        this.session = iUDPTransportSession;
    }

    public synchronized void sessionClosed(IUDPTransportSession iUDPTransportSession) {
        WMSLoggerFactory.getLogger(RTPPort.class).debug("RTSPPort.sessionClosed");
        this.session = null;
    }

    public void handleMessage(SocketAddress socketAddress, Object object) {
        try {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            if (this.handler != null) {
                byte[] byArray = byteBuffer.array();
                this.handler.handleMessage(socketAddress, byArray, 0, byteBuffer.limit());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPort.class).error("RTSPPort.handleMessage: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public boolean isMulticast() {
        return this.isMulticast;
    }

    public void setMulticast(boolean bl) {
        this.isMulticast = bl;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int n) {
        this.ttl = n;
    }

    public int getAddressCount() {
        return this.addressCount;
    }

    public void setAddressCount(int n) {
        this.addressCount = n;
    }
}

