/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.IAuthenticateRTSP;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RTPSession {
    private String sessionId = null;
    private Map<String, RTPStream> streams = new HashMap<String, RTPStream>();
    private List<RTPStream> streamsOrder = new ArrayList<RTPStream>();
    private IVHost vhost = null;
    private String userAgent = "known";
    private String ip = "127.0.0.1";
    private boolean isSessionValid = true;
    private IAuthenticateRTSP authenticateHandler = null;
    private IApplicationInstance appInstance = null;
    private boolean loggedConnect = false;
    private WMSProperties properties = new WMSProperties();

    public RTPSession(String string) {
        this.sessionId = string;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public void addRTSPStream(RTPStream rTPStream) {
        rTPStream.setSession(this);
        this.streams.put(rTPStream.getStreamId(), rTPStream);
        this.streamsOrder.add(rTPStream);
    }

    public RTPStream removeRTSPStream(String string) {
        RTPStream rTPStream = this.streams.remove(string);
        if (rTPStream != null) {
            this.streamsOrder.remove(rTPStream);
        }
        return rTPStream;
    }

    public RTPStream getRTSPStream(String string) {
        return this.streams.get(string);
    }

    public RTPStream getRTSPStream() {
        RTPStream rTPStream = null;
        if (this.streamsOrder.size() > 0) {
            rTPStream = this.streamsOrder.get(this.streamsOrder.size() - 1);
        }
        return rTPStream;
    }

    public synchronized IVHost getVHost() {
        return this.vhost;
    }

    public synchronized void setVHost(IVHost iVHost) {
        this.vhost = iVHost;
    }

    public synchronized String getUserAgent() {
        return this.userAgent;
    }

    public synchronized void setUserAgent(String string) {
        this.userAgent = string;
    }

    public void touch() {
        for (RTPStream rTPStream : this.streams.values()) {
            rTPStream.touch();
        }
    }

    public void shutdown() {
        RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
        this.shutdown(rTPRequestStatus);
    }

    public void shutdown(RTPRequestStatus rTPRequestStatus) {
        if (this.appInstance != null) {
            this.appInstance.removeRTPSession(this);
            for (RTPStream rTPStream : this.streams.values()) {
                try {
                    rTPStream.shutdown(rTPRequestStatus);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPSession.shutdown: " + exception.toString());
                }
            }
            this.streams.clear();
            this.streamsOrder.clear();
            this.appInstance = null;
        }
    }

    public boolean isSessionValid() {
        return this.isSessionValid;
    }

    public void setSessionValid(boolean bl) {
        this.isSessionValid = bl;
    }

    public IAuthenticateRTSP getAuthenticateHandler() {
        return this.authenticateHandler;
    }

    public void setAuthenticateHandler(IAuthenticateRTSP iAuthenticateRTSP) {
        this.authenticateHandler = iAuthenticateRTSP;
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    public void setAppInstance(IApplicationInstance iApplicationInstance) {
        if (iApplicationInstance != null) {
            iApplicationInstance.addRTPSession(this);
        }
        this.appInstance = iApplicationInstance;
    }

    public boolean isLoggedConnect() {
        return this.loggedConnect;
    }

    public void setLoggedConnect(boolean bl) {
        this.loggedConnect = bl;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public WMSProperties getProperties() {
        return this.properties;
    }
}

