/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.wms.rtp.model.IRTPSessionNotify;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RTPSessions {
    private Map<String, RTPSession> sessions = new HashMap<String, RTPSession>();
    private IVHost vhost = null;
    private Random rnd = null;
    private List<IRTPSessionNotify> listeners = new ArrayList<IRTPSessionNotify>();

    public RTPSessions(IVHost iVHost) {
        this.vhost = iVHost;
        this.rnd = new Random(System.currentTimeMillis());
    }

    private String newGUID() {
        return "" + this.rnd.nextInt(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextSessionId() {
        String string = this.newGUID();
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            while (this.sessions.containsKey(string)) {
                string = this.newGUID();
            }
            this.sessions.put(string, null);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPSession getSession(String string) {
        RTPSession rTPSession = null;
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            rTPSession = this.sessions.get(string);
        }
        return rTPSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPSession removeSession(String string) {
        RTPSession rTPSession = null;
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            rTPSession = this.sessions.remove(string);
        }
        return rTPSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPSession removeSession(RTPSession rTPSession) {
        RTPSession rTPSession2 = null;
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            rTPSession2 = this.sessions.remove(rTPSession.getSessionId());
        }
        return rTPSession2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPSession addSession(RTPSession rTPSession) {
        Map<String, RTPSession> map = this.sessions;
        synchronized (map) {
            rTPSession.setVHost(this.vhost);
            this.sessions.put(rTPSession.getSessionId(), rTPSession);
        }
        return rTPSession;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(IRTPSessionNotify iRTPSessionNotify) {
        List<IRTPSessionNotify> list = this.listeners;
        synchronized (list) {
            this.listeners.add(iRTPSessionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(IRTPSessionNotify iRTPSessionNotify) {
        List<IRTPSessionNotify> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(iRTPSessionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionCreate(RTPSession rTPSession) {
        ArrayList<IRTPSessionNotify> arrayList = null;
        List<IRTPSessionNotify> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<IRTPSessionNotify>(this.listeners);
        }
        for (IRTPSessionNotify iRTPSessionNotify : arrayList) {
            iRTPSessionNotify.onRTPSessionCreate(rTPSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionDestroy(RTPSession rTPSession) {
        ArrayList<IRTPSessionNotify> arrayList = null;
        List<IRTPSessionNotify> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<IRTPSessionNotify>(this.listeners);
        }
        for (IRTPSessionNotify iRTPSessionNotify : arrayList) {
            iRTPSessionNotify.onRTPSessionDestroy(rTPSession);
        }
    }
}

