/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.rtp.model.IRTPMetadataProvider;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.RTPMulticastTransport;
import com.wowza.wms.rtp.transport.RTPUDPTransport;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPStream {
    public static final int AVSYNCMETHODS_UNKNOWN = 0;
    public static final int AVSYNCMETHODS_SENDERREPORT = 1;
    public static final int AVSYNCMETHODS_SYSTEMCLOCK = 2;
    public static final int AVSYNCMETHODS_RTPTIMECODE = 3;
    public static final String STREAMINFO_SESSIONPROTOCOLVERSION = "protocolversion";
    public static final String STREAMINFO_SESSIONPORIGIN = "origin";
    public static final String STREAMINFO_SESSIONNAME = "name";
    public static final String STREAMINFO_SESSIONINFORMATION = "information";
    public static final String STREAMINFO_SESSIONURI = "uri";
    public static final String STREAMINFO_SESSIONEMAILADDRESS = "emailaddress";
    public static final String STREAMINFO_SESSIONPHONENUMBER = "phonenumber";
    public static final String STREAMINFO_SESSIONCONNECTIONDATA = "connectiondata";
    public static final String STREAMINFO_SESSIONBANDWIDTH = "bandwidth";
    public static final String STREAMINFO_SESSIONTIMING = "timing";
    public static final String STREAMINFO_SESSIONREPEATTIMES = "repeattimes";
    public static final String STREAMINFO_SESSIONTIMEZONES = "timezones";
    public static final String STREAMINFO_SESSIONATTRIBUTES = "attributes";
    private Map<String, RTPTrack> tracks = new HashMap<String, RTPTrack>();
    private Map<String, String> seqToTrackId = new HashMap<String, String>();
    private RTPSession session = null;
    private RTPContext context = null;
    private IMediaStream stream = null;
    private String streamId = null;
    private WMSReadWriteLock streamLock = new WMSReentrantReadWriteLock();
    private boolean resyncAudioVideoOnSR = false;
    private Map<String, String> streamInfo = new HashMap<String, String>();
    private Map<String, String> streamAttributes = new HashMap<String, String>();
    private boolean sentMetadata = false;
    private String streamType = null;
    private String host = null;
    private String appName = "_defapp_";
    private String appInstanceName = "_definst_";
    private String streamName = "unknown";
    private String streamExt = "mp4";
    private String streamQueryStr = "";
    private long streamSessionId = -1L;
    private long streamSessionVersion = -1L;
    private String streamSessionIp = null;
    private boolean checkSSRC = true;
    private boolean checkIpAddr = false;
    private IUDPTransport udpTransport = null;
    private int avSyncMethod = 1;
    private int maxRTCPWaitTime = 10000;
    private int mpegtsVideoPID = -1;
    private int mpegtsAudioPID = -1;
    private boolean isRTCP = true;
    private boolean isRTSP = false;
    private boolean isPublish = false;

    public RTPStream(RTPContext rTPContext, String string) {
        this.context = rTPContext;
        this.streamId = string;
    }

    public RTPContext getRTPContext() {
        return this.context;
    }

    public WMSReadWriteLock getStreamLock() {
        return this.streamLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrack(RTPTrack rTPTrack) {
        this.streamLock.writeLock().lock();
        try {
            rTPTrack.setStream(this);
            this.tracks.put(rTPTrack.getTrackId(), rTPTrack);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack removeTrack(String string) {
        RTPTrack rTPTrack = null;
        this.streamLock.writeLock().lock();
        try {
            rTPTrack = this.tracks.remove(string);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMediaInBytes(long l) {
        Object var3_2 = null;
        this.streamLock.writeLock().lock();
        try {
            if (this.stream != null) {
                this.stream.incrementMediaInBytes(l);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getTrack(String string) {
        RTPTrack rTPTrack = null;
        this.streamLock.readLock().lock();
        try {
            rTPTrack = this.tracks.get(string);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackId(String string, String string2) {
        this.streamLock.writeLock().lock();
        try {
            this.seqToTrackId.put(string, string2);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackId(String string) {
        String string2 = null;
        this.streamLock.readLock().lock();
        try {
            string2 = this.seqToTrackId.get(string);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTrackNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.streamLock.readLock().lock();
        try {
            arrayList.addAll(this.tracks.keySet());
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return arrayList;
    }

    public RTPSession getSession() {
        return this.session;
    }

    public void setSession(RTPSession rTPSession) {
        this.session = rTPSession;
    }

    public String getStreamId() {
        return this.streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaStream getStream() {
        IMediaStream iMediaStream = null;
        this.streamLock.readLock().lock();
        try {
            iMediaStream = this.stream;
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return iMediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getAudioTrack() {
        RTPTrack rTPTrack = null;
        this.streamLock.readLock().lock();
        try {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (!rTPTrack2.isAudio()) continue;
                RTPTrack rTPTrack3 = rTPTrack2;
                return rTPTrack3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getVideoTrack() {
        RTPTrack rTPTrack = null;
        this.streamLock.readLock().lock();
        try {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (!rTPTrack2.isVideo()) continue;
                RTPTrack rTPTrack3 = rTPTrack2;
                return rTPTrack3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamInfo(String string, String string2) {
        WMSReadWriteLock wMSReadWriteLock = this.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.streamInfo.put(string, string2);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStreamInfo(String string) {
        String string2 = null;
        WMSReadWriteLock wMSReadWriteLock = this.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            string2 = this.streamInfo.get(string);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamAttribute(String string, String string2) {
        WMSReadWriteLock wMSReadWriteLock = this.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.streamAttributes.put(string, string2);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    public IVHost getVHost() {
        return this.session.getVHost();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public boolean streamExists() {
        return this.stream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStream(RTPRequestStatus rTPRequestStatus) {
        boolean bl = false;
        this.streamLock.writeLock().lock();
        try {
            if (this.stream != null) {
            } else {
                IApplicationInstance iApplicationInstance = this.getAppInstance();
                if (iApplicationInstance == null) {
                } else {
                    this.setAVSyncMethod(iApplicationInstance.getRTPAVSyncMethod());
                    this.setMaxRTCPWaitTime(iApplicationInstance.getRTPMaxRTCPWaitTime());
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    int n = mediaStreamMap.getNextStreamIndex();
                    String string = this.getStreamType();
                    if (string == null) {
                        string = iApplicationInstance.getStreamType();
                    }
                    this.stream = mediaStreamMap.getStreamClientless(n, string);
                    if (this.stream == null) {
                    } else {
                        WMSLoggerFactory.getLogger(null).info(null, this.stream, "stream", "create", 200, null);
                        this.stream.setRTPStream(this);
                        ModuleFunctions moduleFunctions = iApplicationInstance.getModFunctions();
                        moduleFunctions.onStreamCreate(this.stream);
                        mediaStreamMap.notifyMediaStreamCreate(this.stream);
                        WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "create", 200, "streamType:" + string + " streamIndex:" + n);
                        bl = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.createStream: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(RTPRequestStatus rTPRequestStatus) {
        this.streamLock.writeLock().lock();
        try {
            if (this.udpTransport != null) {
                this.udpTransport.unbindAll();
            }
            this.udpTransport = null;
            for (RTPTrack object : this.tracks.values()) {
                try {
                    object.shutdown(rTPRequestStatus);
                }
                catch (Exception mediaStreamMap) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.shutdown: " + mediaStreamMap.toString());
                }
            }
            this.tracks.clear();
            if (this.stream != null) {
                IApplicationInstance iApplicationInstance = this.getAppInstance();
                if (iApplicationInstance != null) {
                    WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                    WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                    WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                }
                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "unpublish", 200, this.stream.getName());
                this.stream.close();
                if (!this.stream.isPlay()) {
                    this.stream.publish();
                    this.stream.stopPublishing();
                } else if (iApplicationInstance != null) {
                    iApplicationInstance.removePlayStreamByName(this.stream);
                }
                if (this.stream.isPlay()) {
                    if (this.stream.isSendPlayStopLogEvent()) {
                        this.stream.setSendPlayStopLogEvent(false);
                        this.stream.notifyActionStop();
                    }
                } else {
                    this.stream.notifyActionUnPublish(this.stream.getName(), this.stream.isRecord(), this.stream.isAppend());
                }
                if (iApplicationInstance != null) {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    mediaStreamMap.removeStream(this.stream.getSrc());
                }
            }
            this.stream = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.shutdown: " + exception.toString());
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IApplicationInstance getAppInstance() {
        IApplication iApplication = null;
        IApplicationInstance iApplicationInstance = null;
        if (this.appName != null && this.appInstanceName != null) {
            IVHost iVHost = this.getVHost();
            WMSReadWriteLock wMSReadWriteLock = iVHost.getApplicationLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                iApplication = iVHost.getApplication(this.appName);
                if (iApplication != null) {
                    iApplicationInstance = iApplication.getAppInstance(this.appInstanceName);
                } else {
                    WMSLoggerFactory.getLogger(RTPStream.class).warn("Application folder ([install-location]/applications/" + this.appName + ") is missing");
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPStream.class).error("RTPStream.getAppInstance: " + exception.toString());
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
        }
        return iApplicationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRecord(RTPRequestStatus rTPRequestStatus) {
        if (this.stream == null) {
            return;
        }
        this.streamLock.writeLock().lock();
        try {
            IApplicationInstance iApplicationInstance = this.getAppInstance();
            MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
            boolean bl = false;
            boolean bl2 = false;
            IMediaStream iMediaStream = this.stream;
            synchronized (iMediaStream) {
                this.stream.setOpen(true);
                this.stream.setRecord(bl);
                this.stream.setAppend(bl2);
                this.stream.setName(this.streamName);
                this.stream.setExt(this.streamExt);
                this.stream.setQueryStr(this.streamQueryStr);
                mediaStreamMap.notifyPlayPublish(this.stream);
                this.stream.startPublishing();
                WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "publish", 200, this.streamName);
                if (bl) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "record", 200, this.streamName);
                }
                this.stream.notifyActionPublish(this.streamName, bl, bl2);
            }
            if (this.tracks.size() <= 1) {
                this.setAVSyncMethod(2);
            }
            for (RTPTrack rTPTrack : this.tracks.values()) {
                rTPTrack.record(rTPRequestStatus);
                if (rTPRequestStatus.isGood()) continue;
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.doRecord: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    public void record(RTPRequestStatus rTPRequestStatus) {
        this.doRecord(rTPRequestStatus);
    }

    public void attachToWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        for (RTPTrack rTPTrack : this.tracks.values()) {
            rTPTrack.attachToWMSSession(rtmpSessionInfo);
        }
    }

    public void detachFromWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        for (RTPTrack rTPTrack : this.tracks.values()) {
            rTPTrack.detachFromWMSSession(rtmpSessionInfo);
        }
    }

    public void play(RTPRequestStatus rTPRequestStatus) {
        RTSPStatics.setStatus(rTPRequestStatus, 501);
    }

    public void pause(RTPRequestStatus rTPRequestStatus) {
        boolean bl = true;
        for (RTPTrack rTPTrack : this.tracks.values()) {
            rTPTrack.pause(rTPRequestStatus);
            if (rTPRequestStatus.isGood()) continue;
            break;
        }
    }

    public void announce(RTPRequestStatus rTPRequestStatus) {
        for (RTPTrack rTPTrack : this.tracks.values()) {
            rTPTrack.announce(rTPRequestStatus);
            if (rTPRequestStatus.isGood()) continue;
            break;
        }
    }

    public void touch() {
    }

    public boolean isResyncAudioVideoOnSR() {
        return this.resyncAudioVideoOnSR;
    }

    public void setResyncAudioVideoOnSR(boolean bl) {
        this.resyncAudioVideoOnSR = bl;
    }

    public byte[] getMetadataPacket() {
        byte[] byArray = null;
        try {
            AMFDataMixedArray aMFDataMixedArray = new AMFDataMixedArray();
            AMFDataArray aMFDataArray = new AMFDataArray();
            for (RTPTrack object32 : this.tracks.values()) {
                Iterator<String> iterator = new AMFDataObj();
                ((AMFDataObj)((Object)iterator)).put("timescale", new AMFDataItem(object32.getTimescale()));
                ((AMFDataObj)((Object)iterator)).put("language", new AMFDataItem("eng"));
                AMFDataArray aMFDataArray2 = new AMFDataArray();
                AMFDataObj aMFDataObj = new AMFDataObj();
                aMFDataObj.put("sampletype", new AMFDataItem(object32.getSampleType()));
                aMFDataArray2.add(aMFDataObj);
                ((AMFDataObj)((Object)iterator)).put("sampledescription", aMFDataArray2);
                if (object32.isAudio()) {
                    aMFDataMixedArray.put("audiochannels", new AMFDataItem(object32.getChannelCount()));
                    aMFDataMixedArray.put("audiosamplerate", new AMFDataItem(object32.getTimescale()));
                    aMFDataMixedArray.put("audiocodecid", new AMFDataItem("mp4a"));
                }
                if (object32.isVideo()) {
                    aMFDataMixedArray.put("width", new AMFDataItem(object32.getWidth()));
                    aMFDataMixedArray.put("height", new AMFDataItem(object32.getHeight()));
                    aMFDataMixedArray.put("videocodecid", new AMFDataItem("avc1"));
                }
                aMFDataArray.add((AMFData)((Object)iterator));
            }
            aMFDataMixedArray.put("trackinfo", aMFDataArray);
            AMFDataObj aMFDataObj = new AMFDataObj();
            for (String string : this.streamInfo.keySet()) {
                String string2 = this.streamInfo.get(string);
                if (string2 == null) continue;
                aMFDataObj.put(string, new AMFDataItem(string2));
            }
            AMFDataObj aMFDataObj2 = new AMFDataObj();
            for (String string : this.streamAttributes.keySet()) {
                String string3 = this.streamAttributes.get(string);
                if (string3 == null) continue;
                aMFDataObj2.put(string, new AMFDataItem(string3));
            }
            aMFDataObj.put(STREAMINFO_SESSIONATTRIBUTES, aMFDataObj2);
            aMFDataMixedArray.put("rtpsessioninfo", aMFDataObj);
            AMFDataList aMFDataList = new AMFDataList();
            aMFDataList.add(new AMFDataItem("onMetaData"));
            aMFDataList.add(aMFDataMixedArray);
            byArray = aMFDataList.serialize();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.getMetadataPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return byArray;
    }

    private IRTPMetadataProvider getMetadataProvider() {
        String string;
        IRTPMetadataProvider iRTPMetadataProvider = null;
        IApplicationInstance iApplicationInstance = this.getAppInstance();
        if (iApplicationInstance != null && (string = iApplicationInstance.getRTPProperties().getPropertyStr("rtpMetadataProvider")) != null) {
            try {
                Class<?> clazz = Class.forName(string);
                if (clazz != null) {
                    iRTPMetadataProvider = (IRTPMetadataProvider)clazz.newInstance();
                    if (iRTPMetadataProvider == null) {
                        WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPStream.getMetadataProvider: RTP Metadata provider could not be instantiated: " + string);
                    }
                } else {
                    WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPDePacketizerBase.getMetadataProvider: RTP Metadata provider could not be found: " + string);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPStream.class).error("RTPDePacketizerBase.getMetadataProvider: " + exception.toString());
            }
        }
        return iRTPMetadataProvider;
    }

    private void sendMetadata(long l) {
        try {
            IRTPMetadataProvider iRTPMetadataProvider = this.getMetadataProvider();
            byte[] byArray = null;
            byArray = iRTPMetadataProvider != null ? iRTPMetadataProvider.getMetadataPacket(this) : this.getMetadataPacket();
            if (byArray != null) {
                this.stream.setDataType(18);
                this.stream.setDataTC(l, true);
                this.stream.setDataSize(byArray.length);
                this.stream.startDataPacket();
                this.stream.addDataData(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.sendMetadata: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSendMetadata(long l) {
        Object var3_2 = null;
        this.streamLock.readLock().lock();
        try {
            if (!this.sentMetadata) {
                this.sendMetadata(l);
                this.sentMetadata = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
    }

    public void extractCodecConfigFromTrackInfo() {
        for (RTPTrack rTPTrack : this.tracks.values()) {
            rTPTrack.extractCodecConfigFromTrackInfo();
        }
    }

    public String getStreamType() {
        return this.streamType;
    }

    public void setStreamType(String string) {
        this.streamType = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getAppInstanceName() {
        return this.appInstanceName;
    }

    public void setAppInstanceName(String string) {
        this.appInstanceName = string;
    }

    public String getStreamExt() {
        return this.streamExt;
    }

    public void setStreamExt(String string) {
        this.streamExt = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public long getStreamSessionId() {
        return this.streamSessionId;
    }

    public void setStreamSessionId(long l) {
        this.streamSessionId = l;
    }

    public long getStreamSessionVersion() {
        return this.streamSessionVersion;
    }

    public void setStreamSessionVersion(long l) {
        this.streamSessionVersion = l;
    }

    public String getStreamSessionIp() {
        return this.streamSessionIp;
    }

    public void setStreamSessionIp(String string) {
        this.streamSessionIp = string;
    }

    public boolean isCheckSSRC() {
        return this.checkSSRC;
    }

    public void setCheckSSRC(boolean bl) {
        this.checkSSRC = bl;
    }

    public boolean isCheckIpAddr() {
        return this.checkIpAddr;
    }

    public void setCheckIpAddr(boolean bl) {
        this.checkIpAddr = bl;
    }

    public IUDPTransport getUDPTransport(boolean bl) {
        if (this.udpTransport == null) {
            String string = null;
            IMediaStream iMediaStream = this.getStream();
            if (iMediaStream != null) {
                string = iMediaStream.getProperties().getPropertyStr(bl ? "multicastTransportBaseClass" : "udpTransportBaseClass", string);
            }
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    if (clazz != null) {
                        this.udpTransport = (IUDPTransport)clazz.newInstance();
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPStream.class).error("RTPStream.getUDPTransport: Transport base class could not be instantiated[" + string + "]: " + exception.toString());
                }
                if (this.udpTransport == null) {
                    WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPStream.getUDPTransport: Transport base class could not be instantiated: " + string);
                }
            }
            if (this.udpTransport == null) {
                this.udpTransport = bl ? new RTPMulticastTransport() : new RTPUDPTransport();
            }
        }
        return this.udpTransport;
    }

    public int getAVSyncMethod() {
        return this.avSyncMethod;
    }

    public void setAVSyncMethod(int n) {
        this.avSyncMethod = n;
    }

    public boolean isAVSyncNonSR() {
        return this.avSyncMethod == 2 || this.avSyncMethod == 3;
    }

    public int getMaxRTCPWaitTime() {
        return this.maxRTCPWaitTime;
    }

    public void setMaxRTCPWaitTime(int n) {
        this.maxRTCPWaitTime = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getStreamInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.streamLock.readLock().lock();
        try {
            hashMap.putAll(this.streamInfo);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getStreamAttributes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.streamLock.readLock().lock();
        try {
            hashMap.putAll(this.streamAttributes);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return hashMap;
    }

    public static int avSyncNameToId(String string) {
        int n = 0;
        if (string.toLowerCase().startsWith("senderreport")) {
            n = 1;
        } else if (string.toLowerCase().startsWith("systemclock")) {
            n = 2;
        } else if (string.toLowerCase().startsWith("rtptimecode")) {
            n = 3;
        }
        return n;
    }

    public int getMPEGTSVideoPID() {
        return this.mpegtsVideoPID;
    }

    public void setMPEGTSVideoPID(int n) {
        this.mpegtsVideoPID = n;
    }

    public int getMPEGTSAudioPID() {
        return this.mpegtsAudioPID;
    }

    public void setMPEGTSAudioPID(int n) {
        this.mpegtsAudioPID = n;
    }

    public boolean isRTCP() {
        return this.isRTCP;
    }

    public void setRTCP(boolean bl) {
        this.isRTCP = bl;
    }

    public boolean isRTSP() {
        return this.isRTSP;
    }

    public void setRTSP(boolean bl) {
        this.isRTSP = bl;
    }

    public String getStreamQueryStr() {
        return this.streamQueryStr;
    }

    public void setStreamQueryStr(String string) {
        this.streamQueryStr = string;
    }

    public boolean isPublish() {
        return this.isPublish;
    }

    public void setPublish(boolean bl) {
        this.isPublish = bl;
    }
}

