/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerFactory;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerList;
import com.wowza.wms.rtp.depacketizer.RTPPacketCodecConfigInfo;
import com.wowza.wms.rtp.model.IRTPMessageHandler;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPPort;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtsp.RTSPCore;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPTrack {
    public static final String STREAMINFO_SAMPLETYPE = "sample-type";
    public static final String STREAMINFO_TIMESCALE = "timescale";
    public static final String STREAMINFO_CHANNELCOUNT = "channel-count";
    public static final String STREAMINFO_PARAMETERSETS = "sprop-parameter-sets";
    public static final String STREAMINFO_CLIPRECT = "cliprect";
    public static final String STREAMINFO_CONFIG = "config";
    public static final String STREAMINFO_PROFILELEVELID = "profile-level-id";
    public static final String STREAMINFO_SESSIONCONNECTIONDATA = "connectiondata";
    public static final String STREAMINFO_AUXILIARYDATASIZELENGTH = "auxiliarydatasizelength";
    public static final String STREAMINFO_CONSTANTSIZE = "constantsize";
    public static final String STREAMINFO_CONSTANTDURATION = "constantduration";
    public static final String STREAMINFO_MAXDISPLACEMENT = "maxdisplacement";
    public static final String STREAMINFO_DEINTERLEAVEBUFFERSIZE = "de-interleavebuffersize";
    public static final String STREAMINFO_SIZELENGTH = "sizelength";
    public static final String STREAMINFO_INDEXLENGTH = "indexlength";
    public static final String STREAMINFO_INDEXDELTALENGTH = "indexdeltalength";
    public static final String STREAMINFO_CTSDELTALENGTH = "ctsdeltalength";
    public static final String STREAMINFO_DTSDELTALENGTH = "dtsdeltalength";
    public static final String STREAMINFO_RANDOMACCESSINDICATION = "randomaccessindication";
    public static final String STREAMINFO_STREAMSTATEINDICATION = "streamstateindication";
    public static final int SAMPLES_PERFRAME = 1024;
    private String trackId = "unknown";
    private RTPStream rtpStream = null;
    private Map<String, String> trackInfo = new HashMap<String, String>();
    private int trackType = 0;
    private int width = 0;
    private int height = 0;
    private HandleRTPMessage rtpMessageHandler = new HandleRTPMessage(this);
    private HandleRTCPMessage rtcpMessageHandler = new HandleRTCPMessage(this);
    private IRTPDePacketizer rtpDePacketizer = null;
    private String rtpDePacketizerName = null;
    private int timescale = 0;
    private int channelCount = 0;
    private String sampleType = "";
    private String announceData = "";
    private boolean isInterleaved = false;
    private byte[] codecConfig = null;
    private int samplesPerFrame = 1024;
    private boolean waitForFirstEnd = true;
    private String host = null;
    private long ssrc = 0L;
    private int maxPacketSize = 1438;
    private IRTPPacketizer rtpPacketizer = null;
    private int rtpOutPortNum = -1;
    private int rtcpOutPortNum = -1;
    private RTPPort rtpInPort = null;
    private RTPPort rtcpInPort = null;
    private RTPPort rtpOutPort = null;
    private RTPPort rtcpOutPort = null;

    public RTPTrack(String string) {
        this.trackId = string;
    }

    public String getTrackId() {
        return this.trackId;
    }

    public void setTrackId(String string) {
        this.trackId = string;
    }

    public RTPStream getStream() {
        return this.rtpStream;
    }

    public void setStream(RTPStream rTPStream) {
        this.rtpStream = rTPStream;
    }

    public String getHost() {
        return this.host == null ? this.rtpStream.getHost() : this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAudio() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.trackType == 8;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVideo() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.trackType == 9;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackType() {
        int n = 0;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            n = this.trackType;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackType(int n) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.trackType = n;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTrackInfoKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            arrayList.addAll(this.trackInfo.keySet());
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackInfo(String string, String string2) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.trackInfo.put(string, string2);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackInfo(String string) {
        String string2 = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            string2 = this.trackInfo.get(string);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return string2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCodecConfig() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.codecConfig != null;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCodecConfig() {
        byte[] byArray = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            byArray = this.codecConfig;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodecConfig(byte[] byArray) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.codecConfig = byArray;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    public RTPPacketCodecConfigInfo decodeParameterSets() {
        RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo = null;
        String string = this.getTrackInfo(STREAMINFO_PARAMETERSETS);
        if (string != null) {
            rTPPacketCodecConfigInfo = new RTPPacketCodecConfigInfo();
            String[] stringArray = string.split("[,]");
            for (int i = 0; i < stringArray.length; ++i) {
                byte[] byArray;
                String string2 = stringArray[i].trim();
                if (string2.length() <= 0 || (byArray = Base64.decode(stringArray[i].trim())) == null) continue;
                int n = byArray[0] & 0x1F;
                if (n == 7) {
                    rTPPacketCodecConfigInfo.sps = byArray;
                    continue;
                }
                if (n != 8) continue;
                if (rTPPacketCodecConfigInfo.ppss == null) {
                    rTPPacketCodecConfigInfo.ppss = new ArrayList<byte[]>();
                }
                rTPPacketCodecConfigInfo.ppss.add(byArray);
            }
        }
        return rTPPacketCodecConfigInfo;
    }

    public void extractCodecConfigFromTrackInfo() {
        block31: {
            RTPPort rTPPort;
            int n;
            Object[] objectArray;
            Object object;
            Object object2;
            Object object3;
            String[] stringArray;
            String string;
            byte[] byArray = null;
            if (this.isVideo()) {
                if (byArray == null && (string = this.getTrackInfo(STREAMINFO_PARAMETERSETS)) != null) {
                    stringArray = string.split("[,]");
                    object3 = null;
                    object2 = new ArrayList();
                    for (int i = 0; i < stringArray.length; ++i) {
                        object = stringArray[i].trim();
                        if (object.length() <= 0 || (objectArray = Base64.decode(stringArray[i].trim())) == null) continue;
                        n = objectArray[0] & 0x1F;
                        if (n == 7) {
                            object3 = objectArray;
                            continue;
                        }
                        if (n != 8) continue;
                        object2.add(objectArray);
                    }
                    if (object3 != null && object2.size() > 0) {
                        try {
                            byte[] byArray2 = null;
                            object = this.getTrackInfo(STREAMINFO_PROFILELEVELID);
                            if (object != null) {
                                byArray2 = BufferUtils.decodeHexString(object);
                            }
                            byArray = RTPUtils.formatH264CodecConfig((byte[])object3, (List<byte[]>)object2, byArray2);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): " + exception.toString());
                        }
                    } else {
                        if (object3 == null) {
                            WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): Missing NAL SPS(7)");
                        }
                        if (object2.size() == 0) {
                            WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): Missing NAL PPS(8)");
                        }
                    }
                }
            } else if (this.isAudio() && (string = this.getTrackInfo(STREAMINFO_CONFIG)) != null) {
                byArray = BufferUtils.decodeHexString(string);
            }
            if (byArray != null) {
                this.codecConfig = byArray;
            }
            if ((string = this.getTrackInfo(STREAMINFO_SESSIONCONNECTIONDATA)) == null) {
                string = this.getStream().getStreamInfo(STREAMINFO_SESSIONCONNECTIONDATA);
            }
            if (string == null || (stringArray = string.split("[ ]")).length < 3) break block31;
            object3 = stringArray[2];
            object2 = this.getRTPPort();
            if (object2 != null && (rTPPort = this.getRTCPPort()) != null) {
                object = null;
                if (((String)object3).indexOf("/") >= 0) {
                    objectArray = ((String)object3).split("/");
                    if (objectArray.length > 0) {
                        object = objectArray[0];
                        ((RTPPort)object2).setIpAddress((String)objectArray[0]);
                        rTPPort.setIpAddress((String)objectArray[0]);
                    }
                    if (objectArray.length > 1) {
                        n = -1;
                        try {
                            n = Integer.parseInt((String)objectArray[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n >= 0) {
                            ((RTPPort)object2).setTTL(n);
                            rTPPort.setTTL(n);
                        }
                    }
                    if (objectArray.length > 2) {
                        n = -1;
                        try {
                            n = Integer.parseInt((String)objectArray[2]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n >= 0) {
                            ((RTPPort)object2).setAddressCount(n);
                            rTPPort.setAddressCount(n);
                        }
                    }
                } else {
                    object = object3;
                    ((RTPPort)object2).setIpAddress((String)object3);
                    rTPPort.setIpAddress((String)object3);
                }
                boolean bl = false;
                if (object != null) {
                    try {
                        InetAddress inetAddress = InetAddress.getByName(object);
                        if (inetAddress != null) {
                            bl = inetAddress.isMulticastAddress();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ((RTPPort)object2).setMulticast(bl);
                rTPPort.setMulticast(bl);
            }
        }
    }

    public synchronized int getRTPOutPortNum() {
        return this.rtpOutPortNum;
    }

    public synchronized void setRTPOutPortNum(int n) {
        this.rtpOutPortNum = n;
    }

    public synchronized int getRTCPOutPortNum() {
        return this.rtcpOutPortNum;
    }

    public synchronized void setRTCPOutPortNum(int n) {
        this.rtcpOutPortNum = n;
    }

    public IVHost getVHost() {
        return this.rtpStream.getVHost();
    }

    public RTPContext getRTPContext() {
        return this.rtpStream.getVHost().getRTPContext();
    }

    public void shutdown(RTPRequestStatus rTPRequestStatus) {
        RTPContext rTPContext = this.getRTPContext();
        int n = -1;
        int n2 = -1;
        if (this.rtpInPort != null) {
            n = this.rtpInPort.getPort();
            this.rtpInPort.shutdown();
        }
        this.rtpInPort = null;
        if (this.rtcpInPort != null) {
            n2 = this.rtcpInPort.getPort();
            this.rtcpInPort.shutdown();
        }
        this.rtcpInPort = null;
        if (n > 0) {
            if (n % 2 == 0 && n + 1 == n2) {
                rTPContext.releaseUDPPortPair(n);
            } else {
                rTPContext.releaseUDPPortPair(n);
                rTPContext.releaseUDPPortPair(n2);
            }
        }
        if (this.rtpDePacketizer != null) {
            this.rtpDePacketizer.shutdown(this);
        }
        this.rtpDePacketizer = null;
    }

    private String getBindHost() {
        return this.rtpStream.isRTSP() ? null : this.getHost();
    }

    public void addPorts() {
        if (this.rtpInPort == null && this.rtcpInPort == null) {
            int n = -1;
            int n2 = -1;
            RTPContext rTPContext = this.getRTPContext();
            n = rTPContext.acquireUDPPortPair();
            n2 = n + 1;
            String string = this.getBindHost();
            this.rtpInPort = new RTPPort(string, n);
            this.rtpInPort.setTrack(this);
            this.rtpInPort.setHandler(this.rtpMessageHandler);
            this.rtcpInPort = new RTPPort(string, n2);
            this.rtcpInPort.setTrack(this);
            this.rtcpInPort.setHandler(this.rtcpMessageHandler);
        }
    }

    public void setRTPPort(int n) {
        String string = this.getBindHost();
        this.rtpInPort = new RTPPort(string, n);
        this.rtpInPort.setTrack(this);
        this.rtpInPort.setHandler(this.rtpMessageHandler);
    }

    public void setRTCPPort(int n) {
        String string = this.getBindHost();
        this.rtcpInPort = new RTPPort(string, n);
        this.rtcpInPort.setTrack(this);
        this.rtcpInPort.setHandler(this.rtcpMessageHandler);
    }

    public RTPPort getRTPPort() {
        return this.rtpInPort;
    }

    public RTPPort getRTCPPort() {
        return this.rtcpInPort;
    }

    public int getRTPPortId() {
        return this.rtpInPort == null ? -1 : this.rtpInPort.getPort();
    }

    public int getRTCPPortId() {
        return this.rtcpInPort == null ? -1 : this.rtcpInPort.getPort();
    }

    public void attachToWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        if (this.isInterleaved) {
            rtmpSessionInfo.addRTPInterleaveHandler(this.rtpOutPortNum, this.rtpMessageHandler);
            rtmpSessionInfo.addRTPInterleaveHandler(this.rtcpOutPortNum, this.rtcpMessageHandler);
        }
    }

    public void detachFromWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        rtmpSessionInfo.clearRTPInterleaveHandler();
    }

    public void bind() {
        if (!this.isInterleaved) {
            if (this.rtpInPort != null) {
                this.rtpInPort.bind();
            }
            if (this.rtpStream.isRTCP() && this.rtcpInPort != null) {
                this.rtcpInPort.bind();
            }
        }
    }

    public void record(RTPRequestStatus rTPRequestStatus) {
        this.bind();
    }

    public void play(RTPRequestStatus rTPRequestStatus) {
    }

    public void pause(RTPRequestStatus rTPRequestStatus) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimescale() {
        int n = 0;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            n = this.timescale;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimescale(int n) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.timescale = n;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelCount() {
        int n = 0;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            n = this.channelCount;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelCount(int n) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.channelCount = n;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSampleType() {
        String string = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            string = this.sampleType;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSampleType(String string) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.sampleType = string;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    public RTPStream getRTPStream() {
        return this.rtpStream;
    }

    public void clearPorts() {
        this.rtpInPort = null;
        this.rtcpInPort = null;
    }

    public void setup(RTPRequestStatus rTPRequestStatus, String string) {
        try {
            Object object;
            Object object2;
            if (string != null) {
                object2 = string.split("[;]");
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    String string2;
                    String[] stringArray;
                    int n;
                    object = ((String)object2[i]).trim();
                    if (((String)object).startsWith("client_port=")) {
                        n = ((String)object).indexOf("=");
                        if (n < 0) {
                            n = ((String)object).indexOf(":");
                        }
                        if (n < 0 || (stringArray = (string2 = ((String)object).substring(n + 1)).split("[-]")).length < 2) continue;
                        try {
                            this.rtpOutPortNum = Integer.parseInt(stringArray[0]);
                            this.rtcpOutPortNum = Integer.parseInt(stringArray[1]);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!((String)object).startsWith("interleaved=")) continue;
                    this.isInterleaved = true;
                    n = ((String)object).indexOf("=");
                    if (n < 0) {
                        n = ((String)object).indexOf(":");
                    }
                    if (n < 0 || (stringArray = (string2 = ((String)object).substring(n + 1)).split("[-]")).length < 2) continue;
                    try {
                        this.rtpOutPortNum = Integer.parseInt(stringArray[0]);
                        this.rtcpOutPortNum = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            object2 = this.getRTPStream().getRTPContext();
            RTPDePacketizerList rTPDePacketizerList = ((RTPContext)object2).getDePacketizerList();
            object = rTPDePacketizerList.getDePacketizerItem(this.rtpDePacketizerName);
            IApplicationInstance iApplicationInstance = this.getRTPStream().getAppInstance();
            if (object != null) {
                this.rtpDePacketizer = RTPDePacketizerFactory.createInstance((RTPContext)object2, (RTPDePacketizerItem)object, iApplicationInstance);
            } else {
                WMSLoggerFactory.getLogger(RTPTrack.class).warn("Failed to find an appropriate depacketizer for this track (" + this.getSampleType() + "): You may not have the proper software license to use this feature. Please contact sales@wowzamedia.com for more information.");
            }
            if (this.rtpDePacketizer != null) {
                this.rtpDePacketizer.startup(this);
            }
            if (!this.isInterleaved) {
                this.addPorts();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.setup: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public String getAnnounceData() {
        return this.announceData;
    }

    public void setAnnounceData(String string) {
        this.announceData = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRTPDePacketizer getRTPDePacketizer() {
        IRTPDePacketizer iRTPDePacketizer = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            iRTPDePacketizer = this.rtpDePacketizer;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return iRTPDePacketizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRTPDePacketizerName() {
        String string = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            string = this.rtpDePacketizerName;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return string;
    }

    public void setRTPDePacketizerName(String string) {
        this.rtpDePacketizerName = string;
    }

    public void announce(RTPRequestStatus rTPRequestStatus) {
        try {
            if (this.rtpDePacketizerName == null) {
                this.rtpDePacketizerName = this.getRTPStream().getRTPContext().getDePacketizerName(this);
            }
            if (this.rtpDePacketizerName == null) {
                RTSPStatics.setStatus(rTPRequestStatus, 461, "Missing DePacketizer");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.announce: " + exception.toString());
        }
    }

    public String getTransportStr(String string) {
        String string2 = string;
        if (!this.isInterleaved) {
            string2 = string2 + ";source=" + this.getHost() + ";server_port=" + this.getRTPPortId() + "-" + this.getRTCPPortId();
        }
        WMSLoggerFactory.getLogger(RTSPCore.class).debug("RTPTrack.getTransportStr: " + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterleaved(boolean bl) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.isInterleaved = bl;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterleaved() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.isInterleaved;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    public int getSamplesPerFrame() {
        return this.samplesPerFrame;
    }

    public void setSamplesPerFrame(int n) {
        this.samplesPerFrame = n;
    }

    public boolean isWaitForFirstEnd() {
        return this.waitForFirstEnd;
    }

    public void setWaitForFirstEnd(boolean bl) {
        this.waitForFirstEnd = bl;
    }

    public void checkSendMetadata(long l) {
        this.rtpStream.checkSendMetadata(l);
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public void setSSRC(long l) {
        this.ssrc = l;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int n) {
        this.maxPacketSize = n;
    }

    public IRTPPacketizer getRTPPacketizer() {
        return this.rtpPacketizer;
    }

    public void setRTPPacketizer(IRTPPacketizer iRTPPacketizer) {
        this.rtpPacketizer = iRTPPacketizer;
    }

    public RTPPort getRTPOutPort() {
        return this.rtpOutPort;
    }

    public void setRTPOutPort(RTPPort rTPPort) {
        this.rtpOutPort = rTPPort;
    }

    public RTPPort getRTCPOutPort() {
        return this.rtcpOutPort;
    }

    public void setRTCPOutPort(RTPPort rTPPort) {
        this.rtcpOutPort = rTPPort;
    }

    class HandleRTCPMessage
    implements IRTPMessageHandler {
        RTPTrack rtpTrack = null;

        public HandleRTCPMessage(RTPTrack rTPTrack2) {
            this.rtpTrack = rTPTrack2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(SocketAddress socketAddress, byte[] byArray, int n, int n2) {
            this.rtpTrack.getRTPStream().touch();
            WMSReadWriteLock wMSReadWriteLock = this.rtpTrack.getRTPStream().getStreamLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                if (RTPTrack.this.rtpDePacketizer != null) {
                    RTPTrack.this.rtpDePacketizer.handleRTCPPacket(socketAddress, this.rtpTrack, byArray, n, n2);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("HandleRTCPMessage.handleMessage: " + exception.toString());
                exception.printStackTrace();
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
        }
    }

    class HandleRTPMessage
    implements IRTPMessageHandler {
        private RTPTrack rtpTrack = null;

        public HandleRTPMessage(RTPTrack rTPTrack2) {
            this.rtpTrack = rTPTrack2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(SocketAddress socketAddress, byte[] byArray, int n, int n2) {
            this.rtpTrack.getRTPStream().touch();
            WMSReadWriteLock wMSReadWriteLock = this.rtpTrack.getRTPStream().getStreamLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                if (RTPTrack.this.rtpDePacketizer != null) {
                    RTPTrack.this.rtpDePacketizer.handleRTPPacket(socketAddress, this.rtpTrack, byArray, n, n2);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("HandleRTPMessage.handleMessage: " + exception.toString());
                exception.printStackTrace();
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
        }
    }
}

