/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.rtp.model.RTPPort;
import com.wowza.wms.rtp.model.RTPTrack;
import java.util.ArrayList;
import java.util.List;

public abstract class RTPPacketizerBase {
    public static final int RTPHEADERSIZE = 12;
    protected List<PendingBlock> pendingBlocks = new ArrayList<PendingBlock>();
    protected long sequence = 0L;
    protected long ssrc = 0L;

    protected void addPendingBlock(PendingBlock pendingBlock) {
        this.pendingBlocks.add(pendingBlock);
    }

    protected void fillHeader(byte[] byArray, boolean bl, long l, long l2, long l3, int n) {
        byArray[0] = -128;
        byArray[1] = (byte)((bl ? 128 : 0) + n);
        BufferUtils.longToByteArray(l, byArray, 2, 2);
        BufferUtils.longToByteArray(l2, byArray, 4, 4);
        BufferUtils.longToByteArray(l3, byArray, 8, 4);
    }

    protected void writePendingBlocks(RTPTrack rTPTrack, int n) {
        RTPPort rTPPort = rTPTrack.getRTPOutPort();
        int n2 = this.pendingBlocks.size();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                PendingBlock pendingBlock = this.pendingBlocks.get(i);
                this.fillHeader(pendingBlock.block, i == n2 - 1, this.sequence, pendingBlock.timecode, this.ssrc, n);
                ++this.sequence;
                rTPPort.sendMessage(pendingBlock.block, 0, pendingBlock.size);
            }
            this.pendingBlocks.clear();
        }
    }

    protected class PendingBlock {
        byte[] block = null;
        int size = 0;
        long timecode = 0L;

        public PendingBlock(byte[] byArray, int n, long l) {
            this.block = byArray;
            this.size = n;
            this.timecode = l;
        }
    }
}

