/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerAudioBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerMPEG4AAC
extends RTPPacketizerAudioBase
implements IRTPPacketizer {
    private int maxPacketSize = 1438;
    private long ssrc = 0L;
    private long sequence = 0L;
    private List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    private List<RTPPacketizerBase.PendingBlock> pendingBlocks = new ArrayList<RTPPacketizerBase.PendingBlock>();
    private int pendingCount = 0;
    private int pendingSize = 0;
    private long pendingTimecode = -1L;
    private int timescale = -1;
    private int channels = -1;
    private long lastTimecode = -1L;

    public RTPPacketizerMPEG4AAC() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
    }

    public int handleAMFPacket(IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        try {
            if (aMFPacket.getSize() >= 4) {
                AACFrame aACFrame;
                Object object;
                if (this.timescale < 0 && (object = iMediaStream.getAudioCodecConfigPacket(l)) != null && ((AMFPacket)object).getSize() >= 2 && (aACFrame = AACUtils.decodeAACCodecConfig(((AMFPacket)object).getData(), ((AMFPacket)object).getSize() - 2)) != null) {
                    System.out.println(aACFrame.toString() + ":" + DebugUtils.formatBytesShort(((AMFPacket)object).getData()));
                    this.timescale = aACFrame.getSampleRate();
                    this.channels = aACFrame.getChannels();
                }
                if (this.timescale > 0) {
                    object = aMFPacket.getData();
                    int n = 2;
                    int n2 = aMFPacket.getSize() - n;
                    int n3 = n2 << 3;
                    int n4 = 4 + n2;
                    if (n4 > this.maxPacketSize) {
                        int n5;
                        this.flushPending(this.pendingCount, this.pendingSize, this.pendingTimecode * (long)this.timescale / 1000L);
                        this.writePendingBlocks(rTPTrack, 96);
                        this.pendingCount = 0;
                        this.pendingSize = 0;
                        this.pendingTimecode = -1L;
                        int n6 = this.maxPacketSize - 2 - 2;
                        int n7 = n2 / n6 + (n2 % n6 > 0 ? 1 : 0);
                        int n8 = n2 / n7 + (n2 % n7 > 0 ? 1 : 0);
                        int n9 = 0;
                        int n10 = 0;
                        do {
                            if (n9 + (n5 = n8) > n2) {
                                n5 = n2 - n9;
                            }
                            int n11 = 16 + n5;
                            byte[] byArray = new byte[n11];
                            this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n11, l * (long)this.timescale / 1000L));
                            BufferUtils.intToByteArray(16, byArray, 12, 2);
                            BufferUtils.intToByteArray(n3, byArray, 14, 2);
                            System.arraycopy(object, n + n9, byArray, 16, n5);
                            ++n10;
                        } while ((n9 += n5) < n2);
                        this.writePendingBlocks(rTPTrack, 96);
                    } else {
                        int n12 = 2 + 2 * (this.pendingCount + 1) + (this.pendingSize + n2);
                        if (n12 > this.maxPacketSize) {
                            this.flushPending(this.pendingCount, this.pendingSize, this.pendingTimecode * (long)this.timescale / 1000L);
                            this.writePendingBlocks(rTPTrack, 96);
                            this.pendingCount = 0;
                            this.pendingSize = 0;
                            this.pendingTimecode = -1L;
                        }
                        this.pendingFragments.add(new RTPPacketFragment((byte[])object, n, n2));
                        ++this.pendingCount;
                        this.pendingSize += n2;
                        if (this.pendingTimecode < 0L) {
                            this.pendingTimecode = l;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return 0;
    }

    private void flushPending(int n, int n2, long l) {
        block2: {
            RTPPacketFragment rTPPacketFragment;
            int n3;
            int n4 = this.pendingFragments.size();
            if (n4 <= 0) break block2;
            int n5 = 14 + 2 * n + n2;
            byte[] byArray = new byte[n5];
            this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n5, l));
            int n6 = 0;
            BufferUtils.intToByteArray(2 * n * 8, byArray, 12 + n6, 2);
            n6 += 2;
            for (n3 = 0; n3 < n4; ++n3) {
                rTPPacketFragment = this.pendingFragments.get(n3);
                int n7 = rTPPacketFragment.getLen() << 3;
                BufferUtils.intToByteArray(n7, byArray, 12 + n6, 2);
                n6 += 2;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                rTPPacketFragment = this.pendingFragments.get(n3);
                System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12 + n6, rTPPacketFragment.getLen());
                n6 += rTPPacketFragment.getLen();
            }
            this.pendingFragments.clear();
        }
    }

    public int flushPackets(IMediaStream iMediaStream, RTPTrack rTPTrack) {
        if (this.pendingCount > 0) {
            this.flushPending(this.pendingCount, this.pendingSize, this.pendingTimecode * (long)this.timescale / 1000L);
            this.writePendingBlocks(rTPTrack, 96);
            this.pendingCount = 0;
            this.pendingSize = 0;
            this.pendingTimecode = -1L;
        }
        return 0;
    }
}

