/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerVideoBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerRFC3984H264
extends RTPPacketizerVideoBase
implements IRTPPacketizer {
    private int maxPacketSize = 1438;
    private List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();

    public RTPPacketizerRFC3984H264() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
    }

    public int handleAMFPacket(IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        try {
            if (aMFPacket.getSize() >= 9) {
                int n = aMFPacket.getFirstByte();
                int n2 = aMFPacket.getSecondByte();
                int n3 = FLVUtils.getVideoCodec(n);
                if (n3 != 7 || n2 == 1) {
                    long l2 = l * 90L;
                    int n4 = 0;
                    int n5 = 0;
                    byte[] byArray = aMFPacket.getData();
                    int n6 = aMFPacket.getSize();
                    int n7 = 5;
                    while (n7 + 4 <= n6) {
                        int n8;
                        int n9 = BufferUtils.byteArrayToInt(byArray, n7, 4);
                        if (n9 <= 0 || (n7 += 4) + n9 > n6) break;
                        if (n9 > this.maxPacketSize) {
                            int n10;
                            this.flushPending(n4, n5, l2);
                            n4 = 0;
                            n5 = 0;
                            n8 = (n9 - 1) / (this.maxPacketSize - 2) + ((n9 - 1) % (this.maxPacketSize - 2) > 0 ? 1 : 0);
                            int n11 = (n9 - 1) / n8 + ((n9 - 1) % n8 > 0 ? 1 : 0);
                            int n12 = 1;
                            byte by = byArray[n7];
                            int n13 = 0;
                            do {
                                if (n12 + (n10 = n11) > n9) {
                                    n10 = n9 - n12;
                                }
                                int n14 = 14 + n10;
                                byte[] byArray2 = new byte[n14];
                                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n14, l2));
                                byArray2[12] = (byte)((by & 0xE0) + 28);
                                byArray2[13] = (byte)((n13 == 0 ? 128 : 0) + (n12 + n10 == n9 ? 64 : 0) + (by & 0x1F));
                                System.arraycopy(byArray, n7 + n12, byArray2, 14, n10);
                                ++n13;
                            } while ((n12 += n10) < n9);
                        } else {
                            n8 = 1 + 2 * (n4 + 1) + (n5 + n9);
                            if (n8 > this.maxPacketSize) {
                                this.flushPending(n4, n5, l2);
                                n4 = 0;
                                n5 = 0;
                            }
                            this.pendingFragments.add(new RTPPacketFragment(byArray, n7, n9));
                            ++n4;
                            n5 += n9;
                        }
                        if ((n7 += n9) < n6) continue;
                        break;
                    }
                    this.flushPending(n4, n5, l2);
                    n4 = 0;
                    n5 = 0;
                    this.writePendingBlocks(rTPTrack, 97);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRFC3984H264.class).error("RTPPacketizerRFC3984H264.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return 0;
    }

    private void flushPending(int n, int n2, long l) {
        int n3 = this.pendingFragments.size();
        if (n3 > 0) {
            if (n3 == 1) {
                RTPPacketFragment rTPPacketFragment = this.pendingFragments.remove(0);
                int n4 = 12 + rTPPacketFragment.getLen();
                byte[] byArray = new byte[n4];
                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n4, l));
                System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12, rTPPacketFragment.getLen());
            } else {
                int n5 = 13 + 2 * n + n2;
                byte[] byArray = new byte[n5];
                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n5, l));
                byArray[12] = 24;
                int n6 = 1;
                while (n3 > 0) {
                    RTPPacketFragment rTPPacketFragment = this.pendingFragments.remove(0);
                    BufferUtils.intToByteArray(rTPPacketFragment.getLen(), byArray, 12 + n6, 2);
                    System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12 + (n6 += 2), rTPPacketFragment.getLen());
                    n6 += rTPPacketFragment.getLen();
                    --n3;
                }
            }
        }
    }

    public int flushPackets(IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }
}

